/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.server.entity;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.mgmt.internal.LocalSubscriptionManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.server.entity.BrooklynMetrics;
import org.apache.brooklyn.util.core.task.BasicExecutionManager;

public class BrooklynMetricsImpl
extends AbstractEntity
implements BrooklynMetrics {
    private ScheduledExecutorService executor;

    @Override
    public void onManagementBecomingMaster() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("brooklyn-brooklynmetrics-poller-%d").build();
        this.executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                BrooklynMetricsImpl.this.refreshSensors();
            }
        }, 0L, (Long)this.getConfig(UPDATE_PERIOD), TimeUnit.MILLISECONDS);
    }

    @Override
    public void onManagementNoLongerMaster() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    private void refreshSensors() {
        ManagementContext managementContext = this.getManagementContext();
        BasicExecutionManager execManager = (BasicExecutionManager)(managementContext != null ? managementContext.getExecutionManager() : null);
        LocalSubscriptionManager subsManager = (LocalSubscriptionManager)(managementContext != null ? managementContext.getSubscriptionManager() : null);
        if (managementContext != null) {
            this.sensors().set(TOTAL_EFFECTORS_INVOKED, ((ManagementContextInternal)managementContext).getTotalEffectorInvocations());
        }
        if (execManager != null) {
            this.sensors().set(TOTAL_TASKS_SUBMITTED, execManager.getTotalTasksSubmitted());
            this.sensors().set(NUM_INCOMPLETE_TASKS, execManager.getNumIncompleteTasks());
            this.sensors().set(NUM_ACTIVE_TASKS, execManager.getNumActiveTasks());
        }
        if (subsManager != null) {
            this.sensors().set(TOTAL_EVENTS_PUBLISHED, subsManager.getTotalEventsPublished());
            this.sensors().set(TOTAL_EVENTS_DELIVERED, subsManager.getTotalEventsDelivered());
            this.sensors().set(NUM_SUBSCRIPTIONS, subsManager.getNumSubscriptions());
        }
    }
}

