/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityAdjuncts;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.resolve.jackson.JsonPassThroughDeserializer;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.workflow.DanglingWorkflowException;
import org.apache.brooklyn.core.workflow.WorkflowCommonConfig;
import org.apache.brooklyn.core.workflow.WorkflowErrorHandling;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowReplayUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.apache.brooklyn.core.workflow.store.WorkflowRetentionAndExpiration;
import org.apache.brooklyn.core.workflow.store.WorkflowStatePersistenceViaSensors;
import org.apache.brooklyn.core.workflow.utils.WorkflowRetentionParser;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Threads;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(converter=Converter.class)
public class WorkflowExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecutionContext.class);
    public static final String LABEL_FOR_ERROR_HANDLER = "error-handler";
    public static final int STEP_INDEX_FOR_START = -1;
    public static final int STEP_INDEX_FOR_END = -2;
    public static final int STEP_INDEX_FOR_ERROR_HANDLER = -3;
    public static final String STEP_TARGET_NAME_FOR_START = "start";
    public static final String STEP_TARGET_NAME_FOR_END = "end";
    public static final String STEP_TARGET_NAME_FOR_LAST = "last";
    public static final String STEP_TARGET_NAME_FOR_HERE = "here";
    public static final String STEP_TARGET_NAME_FOR_EXIT = "exit";
    public static final String STEP_TARGET_NAME_FOR_DEFAULT = "default";
    public static final Map<String, Function<WorkflowExecutionContext, Integer>> PREDEFINED_NEXT_TARGETS = MutableMap.of((Object)"start", c -> c == null ? -1 : 0, (Object)"end", c -> c == null ? -2 : c.stepsDefinition.size(), (Object)"last", c -> c == null ? null : c.replayableLastStep, (Object)"here", c -> c == null ? null : null, (Object)"exit", c -> c == null ? null : null, (Object)"default", c -> c == null ? null : Integer.valueOf(c.currentStepIndex + 1)).asUnmodifiable();
    String name;
    @Nullable
    BrooklynObject adjunct;
    Entity entity;
    WorkflowStatus status;
    Instant lastStatusChangeTime;
    @JsonIgnore
    private transient WorkflowExecutionContext parent;
    private BrooklynTaskTags.WorkflowTaskTag parentTag;
    @JsonDeserialize(contentUsing=JsonPassThroughDeserializer.class)
    List<Object> stepsDefinition;
    Object condition;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    Map<String, Object> input = MutableMap.of();
    @JsonIgnore
    Map<String, Object> inputResolved = MutableMap.of();
    Object outputDefinition;
    Object output;
    Object lock;
    Duration timeout;
    Object onError;
    String workflowId;
    String taskId;
    transient Task<Object> task;
    @JsonProperty(value="retention")
    WorkflowRetentionAndExpiration.WorkflowRetentionSettings retention;
    Set<WorkflowReplayUtils.WorkflowReplayRecord> replays = MutableSet.of();
    transient WorkflowReplayUtils.WorkflowReplayRecord replayCurrent = null;
    Integer replayableLastStep;
    Boolean replayableFromStart;
    Boolean replayableAutomatically;
    Boolean replayableDisabled;
    Boolean idempotentAll;
    Integer currentStepIndex;
    Integer previousStepIndex;
    String previousStepTaskId;
    WorkflowStepInstanceExecutionContext currentStepInstance;
    String errorHandlerTaskId;
    WorkflowStepInstanceExecutionContext errorHandlerContext;
    Map<Integer, OldStepRecord> oldStepInfo = MutableMap.of();
    transient Map<String, Object> workflowScratchVariables;
    transient Map<String, Object> workflowScratchVariablesUpdatedThisStep;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    Map<String, List<Instant>> retryRecords = MutableMap.of();
    transient Object lastErrorHandlerOutput = null;
    @JsonIgnore
    private transient WorkflowRetentionAndExpiration.WorkflowRetentionSettings retentionDefault;
    transient Map<String, Pair<Integer, WorkflowStepDefinition>> stepsWithExplicitId;
    transient List<WorkflowStepDefinition> stepsResolved;

    @JsonSetter(value="workflowScratchVariables")
    public void setWorkflowScratchVariablesToDeserializeOld(Map<String, Object> workflowScratchVariables) {
        this.workflowScratchVariables = workflowScratchVariables;
    }

    private WorkflowExecutionContext() {
    }

    public static WorkflowExecutionContext newInstancePersisted(BrooklynObject entityOrAdjunctWhereRunning, WorkflowContextType wcType, String name, ConfigBag paramsDefiningWorkflow, Collection<ConfigKey<?>> extraConfigKeys, ConfigBag extraInputs, Map<String, Object> optionalTaskFlags) {
        WorkflowExecutionContext w = WorkflowExecutionContext.newInstanceUnpersistedWithParent(entityOrAdjunctWhereRunning, null, wcType, name, paramsDefiningWorkflow, extraConfigKeys, extraInputs, optionalTaskFlags);
        w.persist();
        return w;
    }

    public static WorkflowExecutionContext newInstanceUnpersistedWithParent(BrooklynObject entityOrAdjunctWhereRunning, WorkflowExecutionContext parent, WorkflowContextType wcType, String name, ConfigBag paramsDefiningWorkflow, Collection<ConfigKey<?>> extraConfigKeys, ConfigBag extraInputs, Map<String, Object> optionalTaskFlags) {
        return WorkflowExecutionContext.newInstanceUnpersistedWithParent(entityOrAdjunctWhereRunning, parent, wcType, name, paramsDefiningWorkflow, extraConfigKeys, extraInputs, optionalTaskFlags, null);
    }

    public static WorkflowExecutionContext newInstanceUnpersistedWithParent(BrooklynObject entityOrAdjunctWhereRunning, WorkflowExecutionContext parent, WorkflowContextType wcType, String name, ConfigBag paramsDefiningWorkflow, Collection<ConfigKey<?>> extraConfigKeys, ConfigBag extraInputs, Map<String, Object> optionalTaskFlags, String optionalTaskName) {
        MutableMap parameters = MutableMap.of();
        Maybe<BrooklynClassLoadingContext> loader = RegisteredTypes.getClassLoadingContextMaybe(entityOrAdjunctWhereRunning);
        Effectors.parseParameters(paramsDefiningWorkflow.get(WorkflowCommonConfig.PARAMETER_DEFS), (BrooklynClassLoadingContext)loader.orNull()).forEach(arg_0 -> WorkflowExecutionContext.lambda$newInstanceUnpersistedWithParent$6((Map)parameters, arg_0));
        if (extraConfigKeys != null) {
            extraConfigKeys.forEach(arg_0 -> WorkflowExecutionContext.lambda$newInstanceUnpersistedWithParent$7((Map)parameters, arg_0));
        }
        ConfigBag inputRaw = ConfigBag.newInstance();
        inputRaw.putAll(paramsDefiningWorkflow.get(WorkflowCommonConfig.INPUT));
        if (extraInputs != null) {
            inputRaw.putAll(extraInputs.getAllConfig());
        }
        parameters.values().forEach(p -> {
            if (p.hasDefaultValue() && !inputRaw.containsKey(p.getName())) {
                inputRaw.put(p, p.getDefaultValue());
            }
        });
        MutableMap input = MutableMap.of();
        inputRaw.forEach((arg_0, arg_1) -> WorkflowExecutionContext.lambda$newInstanceUnpersistedWithParent$9((Map)parameters, inputRaw, input, arg_0, arg_1));
        WorkflowExecutionContext w = new WorkflowExecutionContext(entityOrAdjunctWhereRunning, parent, name, paramsDefiningWorkflow.get(WorkflowCommonConfig.STEPS), (Map<String, Object>)input, paramsDefiningWorkflow.get(WorkflowCommonConfig.OUTPUT), WorkflowReplayUtils.updaterForReplayableAtWorkflow(paramsDefiningWorkflow, wcType == WorkflowContextType.NESTED_WORKFLOW), optionalTaskFlags, optionalTaskName);
        w.getStepsResolved();
        w.retention = WorkflowRetentionParser.parse(paramsDefiningWorkflow.get(WorkflowCommonConfig.RETENTION), w).init(w);
        w.lock = paramsDefiningWorkflow.get(WorkflowCommonConfig.LOCK);
        w.timeout = paramsDefiningWorkflow.get(WorkflowCommonConfig.TIMEOUT);
        w.onError = paramsDefiningWorkflow.get(WorkflowCommonConfig.ON_ERROR);
        WorkflowStepResolution.resolveSubSteps(w.getManagementContext(), "error handling", WorkflowErrorHandling.wrappedInListIfNecessaryOrNullIfEmpty(w.onError));
        w.setCondition(paramsDefiningWorkflow.getStringKey(WorkflowCommonConfig.CONDITION.getName()));
        w.updateStatus(WorkflowStatus.STAGED);
        return w;
    }

    protected WorkflowExecutionContext(BrooklynObject entityOrAdjunctWhereRunning, WorkflowExecutionContext parent, String name, List<Object> stepsDefinition, Map<String, Object> input, Object output, Consumer<WorkflowExecutionContext> replayableInitializer, Map<String, Object> optionalTaskFlags) {
        this(entityOrAdjunctWhereRunning, parent, name, stepsDefinition, input, output, replayableInitializer, optionalTaskFlags, null);
    }

    protected WorkflowExecutionContext(BrooklynObject entityOrAdjunctWhereRunning, WorkflowExecutionContext parent, String name, List<Object> stepsDefinition, Map<String, Object> input, Object output, Consumer<WorkflowExecutionContext> replayableInitializer, Map<String, Object> optionalTaskFlags, String optionalTaskName) {
        this.initParent(parent);
        this.name = name;
        this.adjunct = entityOrAdjunctWhereRunning instanceof Entity ? null : entityOrAdjunctWhereRunning;
        this.entity = entityOrAdjunctWhereRunning instanceof Entity ? (Entity)entityOrAdjunctWhereRunning : ((EntityAdjuncts.EntityAdjunctProxyable)entityOrAdjunctWhereRunning).getEntity();
        this.stepsDefinition = stepsDefinition;
        this.input = input;
        this.outputDefinition = output;
        if (replayableInitializer != null) {
            replayableInitializer.accept(this);
        }
        TaskBuilder<Object> tb = Tasks.builder().displayName(optionalTaskName).dynamic(true);
        if (optionalTaskFlags != null) {
            tb.flags(optionalTaskFlags);
        }
        if (Strings.isBlank((CharSequence)tb.getDisplayName())) {
            tb.displayName(name);
        }
        this.task = tb.body(new Body()).build();
        WorkflowReplayUtils.updateOnWorkflowStartOrReplay(this, this.task, "initial run", null);
        this.workflowId = this.taskId = this.task.getId();
        TaskTags.addTagDynamically(this.task, "WORKFLOW");
        TaskTags.addTagDynamically(this.task, BrooklynTaskTags.tagForWorkflow(this));
    }

    public void initParent(WorkflowExecutionContext parent) {
        this.parent = parent;
        this.parentTag = parent == null ? null : BrooklynTaskTags.tagForWorkflow(parent);
    }

    @JsonIgnore
    public WorkflowExecutionContext getParent() {
        if (this.parent == null && this.parentTag != null) {
            Entity entity = this.getManagementContext().getEntityManager().getEntity(this.parentTag.getEntityId());
            if (entity == null) {
                log.warn("Parent workflow " + this.parentTag + " for " + this + " is on an entity no longer known; unparenting this workflow");
                this.parentTag = null;
            } else {
                this.parent = new WorkflowStatePersistenceViaSensors(this.getManagementContext()).getWorkflows(entity).get(this.parentTag.getWorkflowId());
                if (this.parent == null) {
                    log.warn("Parent workflow " + this.parentTag + " for " + this + " is no longer known; unparenting this workflow");
                    this.parentTag = null;
                }
            }
        }
        return this.parent;
    }

    public static void validateSteps(ManagementContext mgmt, List<WorkflowStepDefinition> steps, boolean alreadyValidatedIndividualSteps) {
        if (!alreadyValidatedIndividualSteps) {
            steps.forEach(w -> w.validateStep(mgmt, null));
        }
        WorkflowExecutionContext.computeStepsWithExplicitIdById(steps);
    }

    static Map<String, Pair<Integer, WorkflowStepDefinition>> computeStepsWithExplicitIdById(List<WorkflowStepDefinition> steps) {
        MutableMap stepsWithExplicitId = MutableMap.of();
        for (int i = 0; i < steps.size(); ++i) {
            WorkflowStepDefinition s = steps.get(i);
            if (s.id == null) continue;
            if (PREDEFINED_NEXT_TARGETS.containsKey(s.id.toLowerCase())) {
                throw new IllegalStateException("Token '" + s + "' is a reserved word and cannot be used as a step ID");
            }
            Pair old = stepsWithExplicitId.put(s.id, Pair.of((Object)i, (Object)s));
            if (old == null) continue;
            throw new IllegalStateException("Same step ID '" + s + "' used for multiple steps (" + ((Integer)old.getLeft() + 1) + " and " + (i + 1) + ")");
        }
        return stepsWithExplicitId;
    }

    public void setCondition(Object condition) {
        this.condition = condition;
    }

    public String toString() {
        return "Workflow<" + this.name + " - " + this.workflowId + ">";
    }

    @JsonIgnore
    public BrooklynObject getEntityOrAdjunctWhereRunning() {
        if (this.adjunct != null) {
            return this.adjunct;
        }
        return this.entity;
    }

    public BrooklynTaskTags.WorkflowTaskTag getParentTag() {
        return this.parentTag;
    }

    @JsonIgnore
    public Map<String, Object> getWorkflowScratchVariables() {
        if (this.workflowScratchVariables == null) {
            Pair<Map<String, Object>, Set<Integer>> prev = this.getStepWorkflowScratchAndBacktrackedSteps(null);
            this.workflowScratchVariables = (Map)prev.getLeft();
        }
        return MutableMap.copyOf(this.workflowScratchVariables).asUnmodifiable();
    }

    public Object updateWorkflowScratchVariable(String s, Object v) {
        if (this.workflowScratchVariables == null) {
            this.getWorkflowScratchVariables();
        }
        Object old = this.workflowScratchVariables.put(s, v);
        if (v == null) {
            this.workflowScratchVariables.remove(s);
        }
        if (this.workflowScratchVariablesUpdatedThisStep == null) {
            this.workflowScratchVariablesUpdatedThisStep = MutableMap.of();
        }
        this.workflowScratchVariablesUpdatedThisStep.put(s, v);
        return old;
    }

    public void updateWorkflowScratchVariables(Map<String, Object> newValues) {
        if (newValues != null && !newValues.isEmpty()) {
            if (this.workflowScratchVariables == null) {
                this.getWorkflowScratchVariables();
            }
            this.workflowScratchVariables.putAll(newValues);
            if (this.workflowScratchVariablesUpdatedThisStep == null) {
                this.workflowScratchVariablesUpdatedThisStep = MutableMap.of();
            }
            this.workflowScratchVariablesUpdatedThisStep.putAll(newValues);
        }
    }

    public Map<String, List<Instant>> getRetryRecords() {
        return this.retryRecords;
    }

    public Maybe<Task<Object>> getTask(boolean checkCondition) {
        if (checkCondition) {
            return this.getTaskCheckingConditionWithTarget(this.getEntityOrAdjunctWhereRunning());
        }
        return this.getTaskSkippingCondition();
    }

    DslPredicates.DslPredicate resolveCondition(Object condition) {
        if (condition == null) {
            return null;
        }
        return (DslPredicates.DslPredicate)this.resolveWrapped(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, condition, TypeToken.of(DslPredicates.DslPredicate.class), WorkflowExpressionResolution.WrappingMode.WRAPPED_RESULT_DEFER_THROWING_ERROR_BUT_NO_RETRY);
    }

    public Maybe<Task<Object>> getTaskCheckingConditionWithTarget(Object conditionTarget) {
        DslPredicates.DslPredicate conditionResolved = this.resolveCondition(this.condition);
        if (conditionResolved != null && !conditionResolved.apply(conditionTarget)) {
            return Maybe.absent((Throwable)new IllegalStateException("This workflow cannot be run at present: condition not satisfied"));
        }
        return this.getTaskSkippingCondition();
    }

    @JsonIgnore
    public Maybe<Task<Object>> getTaskSkippingCondition() {
        if (this.task == null) {
            if (this.taskId != null) {
                this.task = this.getManagementContext().getExecutionManager().getTask(this.taskId);
            }
            if (this.task == null) {
                return Maybe.absent((Throwable)new IllegalStateException("Task for " + this + " no longer available"));
            }
        }
        return Maybe.of(this.task);
    }

    public Factory factory(boolean allowInternallyEvenIfDisabled) {
        return new Factory(allowInternallyEvenIfDisabled);
    }

    private boolean isSubmitterAncestor(Task current, Task<Object> possibleAncestor) {
        if (current == null) {
            return false;
        }
        if (current.equals(possibleAncestor)) {
            return true;
        }
        return this.isSubmitterAncestor(current.getSubmittedByTask(), possibleAncestor);
    }

    public Entity getEntity() {
        return this.entity;
    }

    @JsonIgnore
    public ManagementContext getManagementContext() {
        return ((EntityInternal)this.getEntity()).getManagementContext();
    }

    @JsonIgnore
    protected WorkflowStatePersistenceViaSensors getPersister() {
        return new WorkflowStatePersistenceViaSensors(this.getManagementContext());
    }

    public void persist() {
        if (this.isInErrorHandlerSubWorkflow()) {
            return;
        }
        this.getPersister().checkpoint(this);
    }

    public Object getInput(String key) {
        return this.getInputMaybe(key, TypeToken.of(Object.class), Maybe.ofAllowingNull(null)).get();
    }

    public <T> Maybe<T> getInputMaybe(String key, TypeToken<T> type, Maybe<T> valueIfUndefined) {
        Maybe<T> vm2;
        if (!this.input.containsKey(key)) {
            return valueIfUndefined;
        }
        if (this.inputResolved.containsKey(key)) {
            return Maybe.ofAllowingNull((Object)this.inputResolved.get(key));
        }
        Object v = this.input.get(key);
        Maybe<T> vm = null;
        if (v instanceof String && this.parent != null && this.parent.getCurrentStepInstance() != null) {
            try {
                vm = Maybe.of(this.parent.getCurrentStepInstance().resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, (Object)((String)v), type));
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                vm = Maybe.absent((Throwable)e);
            }
        }
        if ((vm == null || vm.isAbsent()) && ((vm2 = Tasks.resolving(v).as(type).context(this.getEntity()).immediately(true).deep().getMaybe()).isPresent() || vm == null)) {
            vm = vm2;
        }
        if (vm.isPresent()) {
            this.inputResolved.put(key, vm.get());
        }
        return vm;
    }

    public TypeToken<?> lookupType(String typeName, Supplier<TypeToken<?>> ifUnset) {
        if (Strings.isBlank((CharSequence)typeName)) {
            return ifUnset.get();
        }
        BrooklynClassLoadingContext loader = this.getEntity() != null ? RegisteredTypes.getClassLoadingContext(this.getEntity()) : null;
        return new BrooklynTypeNameResolution.BrooklynTypeNameResolver("workflow", loader, true, true).getTypeToken(typeName);
    }

    public Object resolve(WorkflowExpressionResolution.WorkflowExpressionStage stage, String expression) {
        return this.resolve(stage, (Object)expression, Object.class);
    }

    public <T> T resolve(WorkflowExpressionResolution.WorkflowExpressionStage stage, Object expression, Class<T> type) {
        return this.resolve(stage, expression, TypeToken.of(type));
    }

    public <T> T resolve(WorkflowExpressionResolution.WorkflowExpressionStage stage, Object expression, TypeToken<T> type) {
        return new WorkflowExpressionResolution(this, stage, false, WorkflowExpressionResolution.WrappingMode.NONE).resolveWithTemplates(expression, type);
    }

    public <T> T resolveCoercingOnly(WorkflowExpressionResolution.WorkflowExpressionStage stage, Object expression, TypeToken<T> type) {
        return new WorkflowExpressionResolution(this, stage, false, WorkflowExpressionResolution.WrappingMode.NONE).resolveCoercingOnly(expression, type);
    }

    public <T> T resolveWrapped(WorkflowExpressionResolution.WorkflowExpressionStage stage, Object expression, TypeToken<T> type, WorkflowExpressionResolution.WrappingMode wrappingMode) {
        return new WorkflowExpressionResolution(this, stage, false, wrappingMode).resolveWithTemplates(expression, type);
    }

    public <T> T resolveWaiting(WorkflowExpressionResolution.WorkflowExpressionStage stage, Object expression, TypeToken<T> type) {
        return new WorkflowExpressionResolution(this, stage, true, WorkflowExpressionResolution.WrappingMode.NONE).resolveWithTemplates(expression, type);
    }

    public <T> T resolveConfig(WorkflowExpressionResolution.WorkflowExpressionStage stage, ConfigBag config, ConfigKey<T> key) {
        Object v = config.getStringKey(key.getName());
        if (v == null) {
            return null;
        }
        return this.resolve(stage, v, key.getTypeToken());
    }

    public WorkflowStatus getStatus() {
        return this.status;
    }

    void updateStatus(WorkflowStatus newStatus) {
        this.status = newStatus;
        this.lastStatusChangeTime = Instant.now();
    }

    @JsonIgnore
    public Instant getLastStatusChangeTime() {
        return this.lastStatusChangeTime;
    }

    public Integer getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public WorkflowStepInstanceExecutionContext getCurrentStepInstance() {
        return this.currentStepInstance;
    }

    public Integer getPreviousStepIndex() {
        return this.previousStepIndex;
    }

    @JsonIgnore
    public Object getPreviousStepOutput() {
        Pair<Object, Set<Integer>> p = this.getStepOutputAndBacktrackedSteps(null);
        if (p == null) {
            return null;
        }
        return p.getLeft();
    }

    @JsonIgnore
    Pair<Object, Set<Integer>> getStepOutputAndBacktrackedSteps(Integer stepOrNullForPrevious) {
        OldStepRecord last;
        if (stepOrNullForPrevious == null && this.lastErrorHandlerOutput != null) {
            return Pair.of((Object)this.lastErrorHandlerOutput, null);
        }
        Integer prevSI = stepOrNullForPrevious == null ? this.previousStepIndex : stepOrNullForPrevious;
        MutableSet previousSteps = MutableSet.of();
        while (prevSI != null && previousSteps.add(prevSI) && (last = this.oldStepInfo.get(prevSI)) != null && last.context != null) {
            if (last.context.getOutput() != null) {
                return Pair.of((Object)last.context.getOutput(), (Object)previousSteps);
            }
            if (last.previous.isEmpty()) break;
            prevSI = last.previous.iterator().next();
        }
        return null;
    }

    @JsonIgnore
    public Pair<Map<String, Object>, Set<Integer>> getStepWorkflowScratchAndBacktrackedSteps(Integer stepOrNullForPrevious) {
        OldStepRecord last;
        boolean includeUpdates;
        Integer prevSI = stepOrNullForPrevious == null ? this.previousStepIndex : stepOrNullForPrevious;
        MutableSet previousSteps = MutableSet.of();
        MutableMap result = MutableMap.of();
        boolean bl = includeUpdates = stepOrNullForPrevious == null;
        while (prevSI != null && previousSteps.add(prevSI) && (last = this.oldStepInfo.get(prevSI)) != null) {
            if (includeUpdates && last.workflowScratchUpdates != null) {
                result = MutableMap.copyOf(last.workflowScratchUpdates).add((Map)result);
            }
            includeUpdates = true;
            if (last.workflowScratch != null) {
                result = MutableMap.copyOf(last.workflowScratch).add((Map)result);
                result.entrySet().stream().filter(e -> e.getValue() == null).map(Map.Entry::getKey).forEach(((Map)result)::remove);
                break;
            }
            if (last.previous == null || last.previous.isEmpty()) break;
            prevSI = last.previous.iterator().next();
        }
        return Pair.of((Object)result, (Object)previousSteps);
    }

    public Object getOutput() {
        return this.output;
    }

    public static void checkEqual(Object o1, Object o2) {
        if (!Objects.equals(o1, o2)) {
            log.warn("Objects different: " + o1 + " / " + o2);
            throw new IllegalStateException("Objects different: " + o1 + " / " + o2);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Set<WorkflowReplayUtils.WorkflowReplayRecord> getReplays() {
        return this.replays;
    }

    public Integer getReplayableLastStep() {
        return this.replayableLastStep;
    }

    public WorkflowStepInstanceExecutionContext getErrorHandlerContext() {
        return this.errorHandlerContext;
    }

    @JsonIgnore
    public String getRetentionHash() {
        if (this.retention != null && Strings.isNonBlank((CharSequence)this.retention.hash)) {
            return this.retention.hash;
        }
        if (Strings.isNonBlank((CharSequence)this.getName())) {
            return this.getName();
        }
        return "anonymous-workflow-" + Math.abs(this.getStepsDefinition().hashCode());
    }

    public void updateRetentionFrom(WorkflowRetentionAndExpiration.WorkflowRetentionSettings other) {
        WorkflowRetentionAndExpiration.WorkflowRetentionSettings r = this.getRetentionSettings();
        r.updateFrom(other);
        this.retention = r;
        this.retentionDefault = null;
    }

    @JsonIgnore
    public WorkflowRetentionAndExpiration.WorkflowRetentionSettings getRetentionSettings() {
        if (this.retention == null) {
            if (this.retentionDefault == null) {
                this.retentionDefault = new WorkflowRetentionAndExpiration.WorkflowRetentionSettings().init(this);
            }
            return this.retentionDefault;
        }
        return this.retention;
    }

    public void markShutdown() {
        log.debug(this + " was " + (Object)((Object)this.status) + " but now marking as " + (Object)((Object)WorkflowStatus.ERROR_SHUTDOWN) + "; compensating workflow should be triggered shortly");
        this.updateStatus(WorkflowStatus.ERROR_SHUTDOWN);
    }

    @JsonIgnore
    protected boolean isInErrorHandlerSubWorkflow() {
        if (this.getParent() != null) {
            if (this.getParent().getErrorHandlerContext() != null) {
                return true;
            }
            return this.getParent().isInErrorHandlerSubWorkflow();
        }
        return false;
    }

    private void setMostRecentActivityTime(Object ignored) {
    }

    public long getMostRecentActivityTime() {
        AtomicLong result = new AtomicLong(-1L);
        Consumer<Long> consider = l -> {
            if (l != null && l > result.get()) {
                result.set((long)l);
            }
        };
        Consumer<Task> considerTask = task -> {
            if (task != null) {
                consider.accept(task.getEndTimeUtc());
                consider.accept(task.getStartTimeUtc());
                consider.accept(task.getSubmitTimeUtc());
            }
        };
        considerTask.accept((Task)this.getTask(false).orNull());
        Consumer<WorkflowReplayUtils.WorkflowReplayRecord> considerReplay = replay -> {
            if (replay != null) {
                consider.accept(replay.endTimeUtc);
                consider.accept(replay.startTimeUtc);
                consider.accept(replay.submitTimeUtc);
            }
        };
        if (this.replayCurrent != null) {
            considerReplay.accept(this.replayCurrent);
        } else if (!this.replays.isEmpty()) {
            considerReplay.accept((WorkflowReplayUtils.WorkflowReplayRecord)Iterables.getLast(this.replays));
        }
        if (this.currentStepInstance != null) {
            Task lastTask = null;
            try {
                lastTask = this.getManagementContext().getExecutionManager().getTask(this.currentStepInstance.getTaskId());
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
            }
            considerTask.accept(lastTask);
        }
        return result.get();
    }

    public List<Object> getStepsDefinition() {
        return MutableList.copyOf(this.stepsDefinition).asUnmodifiable();
    }

    @JsonIgnore
    List<WorkflowStepDefinition> getStepsResolved() {
        if (this.stepsResolved == null) {
            this.stepsResolved = MutableList.copyOf(WorkflowStepResolution.resolveSteps(this.getManagementContext(), this.stepsDefinition, this.outputDefinition));
        }
        return this.stepsResolved;
    }

    @JsonIgnore
    public Map<String, Pair<Integer, WorkflowStepDefinition>> getStepsWithExplicitIdById() {
        if (this.stepsWithExplicitId == null) {
            this.stepsWithExplicitId = WorkflowExecutionContext.computeStepsWithExplicitIdById(this.getStepsResolved());
        }
        return this.stepsWithExplicitId;
    }

    private void updateStepOutput(WorkflowStepInstanceExecutionContext step, Object newOutput) {
        step.output = step.outputOld = newOutput;
    }

    private void updateOldNextStepOnThisStepStarting() {
        Integer lastNext;
        OldStepRecord oldNext;
        OldStepRecord old = this.oldStepInfo.get(this.currentStepInstance.stepIndex);
        if (old != null && old.next != null && !old.next.isEmpty() && (oldNext = this.oldStepInfo.get(lastNext = old.next.iterator().next())) != null && oldNext.context != null) {
            if (oldNext.context.output == null) {
                oldNext.context.output = old.context.output;
            }
            oldNext.workflowScratch = this.getWorkflowScratchVariables();
        }
    }

    public Maybe<Pair<Integer, Boolean>> getIndexOfStepId(String next) {
        if (next == null) {
            return Maybe.absent((String)"Null step ID supplied");
        }
        Function<WorkflowExecutionContext, Integer> predefined = PREDEFINED_NEXT_TARGETS.get(next.toLowerCase());
        if (predefined != null) {
            return Maybe.of((Object)Pair.of((Object)predefined.apply(this), (Object)true));
        }
        Pair<Integer, WorkflowStepDefinition> explicit = this.getStepsWithExplicitIdById().get(next);
        if (explicit != null) {
            return Maybe.of((Object)Pair.of((Object)explicit.getLeft(), (Object)false));
        }
        return Maybe.absent((Throwable)new NoSuchElementException("Step with ID '" + next + "' not found"));
    }

    String getWorkflowStepReference(int index, WorkflowStepDefinition step) {
        return this.getWorkflowStepReference(index, step != null ? step.id : null, false);
    }

    String getWorkflowStepReference(int index, String optionalStepId, boolean isError) {
        return this.workflowId + (index >= 0 ? "-" + (index + 1) : (index == -3 && isError ? "" : "-" + this.indexCode(index))) + (Strings.isNonBlank((CharSequence)optionalStepId) ? "-" + optionalStepId : "") + (isError ? "-error-handler" : "");
    }

    public String getWorkflowStepReference(Task<?> t) {
        BrooklynTaskTags.WorkflowTaskTag wt = BrooklynTaskTags.getWorkflowTaskTag(t, false);
        if (wt.getErrorHandlerIndex() != null) {
            return t.getDisplayName();
        }
        return wt.getWorkflowId() + (wt.getStepIndex() != null && wt.getStepIndex() >= 0 && wt.getStepIndex() < this.stepsDefinition.size() ? "-" + (wt.getStepIndex() + 1) : "") + (wt.getErrorHandlerIndex() != null ? "-error-handler-" + (wt.getErrorHandlerIndex() + 1) : "");
    }

    private String indexCode(int index) {
        if (index == -1) {
            return STEP_TARGET_NAME_FOR_START;
        }
        if (index == -2) {
            return STEP_TARGET_NAME_FOR_END;
        }
        if (index == -3) {
            return LABEL_FOR_ERROR_HANDLER;
        }
        return "neg-" + index;
    }

    private static /* synthetic */ void lambda$newInstanceUnpersistedWithParent$9(Map parameters, ConfigBag inputRaw, MutableMap input, String k, Object v) {
        ConfigKey kc = (ConfigKey)parameters.get(k);
        Object v2 = kc == null ? v : inputRaw.get(kc);
        input.put((Object)k, v2);
    }

    private static /* synthetic */ void lambda$newInstanceUnpersistedWithParent$7(Map parameters, ConfigKey p) {
        parameters.put(p.getName(), p);
    }

    private static /* synthetic */ void lambda$newInstanceUnpersistedWithParent$6(Map parameters, ParameterType p) {
        parameters.put(p.getName(), Effectors.asConfigKey(p));
    }

    public static class Converter
    implements com.fasterxml.jackson.databind.util.Converter<WorkflowExecutionContext, WorkflowExecutionContext> {
        public WorkflowExecutionContext convert(WorkflowExecutionContext value) {
            if (value.workflowScratchVariables == null || value.workflowScratchVariables.isEmpty()) {
                value.workflowScratchVariables = (Map)value.getStepWorkflowScratchAndBacktrackedSteps(null).getLeft();
            }
            return value;
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(WorkflowExecutionContext.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(WorkflowExecutionContext.class);
        }
    }

    protected class Body
    implements Callable<Object> {
        private WorkflowStepDefinition.ReplayContinuationInstructions continuationInstructions;
        private Runnable intro = null;
        private int stepsRun = 0;
        boolean continueOnErrorHandledOrNextReplay;
        AtomicReference<Boolean> timerCancelled;

        public Body() {
        }

        public Body(WorkflowStepDefinition.ReplayContinuationInstructions continuationInstructions) {
            this.continuationInstructions = continuationInstructions;
        }

        public String toString() {
            return "WorkflowExecutionContext.Body[" + WorkflowExecutionContext.this.workflowId + "; " + this.continuationInstructions + "]";
        }

        @Override
        public Object call() throws Exception {
            if (this.intro != null) {
                this.intro.run();
            }
            return this.callWithLock(this::callSteps);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Object callWithLock(Callable<Callable<Object>> handler) throws Exception {
            Callable<Object> endHandler;
            AttributeSensor<String> lockSensor0 = null;
            Entity lockEntity0 = null;
            if (WorkflowExecutionContext.this.lock != null) {
                String lockName = null;
                if (WorkflowExecutionContext.this.lock instanceof String) {
                    lockName = (String)WorkflowExecutionContext.this.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.WORKFLOW_INPUT, WorkflowExecutionContext.this.lock, TypeToken.of(String.class));
                } else if (WorkflowExecutionContext.this.lock instanceof Map) {
                    lockName = (String)WorkflowExecutionContext.this.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.WORKFLOW_INPUT, ((Map)WorkflowExecutionContext.this.lock).get("name"), TypeToken.of(String.class));
                    Object lockEntity00 = ((Map)WorkflowExecutionContext.this.lock).get("entity");
                    if (lockEntity00 != null) {
                        lockEntity0 = (Entity)WorkflowExecutionContext.this.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.WORKFLOW_INPUT, lockEntity00, TypeToken.of(Entity.class));
                        log.debug(WorkflowExecutionContext.this + " using lock " + lockName + " on entity " + lockEntity0);
                    }
                }
                if (lockName == null) {
                    throw new IllegalArgumentException("Invalid lock object, should be a string or a map indicating a name and optional entity");
                }
                lockSensor0 = Sensors.newStringSensor("lock-for-" + lockName);
                if (lockEntity0 == null) {
                    lockEntity0 = WorkflowExecutionContext.this.getEntity();
                }
            }
            AttributeSensor<String> lockSensor = lockSensor0;
            Entity lockEntity = lockEntity0;
            AtomicBoolean mustClearLock = new AtomicBoolean(false);
            if (lockSensor != null) {
                String wid = WorkflowExecutionContext.this.getWorkflowId();
                Duration delay = null;
                Object lastHolder = null;
                while (true) {
                    AtomicReference holder = new AtomicReference();
                    lockEntity.sensors().modify(lockSensor, old -> {
                        if (old == null || old.equals(wid)) {
                            if (old != null) {
                                if (this.continuationInstructions != null) {
                                    log.debug(WorkflowExecutionContext.this + " reasserting lock on " + lockSensor.getName() + " during replay");
                                } else {
                                    log.warn("Entering block with lock on " + lockSensor.getName() + " when this workflow already holds the lock");
                                }
                            } else {
                                log.debug(WorkflowExecutionContext.this + " acquired lock on " + lockSensor.getName());
                            }
                            mustClearLock.set(true);
                            return Maybe.of((Object)wid);
                        }
                        log.debug("Blocked by lock on " + lockSensor.getName() + ", currently held by " + old);
                        holder.set(old);
                        return Maybe.absent();
                    });
                    if (mustClearLock.get()) break;
                    try {
                        if (delay == null || !Objects.equals(lastHolder, holder.get())) {
                            delay = Duration.millis((Number)5);
                        }
                        Duration ddelay = delay;
                        Tasks.withBlockingDetails("Waiting for lock on " + lockSensor.getName() + " (held by workflow " + (String)holder.get() + ")", () -> {
                            Time.sleep((Duration)ddelay);
                            return null;
                        });
                        delay = Duration.max((Duration)delay.multiply(1.0 + Math.random()), (Duration)Duration.seconds((Number)5));
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
            }
            try {
                endHandler = handler.call();
                if (!mustClearLock.get()) return endHandler.call();
            }
            catch (Throwable throwable) {
                if (!mustClearLock.get()) throw throwable;
                try {
                    DynamicTasks.waitForLast();
                    throw throwable;
                }
                finally {
                    if (Entities.isUnmanagingOrNoLongerManaged(WorkflowExecutionContext.this.getEntity())) {
                        log.debug("Skipping clearance of lock on " + lockSensor.getName() + " in " + WorkflowExecutionContext.this + " because entity unmanaging here; expect auto-replay on resumption to pick up");
                    } else {
                        Threads.runTemporarilyUninterrupted(() -> {
                            log.debug(WorkflowExecutionContext.this + " releasing lock on " + lockSensor.getName());
                            ((EntityInternal.SensorSupportInternal)lockEntity.sensors()).remove(lockSensor);
                        });
                    }
                }
            }
            try {
                DynamicTasks.waitForLast();
                return endHandler.call();
            }
            finally {
                if (Entities.isUnmanagingOrNoLongerManaged(WorkflowExecutionContext.this.getEntity())) {
                    log.debug("Skipping clearance of lock on " + lockSensor.getName() + " in " + WorkflowExecutionContext.this + " because entity unmanaging here; expect auto-replay on resumption to pick up");
                } else {
                    Threads.runTemporarilyUninterrupted(() -> {
                        log.debug(WorkflowExecutionContext.this + " releasing lock on " + lockSensor.getName());
                        ((EntityInternal.SensorSupportInternal)lockEntity.sensors()).remove(lockSensor);
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public Callable<Object> callSteps() throws Exception {
            block26: {
                DynamicTasks.swallowChildrenFailures();
                Task<?> timerTask = null;
                this.timerCancelled = new AtomicReference<Boolean>(false);
                try {
                    if (WorkflowExecutionContext.this.timeout != null) {
                        timerTask = this.initializeTimerFromWorkflowTimeout(timerTask);
                    }
                    block10: do {
                        try {
                            Integer replayFromStep;
                            boolean replaying = this.continuationInstructions != null;
                            Integer n = replayFromStep = replaying ? this.continuationInstructions.stepToReplayFrom : null;
                            if (!replaying) {
                                this.initializeWithoutContinuationInstructions(replayFromStep);
                            }
                            this.continueOnErrorHandledOrNextReplay = false;
                            WorkflowExecutionContext.this.lastErrorHandlerOutput = null;
                            WorkflowReplayUtils.updateOnWorkflowTaskStartupOrReplay(WorkflowExecutionContext.this, WorkflowExecutionContext.this.task, WorkflowExecutionContext.this.getStepsResolved(), !replaying, replayFromStep);
                            WorkflowExecutionContext.this.updateStatus(WorkflowStatus.RUNNING);
                            if (replaying) {
                                this.initializeFromContinuationInstructions(replayFromStep);
                            }
                            if (!Objects.equals(WorkflowExecutionContext.this.taskId, Tasks.current().getId())) {
                                throw new IllegalStateException("Running workflow in unexpected task, " + WorkflowExecutionContext.this.taskId + " does not match " + WorkflowExecutionContext.this.task);
                            }
                            int stepsConsidered = 0;
                            while (WorkflowExecutionContext.this.currentStepIndex >= 0 && WorkflowExecutionContext.this.currentStepIndex < WorkflowExecutionContext.this.getStepsResolved().size()) {
                                ++stepsConsidered;
                                if (replaying && replayFromStep == null) {
                                    if (WorkflowExecutionContext.this.currentStepInstance == null || WorkflowExecutionContext.this.currentStepInstance.getStepIndex() != WorkflowExecutionContext.this.currentStepIndex.intValue()) {
                                        throw new IllegalStateException("Running workflow at unexpected step, " + WorkflowExecutionContext.this.currentStepIndex + " v " + WorkflowExecutionContext.this.currentStepInstance);
                                    }
                                    WorkflowExecutionContext.this.currentStepInstance.setOutput(null);
                                    WorkflowExecutionContext.this.currentStepInstance.injectContext(WorkflowExecutionContext.this);
                                    log.debug("Replaying workflow '" + WorkflowExecutionContext.this.name + "', reusing instance " + WorkflowExecutionContext.this.currentStepInstance + " for step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex) + ")");
                                    this.runCurrentStepInstanceApproved(WorkflowExecutionContext.this.getStepsResolved().get(WorkflowExecutionContext.this.currentStepIndex));
                                } else {
                                    this.runCurrentStepIfPreconditions();
                                }
                                replaying = false;
                                if (this.continuationInstructions == null) continue;
                                this.continueOnErrorHandledOrNextReplay = true;
                                continue block10;
                            }
                            log.debug("Completed workflow " + WorkflowExecutionContext.this.workflowId + " successfully; step count: " + stepsConsidered + " considered, " + this.stepsRun + " executed");
                            if (WorkflowExecutionContext.this.outputDefinition != null) {
                                WorkflowExecutionContext.this.output = WorkflowExecutionContext.this.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_FINISHING_POST_OUTPUT, WorkflowExecutionContext.this.outputDefinition, Object.class);
                            } else if (this.stepsRun > 0) {
                                WorkflowExecutionContext.this.output = WorkflowExecutionContext.this.getPreviousStepOutput();
                            }
                            this.updateOnSuccessfulCompletion();
                        }
                        catch (Throwable e) {
                            block25: {
                                Pair<Throwable, WorkflowStatus> unhandledError = this.handleErrorAtWorkflow(e);
                                if (unhandledError == null) break block25;
                                Callable<Object> callable = () -> this.endWithError((Throwable)unhandledError.getLeft(), (WorkflowStatus)((Object)((Object)((Object)((Object)((Object)unhandledError.getRight()))))));
                                {
                                    catch (Throwable e2) {
                                        log.debug("Uncaught error in workflow exception handler: " + e2, e2);
                                        Callable<Object> callable2 = () -> this.endWithError(e2, WorkflowStatus.ERROR);
                                        if (timerTask != null && !timerTask.isDone() && !this.timerCancelled.get().booleanValue()) {
                                            log.debug("Cancelling " + timerTask + " on completion of this task");
                                            timerTask.cancel(true);
                                        }
                                        return callable2;
                                    }
                                }
                                if (timerTask != null && !timerTask.isDone() && !this.timerCancelled.get().booleanValue()) {
                                    log.debug("Cancelling " + timerTask + " on completion of this task");
                                    timerTask.cancel(true);
                                }
                                return callable;
                            }
                            if (this.continueOnErrorHandledOrNextReplay) continue;
                            this.updateOnSuccessfulCompletion();
                        }
                    } while (this.continueOnErrorHandledOrNextReplay);
                    break block26;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (timerTask != null && !timerTask.isDone() && !this.timerCancelled.get().booleanValue()) {
                        log.debug("Cancelling " + timerTask + " on completion of this task");
                        timerTask.cancel(true);
                    }
                }
            }
            return this::endWithSuccess;
        }

        private Pair<Throwable, WorkflowStatus> handleErrorAtWorkflow(Throwable e) {
            boolean errorHandled;
            WorkflowStatus provisionalStatus;
            block20: {
                boolean isTimeout = false;
                if (this.timerCancelled.get().booleanValue() && Exceptions.getCausalChain((Throwable)e).stream().anyMatch(cause -> cause instanceof TimeoutException || cause instanceof InterruptedException || cause instanceof CancellationException || cause instanceof RuntimeInterruptedException)) {
                    TimeoutException timeoutException = new TimeoutException("Timeout after " + WorkflowExecutionContext.this.timeout + ": " + WorkflowExecutionContext.this.getName());
                    timeoutException.initCause(e);
                    e = timeoutException;
                    isTimeout = true;
                }
                if (Exceptions.isCausedByInterruptInAnyThread((Throwable)e) || Exceptions.getFirstThrowableMatching((Throwable)e, t -> t instanceof CancellationException || t instanceof TimeoutException) != null) {
                    provisionalStatus = !Thread.currentThread().isInterrupted() ? (Exceptions.getFirstThrowableOfType((Throwable)e, TemplateProcessor.TemplateModelDataUnavailableException.class) != null ? WorkflowStatus.ERROR : WorkflowStatus.ERROR_CANCELLED) : WorkflowStatus.ERROR_CANCELLED;
                    if (provisionalStatus == WorkflowStatus.ERROR_CANCELLED) {
                        if (!WorkflowExecutionContext.this.getManagementContext().isRunning()) {
                            provisionalStatus = WorkflowStatus.ERROR_SHUTDOWN;
                        } else if (Entities.isUnmanagingOrNoLongerManaged(WorkflowExecutionContext.this.entity)) {
                            provisionalStatus = WorkflowStatus.ERROR_ENTITY_DESTROYED;
                        }
                    }
                } else {
                    provisionalStatus = WorkflowStatus.ERROR;
                }
                errorHandled = false;
                if (isTimeout) {
                    log.debug("Timeout in workflow '" + WorkflowExecutionContext.this.getName() + "' around step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex) + ", throwing: " + Exceptions.collapseText((Throwable)e));
                } else if (Thread.currentThread().isInterrupted()) {
                    log.debug("Interrupt in workflow '" + WorkflowExecutionContext.this.getName() + "' around step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex) + ", throwing: " + Exceptions.collapseText((Throwable)e));
                } else if (!(WorkflowExecutionContext.this.onError == null || WorkflowExecutionContext.this.onError instanceof Collection && ((Collection)WorkflowExecutionContext.this.onError).isEmpty())) {
                    try {
                        log.debug("Error in workflow '" + WorkflowExecutionContext.this.getName() + "' around step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex) + ", running error handler");
                        Task<WorkflowErrorHandling.WorkflowErrorHandlingResult> workflowErrorHandlerTask = WorkflowErrorHandling.createWorkflowErrorHandlerTask(WorkflowExecutionContext.this, WorkflowExecutionContext.this.task, e);
                        WorkflowExecutionContext.this.errorHandlerTaskId = workflowErrorHandlerTask.getId();
                        WorkflowErrorHandling.WorkflowErrorHandlingResult result = (WorkflowErrorHandling.WorkflowErrorHandlingResult)DynamicTasks.queue(workflowErrorHandlerTask).getUnchecked();
                        if (result == null) break block20;
                        errorHandled = true;
                        WorkflowExecutionContext.this.currentStepInstance.next = WorkflowReplayUtils.getNext(result.next, WorkflowExecutionContext.STEP_TARGET_NAME_FOR_END);
                        if (result.output != null) {
                            WorkflowExecutionContext.this.output = WorkflowExecutionContext.this.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_FINISHING_POST_OUTPUT, result.output, Object.class);
                        }
                        this.moveToNextStep("Handled error in workflow around step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex), result.next == null);
                        if (this.continuationInstructions != null || WorkflowExecutionContext.this.currentStepIndex < WorkflowExecutionContext.this.getStepsResolved().size()) {
                            this.continueOnErrorHandledOrNextReplay = true;
                            return null;
                        }
                    }
                    catch (Exception e2) {
                        Throwable e0 = e;
                        if (Exceptions.getCausalChain((Throwable)e2).stream().anyMatch(e3 -> e3 == e0)) {
                            e = e2;
                            break block20;
                        }
                        log.warn("Error in workflow '" + WorkflowExecutionContext.this.getName() + "' around step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex) + " error handler for -- " + Exceptions.collapseText((Throwable)e) + " -- threw another error (rethrowing): " + Exceptions.collapseText((Throwable)e2));
                        log.debug("Full trace of original error was: " + e, e);
                        e = e2;
                    }
                } else {
                    log.debug("Error in workflow '" + WorkflowExecutionContext.this.getName() + "' around step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex) + ", no error handler so rethrowing: " + Exceptions.collapseText((Throwable)e), e);
                }
            }
            if (errorHandled) {
                return null;
            }
            if (this.replayAutomaticallyIfAppropriate(e)) {
                return null;
            }
            return Pair.of((Object)e, (Object)((Object)provisionalStatus));
        }

        private boolean replayAutomaticallyIfAppropriate(Throwable e) {
            if (Boolean.TRUE.equals(WorkflowExecutionContext.this.replayableAutomatically) && Exceptions.getFirstThrowableOfType((Throwable)e, DanglingWorkflowException.class) != null) {
                log.info("Automatic replay indicated for " + WorkflowExecutionContext.this + " when detected as dangling on server startup");
                WorkflowExecutionContext.this.currentStepInstance.next = WorkflowExecutionContext.this.factory(true).makeInstructionsForReplayResuming("Replay resuming on dangling", false);
                this.continueOnErrorHandledOrNextReplay = true;
                return true;
            }
            return false;
        }

        private void updateOnSuccessfulCompletion() {
            WorkflowExecutionContext.this.updateStatus(WorkflowStatus.SUCCESS);
            WorkflowExecutionContext.this.replayableLastStep = -2;
            WorkflowExecutionContext.this.oldStepInfo.compute(WorkflowExecutionContext.this.previousStepIndex == null ? -1 : WorkflowExecutionContext.this.previousStepIndex, (index, old) -> {
                if (old == null) {
                    old = new OldStepRecord();
                }
                old.next = MutableSet.of((Object)-2).putAll(old.next);
                old.nextTaskId = null;
                return old;
            });
            WorkflowExecutionContext.this.oldStepInfo.compute(-2, (index, old) -> {
                if (old == null) {
                    old = new OldStepRecord();
                }
                old.previous = MutableSet.of((Object)(WorkflowExecutionContext.this.previousStepIndex == null ? -1 : WorkflowExecutionContext.this.previousStepIndex)).putAll(old.previous);
                old.previousTaskId = WorkflowExecutionContext.this.previousStepTaskId;
                return old;
            });
        }

        private void resetWorkflowContextPreviousAndScratchVarsToStep(Integer step, boolean requireLastStep) {
            if (step == null) {
                return;
            }
            OldStepRecord last = WorkflowExecutionContext.this.oldStepInfo.get(step);
            if (last != null) {
                WorkflowExecutionContext.this.workflowScratchVariables = (Map)WorkflowExecutionContext.this.getStepWorkflowScratchAndBacktrackedSteps(step).getLeft();
                WorkflowExecutionContext.this.previousStepIndex = last.previous == null ? null : (Integer)last.previous.stream().findFirst().orElse(null);
            } else if (requireLastStep) {
                throw new IllegalStateException("Last step record required for step " + step + " to replay from there");
            }
            if (WorkflowExecutionContext.this.workflowScratchVariables == null) {
                WorkflowExecutionContext.this.workflowScratchVariables = MutableMap.of();
            }
        }

        private void initializeFromContinuationInstructions(Integer replayFromStep) {
            if (replayFromStep != null && replayFromStep == -1) {
                log.debug("Replaying workflow '" + WorkflowExecutionContext.this.name + "', from start (was at " + (WorkflowExecutionContext.this.currentStepIndex == null ? "<UNSTARTED>" : this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex)) + ")");
                this.resetWorkflowContextPreviousAndScratchVarsToStep(replayFromStep, false);
                WorkflowExecutionContext.this.currentStepIndex = 0;
            } else if (replayFromStep != null && replayFromStep == -2) {
                log.debug("Replaying workflow '" + WorkflowExecutionContext.this.name + "', from end (was at " + (WorkflowExecutionContext.this.currentStepIndex == null ? "<UNSTARTED>" : this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex)) + ")");
                WorkflowExecutionContext.this.currentStepIndex = -2;
                this.resetWorkflowContextPreviousAndScratchVarsToStep(replayFromStep, false);
                WorkflowExecutionContext.this.currentStepInstance = null;
            } else {
                log.debug("Replaying workflow '" + WorkflowExecutionContext.this.name + "', from step " + (replayFromStep == null ? "<CURRENT>" : this.workflowStepReference(replayFromStep)) + " (was at " + (WorkflowExecutionContext.this.currentStepIndex == null ? "<UNSTARTED>" : this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex)) + ")");
                if (replayFromStep == null) {
                    if (WorkflowExecutionContext.this.currentStepIndex == null) {
                        throw new IllegalStateException("Invalid instructions to continue from last bypassing convenience method, and there is no last");
                    }
                    if (WorkflowExecutionContext.this.currentStepInstance == null || WorkflowExecutionContext.this.currentStepInstance.stepIndex != WorkflowExecutionContext.this.currentStepIndex) {
                        throw new IllegalStateException("Invalid instructions to continue from last step which is unknown, bypassing convenience method");
                    }
                } else {
                    WorkflowExecutionContext.this.currentStepIndex = replayFromStep;
                }
                this.resetWorkflowContextPreviousAndScratchVarsToStep(WorkflowExecutionContext.this.currentStepIndex, false);
            }
            if (this.continuationInstructions.customWorkflowScratchVariables != null) {
                WorkflowExecutionContext.this.updateWorkflowScratchVariables(this.continuationInstructions.customWorkflowScratchVariables);
            }
        }

        private void initializeWithoutContinuationInstructions(Integer replayFromStep) {
            if (replayFromStep == null && WorkflowExecutionContext.this.currentStepIndex == null) {
                WorkflowExecutionContext.this.currentStepIndex = 0;
                log.debug("Starting workflow '" + WorkflowExecutionContext.this.name + "', moving to first step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex));
            } else if (replayFromStep != null || !this.continueOnErrorHandledOrNextReplay) {
                this.continueOnErrorHandledOrNextReplay = false;
                throw new IllegalStateException("Should either be replaying or unstarted, but not invoked as replaying, and current=" + WorkflowExecutionContext.this.currentStepIndex + " replay=" + replayFromStep);
            }
        }

        private Task<?> initializeTimerFromWorkflowTimeout(Task<?> timerTask) {
            Task otherTask = Tasks.current();
            timerTask = Entities.submit(WorkflowExecutionContext.this.getEntity(), Tasks.builder().displayName("Timer for " + WorkflowExecutionContext.this.toString() + ":" + WorkflowExecutionContext.this.taskId).body(() -> {
                block3: {
                    try {
                        Time.sleep((Duration)WorkflowExecutionContext.this.timeout);
                        if (!otherTask.isDone()) {
                            this.timerCancelled.set(true);
                            log.debug("Cancelling " + otherTask + " after timeout of " + WorkflowExecutionContext.this.timeout);
                            otherTask.cancel(true);
                        }
                    }
                    catch (Throwable e) {
                        if (Exceptions.isRootCauseIsInterruption((Throwable)e)) break block3;
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
            }).dynamic(false).tag("TRANSIENT").tag("inessential").build());
            return timerTask;
        }

        private Object endWithSuccess() {
            WorkflowReplayUtils.updateOnWorkflowSuccess(WorkflowExecutionContext.this, WorkflowExecutionContext.this.task, WorkflowExecutionContext.this.getOutput());
            WorkflowExecutionContext.this.persist();
            return WorkflowExecutionContext.this.output;
        }

        private Object endWithError(Throwable e, WorkflowStatus provisionalStatus) {
            WorkflowExecutionContext.this.updateStatus(provisionalStatus);
            WorkflowReplayUtils.updateOnWorkflowError(WorkflowExecutionContext.this, WorkflowExecutionContext.this.task, e);
            WorkflowExecutionContext.this.persist();
            try {
                log.debug("Error running workflow " + this + "; will persist then rethrow: " + e);
                log.trace("Error running workflow " + this + "; will persist then rethrow (details): " + e, e);
            }
            catch (Throwable e2) {
                if (Entities.isUnmanagingOrNoLongerManaged(WorkflowExecutionContext.this.getEntity())) {
                    log.trace("Error persisting workflow (entity ending) " + this + " after error in workflow; persistence error (details): " + e2, e2);
                } else {
                    log.error("Error persisting workflow " + this + " after error in workflow; persistence error: " + e2);
                    log.debug("Error persisting workflow " + this + " after error in workflow; persistence error (details): " + e2, e2);
                    log.warn("Error running workflow " + this + ", rethrowing without persisting because of persistence error (above): " + e);
                }
                log.trace("Error running workflow " + this + ", rethrowing without persisting because of persistence error (above): " + e, e);
            }
            throw Exceptions.propagate((Throwable)e);
        }

        protected void runCurrentStepIfPreconditions() {
            WorkflowStepDefinition step = WorkflowExecutionContext.this.getStepsResolved().get(WorkflowExecutionContext.this.currentStepIndex);
            if (step != null) {
                WorkflowExecutionContext.this.currentStepInstance = new WorkflowStepInstanceExecutionContext(WorkflowExecutionContext.this.currentStepIndex, step, WorkflowExecutionContext.this);
                DslPredicates.DslPredicate conditionResolved = step.getConditionResolved(WorkflowExecutionContext.this.currentStepInstance);
                if (conditionResolved != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("Considering condition " + step.condition + " for " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex));
                    }
                    boolean conditionMet = DslPredicates.evaluateDslPredicateWithBrooklynObjectContext(conditionResolved, WorkflowExecutionContext.this, WorkflowExecutionContext.this.getEntityOrAdjunctWhereRunning());
                    if (log.isTraceEnabled()) {
                        log.trace("Considered condition " + step.condition + " for " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex) + ": " + conditionMet);
                    }
                    if (!conditionMet) {
                        this.moveToNextStep("Skipping step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex), false);
                        return;
                    }
                }
            } else {
                throw new IllegalStateException("Cannot find step " + WorkflowExecutionContext.this.currentStepIndex);
            }
            this.runCurrentStepInstanceApproved(step);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runCurrentStepInstanceApproved(WorkflowStepDefinition step) {
            Task<?> t;
            ++this.stepsRun;
            if (this.continuationInstructions != null) {
                t = step.newTaskContinuing(WorkflowExecutionContext.this.currentStepInstance, this.continuationInstructions);
                this.continuationInstructions = null;
            } else {
                t = step.newTask(WorkflowExecutionContext.this.currentStepInstance);
            }
            WorkflowExecutionContext.this.updateOldNextStepOnThisStepStarting();
            OldStepRecord currentStepRecord = WorkflowExecutionContext.this.oldStepInfo.compute(WorkflowExecutionContext.this.currentStepIndex, (index, old) -> {
                if (old == null) {
                    old = new OldStepRecord();
                }
                ++old.countStarted;
                old.workflowScratchUpdates = null;
                old.previous = MutableSet.of((Object)(WorkflowExecutionContext.this.previousStepIndex == null ? -1 : WorkflowExecutionContext.this.previousStepIndex)).putAll(old.previous);
                old.previousTaskId = WorkflowExecutionContext.this.previousStepTaskId;
                old.nextTaskId = null;
                return old;
            });
            WorkflowReplayUtils.updateReplayableFromStep(WorkflowExecutionContext.this, step);
            WorkflowExecutionContext.this.oldStepInfo.compute(WorkflowExecutionContext.this.previousStepIndex == null ? -1 : WorkflowExecutionContext.this.previousStepIndex, (index, old) -> {
                if (old == null) {
                    old = new OldStepRecord();
                }
                if (WorkflowExecutionContext.this.previousStepIndex == null && WorkflowExecutionContext.this.workflowScratchVariables != null && !WorkflowExecutionContext.this.workflowScratchVariables.isEmpty()) {
                    old.workflowScratch = MutableMap.copyOf(WorkflowExecutionContext.this.workflowScratchVariables);
                }
                old.next = MutableSet.of((Object)WorkflowExecutionContext.this.currentStepIndex).putAll(old.next);
                old.nextTaskId = t.getId();
                return old;
            });
            WorkflowExecutionContext.this.errorHandlerContext = null;
            WorkflowExecutionContext.this.errorHandlerTaskId = null;
            WorkflowExecutionContext.this.currentStepInstance.next = null;
            WorkflowExecutionContext.this.persist();
            BiConsumer<Object, Object> onFinish = (stepOutputDefinition, overrideNext) -> {
                Pair<Object, Set<Integer>> prev;
                WorkflowExecutionContext.this.currentStepInstance.next = WorkflowReplayUtils.getNext(overrideNext, WorkflowExecutionContext.this.currentStepInstance, step);
                if (stepOutputDefinition != null) {
                    Object outputResolved = WorkflowExecutionContext.this.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_FINISHING_POST_OUTPUT, stepOutputDefinition, Object.class);
                    WorkflowExecutionContext.this.currentStepInstance.setOutput(outputResolved);
                }
                if (WorkflowExecutionContext.this.currentStepInstance.output != null && (prev = WorkflowExecutionContext.this.getStepOutputAndBacktrackedSteps(null)) != null && Objects.equals(prev.getLeft(), WorkflowExecutionContext.this.currentStepInstance.output) && WorkflowExecutionContext.this.lastErrorHandlerOutput == null) {
                    WorkflowExecutionContext.this.currentStepInstance.output = null;
                }
                if (WorkflowExecutionContext.this.workflowScratchVariablesUpdatedThisStep != null && !WorkflowExecutionContext.this.workflowScratchVariablesUpdatedThisStep.isEmpty()) {
                    currentStepRecord.workflowScratchUpdates = WorkflowExecutionContext.this.workflowScratchVariablesUpdatedThisStep;
                }
                if (currentStepRecord.workflowScratch != null && (prev = WorkflowExecutionContext.this.getStepWorkflowScratchAndBacktrackedSteps(null)) != null && !((Set)prev.getRight()).contains(WorkflowExecutionContext.this.currentStepIndex) && Objects.equals(prev.getLeft(), currentStepRecord.workflowScratch)) {
                    currentStepRecord.workflowScratch = null;
                }
                WorkflowExecutionContext.this.workflowScratchVariablesUpdatedThisStep = null;
            };
            try {
                Object newOutput;
                Duration duration = step.getTimeout();
                if (duration != null) {
                    boolean isEnded = DynamicTasks.queue(t).blockUntilEnded(duration);
                    if (!isEnded) {
                        t.cancel(true);
                        throw new TimeoutException("Timeout after " + duration + ": " + t.getDisplayName());
                    }
                    newOutput = t.getUnchecked();
                } else {
                    newOutput = DynamicTasks.queue(t).getUnchecked();
                }
                WorkflowExecutionContext.this.currentStepInstance.setOutput(newOutput);
                onFinish.accept(step.output, null);
            }
            catch (Exception e) {
                try {
                    this.handleErrorAtStep(step, t, onFinish, e);
                }
                catch (Exception e2) {
                    WorkflowExecutionContext.this.currentStepInstance.setError(e2);
                    throw e2;
                }
            }
            finally {
                WorkflowExecutionContext.this.oldStepInfo.compute(WorkflowExecutionContext.this.currentStepIndex, (index, old) -> {
                    if (old == null) {
                        log.warn("Lost old step info for " + this + ", step " + index);
                        old = new OldStepRecord();
                    }
                    if (WorkflowExecutionContext.this.currentStepInstance.getError() == null) {
                        ++old.countCompleted;
                    }
                    old.context = WorkflowExecutionContext.this.currentStepInstance;
                    return old;
                });
            }
            WorkflowExecutionContext.this.previousStepTaskId = WorkflowExecutionContext.this.currentStepInstance.taskId;
            WorkflowExecutionContext.this.previousStepIndex = WorkflowExecutionContext.this.currentStepIndex;
            this.moveToNextStep("Completed step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex), false);
        }

        private void handleErrorAtStep(WorkflowStepDefinition step, Task<?> stepTaskThrowingError, BiConsumer<Object, Object> onFinish, Exception error) {
            WorkflowErrorHandling.handleErrorAtStep(WorkflowExecutionContext.this.getEntity(), step, WorkflowExecutionContext.this.currentStepInstance, stepTaskThrowingError, onFinish, error, null);
        }

        private void logWarnOnExceptionOrDebugIfKnown(Exception e, String msg) {
            WorkflowErrorHandling.logWarnOnExceptionOrDebugIfKnown(WorkflowExecutionContext.this.getEntity(), e, msg);
        }

        private void moveToNextStep(String prefix, boolean inferredNext) {
            prefix = prefix + "; ";
            Object specialNext = WorkflowReplayUtils.getNext(WorkflowExecutionContext.this.currentStepInstance);
            WorkflowStepDefinition.ReplayContinuationInstructions replayContinuationInstructions = this.continuationInstructions = specialNext instanceof WorkflowStepDefinition.ReplayContinuationInstructions ? (WorkflowStepDefinition.ReplayContinuationInstructions)specialNext : null;
            if (this.continuationInstructions != null) {
                log.debug(prefix + "proceeding to custom replay: " + this.continuationInstructions);
                return;
            }
            if (specialNext == null) {
                Integer n = WorkflowExecutionContext.this.currentStepIndex;
                Integer n2 = WorkflowExecutionContext.this.currentStepIndex = Integer.valueOf(WorkflowExecutionContext.this.currentStepIndex + 1);
                if (WorkflowExecutionContext.this.currentStepIndex < WorkflowExecutionContext.this.getStepsResolved().size()) {
                    log.debug(prefix + "moving to sequential next step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex));
                } else {
                    log.debug(prefix + "no further steps: Workflow completed");
                }
            } else if (specialNext instanceof String) {
                String explicitNext = (String)specialNext;
                Maybe<Pair<Integer, Boolean>> nextResolved = WorkflowExecutionContext.this.getIndexOfStepId(explicitNext);
                if (nextResolved.isAbsent()) {
                    log.warn(prefix + (inferredNext ? "inferred" : "explicit") + " next step '" + explicitNext + "' not found (failing)");
                    nextResolved.get();
                }
                if (((Pair)nextResolved.get()).getLeft() == null) {
                    throw new IllegalArgumentException("Next step '" + explicitNext + "' not supported here");
                }
                WorkflowExecutionContext.this.currentStepIndex = (Integer)((Pair)nextResolved.get()).getLeft();
                if (((Boolean)((Pair)nextResolved.get()).getRight()).booleanValue()) {
                    if (WorkflowExecutionContext.this.currentStepIndex < WorkflowExecutionContext.this.getStepsResolved().size()) {
                        log.debug(prefix + "moving to " + (inferredNext ? "inferred" : "explicit") + " next step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex) + " for token '" + explicitNext + "'");
                    } else {
                        log.debug(prefix + (inferredNext ? "inferred" : "explicit") + " next step '" + explicitNext + "': Workflow completed");
                    }
                } else {
                    log.debug(prefix + "moving to " + (inferredNext ? "inferred" : "explicit") + " next step " + this.workflowStepReference(WorkflowExecutionContext.this.currentStepIndex) + " for id '" + explicitNext + "'");
                }
            } else {
                throw new IllegalStateException("Illegal next definition: " + specialNext + " (type " + specialNext.getClass() + ")");
            }
        }

        String workflowStepReference(Integer index) {
            if (index == null) {
                return WorkflowExecutionContext.this.workflowId + "-<no-step>";
            }
            if (index >= WorkflowExecutionContext.this.getStepsResolved().size()) {
                return WorkflowExecutionContext.this.getWorkflowStepReference(index, "<END>", false);
            }
            return WorkflowExecutionContext.this.getWorkflowStepReference(index, WorkflowExecutionContext.this.getStepsResolved().get(index));
        }

        public Body withIntro(Runnable intro) {
            this.intro = intro;
            return this;
        }
    }

    public class Factory {
        private final boolean allowInternallyEvenIfDisabled;

        protected Factory(boolean allowInternallyEvenIfDisabled) {
            this.allowInternallyEvenIfDisabled = allowInternallyEvenIfDisabled;
        }

        public WorkflowStepDefinition.ReplayContinuationInstructions makeInstructionsForReplayingFromStep(int stepIndex0, String reason, boolean forced) {
            if (!forced) {
                this.checkNotDisabled();
            }
            int stepIndex = stepIndex0;
            if (!forced) {
                stepIndex = (Integer)Maybe.ofDisallowingNull((Object)WorkflowReplayUtils.findNearestReplayPoint(WorkflowExecutionContext.this, stepIndex0)).orThrow(() -> new IllegalStateException("Workflow is not replayable: no replay points found backtracking from " + stepIndex0));
                log.debug("Request to replay from step " + stepIndex0 + ", nearest replay point is " + stepIndex);
            }
            return new WorkflowStepDefinition.ReplayContinuationInstructions(stepIndex, reason, null, forced);
        }

        public WorkflowStepDefinition.ReplayContinuationInstructions makeInstructionsForReplayingFromLastReplayable(String reason, boolean forced) {
            return this.makeInstructionsForReplayingFromStep(WorkflowExecutionContext.this.replayableLastStep != null ? WorkflowExecutionContext.this.replayableLastStep : -1, reason, forced);
        }

        public WorkflowStepDefinition.ReplayContinuationInstructions makeInstructionsForReplayingFromStart(String reason, boolean forced) {
            return this.makeInstructionsForReplayingFromStep(-1, reason, forced);
        }

        public WorkflowStepDefinition.ReplayContinuationInstructions makeInstructionsForReplayResuming(String reason, boolean forced) {
            return this.makeInstructionsForReplayResuming(reason, forced, null);
        }

        public WorkflowStepDefinition.ReplayContinuationInstructions makeInstructionsForReplayResumingForcedWithCustom(String reason, Runnable code) {
            return this.makeInstructionsForReplayResuming(reason, true, code);
        }

        protected WorkflowStepDefinition.ReplayContinuationInstructions makeInstructionsForReplayResuming(String reason, boolean forced, Runnable code) {
            if (!forced) {
                this.checkNotDisabled();
            }
            Integer replayFromStep = null;
            if (WorkflowExecutionContext.this.currentStepIndex == null) {
                replayFromStep = -1;
            } else if (WorkflowExecutionContext.this.currentStepInstance == null || WorkflowExecutionContext.this.currentStepInstance.stepIndex != WorkflowExecutionContext.this.currentStepIndex) {
                log.debug("Replaying workflow '" + WorkflowExecutionContext.this.name + "', cannot replay within step " + WorkflowExecutionContext.this.currentStepIndex + " because step instance not known; will reinitialize then replay that step");
                replayFromStep = WorkflowExecutionContext.this.currentStepIndex;
            }
            if (!forced && replayFromStep == null && !WorkflowReplayUtils.isReplayResumable(WorkflowExecutionContext.this, WorkflowReplayUtils.ReplayResumeDepthCheck.RESUMABLE_WHENEVER_NESTED_WORKFLOWS_PRESENT, this.allowInternallyEvenIfDisabled)) {
                if (code != null) {
                    throw new IllegalArgumentException("Cannot supply code to here without forcing as workflow does not support replay resuming at this point");
                }
                log.debug("Request to replay resuming " + WorkflowExecutionContext.this + " at non-idempotent step; rolling back to " + WorkflowExecutionContext.this.replayableLastStep);
                if (WorkflowExecutionContext.this.replayableLastStep == null) {
                    throw new IllegalArgumentException("Cannot replay resuming as there are no replay points and last step " + WorkflowExecutionContext.this.currentStepIndex + " is not idempotent");
                }
                return this.makeInstructionsForReplayingFromStep(WorkflowExecutionContext.this.replayableLastStep, reason, false);
            }
            return new WorkflowStepDefinition.ReplayContinuationInstructions(replayFromStep, reason, code, forced);
        }

        public Task<Object> createTaskReplaying(WorkflowStepDefinition.ReplayContinuationInstructions continuationInstructions) {
            return this.createTaskReplaying(null, continuationInstructions);
        }

        public Task<Object> createTaskReplaying(Runnable intro, WorkflowStepDefinition.ReplayContinuationInstructions continuationInstructions) {
            if (continuationInstructions == null || !continuationInstructions.forced) {
                this.checkNotDisabled();
            }
            if (WorkflowExecutionContext.this.task != null && !WorkflowExecutionContext.this.task.isDone()) {
                if (!WorkflowExecutionContext.this.task.isSubmitted()) {
                    if (WorkflowExecutionContext.this.parent != null && WorkflowExecutionContext.this.parent.getReplays().size() > 1) {
                        log.debug("Abandoning sub-workflow task that was never submitted, not unusual as parent seems to be replaying: " + WorkflowExecutionContext.this.task + " for " + WorkflowExecutionContext.this);
                    } else {
                        log.warn("Abandoning workflow task that was never submitted: " + WorkflowExecutionContext.this.task + " for " + WorkflowExecutionContext.this);
                    }
                } else if (WorkflowExecutionContext.this.isSubmitterAncestor(Tasks.current(), (Task<Object>)WorkflowExecutionContext.this.task)) {
                    log.debug("Replaying containing workflow " + WorkflowExecutionContext.this + " in task " + WorkflowExecutionContext.this.task + " which is an ancestor of " + Tasks.current());
                } else {
                    log.warn("Unable to replay workflow " + WorkflowExecutionContext.this + " from " + Tasks.current() + " because workflow task " + WorkflowExecutionContext.this.task + " is ongoing; will delay up to 1s then retry");
                    if (!WorkflowExecutionContext.this.task.blockUntilEnded(Duration.ONE_SECOND)) {
                        log.warn("Unable to replay workflow " + WorkflowExecutionContext.this + " from " + Tasks.current() + " because workflow task " + WorkflowExecutionContext.this.task + " is ongoing (waited 1s, still ongoing; so rethrowing)");
                        throw new IllegalStateException("Cannot replay ongoing workflow, given " + continuationInstructions);
                    }
                }
            }
            String explanation = continuationInstructions.customBehaviorExplanation != null ? continuationInstructions.customBehaviorExplanation : "no explanation";
            WorkflowExecutionContext.this.task = Tasks.builder().dynamic(true).displayName(WorkflowExecutionContext.this.name + " (" + explanation + ")").tag(BrooklynTaskTags.tagForWorkflow(WorkflowExecutionContext.this)).tag("WORKFLOW").body(new Body(continuationInstructions).withIntro(intro)).build();
            WorkflowReplayUtils.updateOnWorkflowStartOrReplay(WorkflowExecutionContext.this, WorkflowExecutionContext.this.task, continuationInstructions.customBehaviorExplanation, continuationInstructions.stepToReplayFrom);
            WorkflowExecutionContext.this.taskId = WorkflowExecutionContext.this.task.getId();
            return WorkflowExecutionContext.this.task;
        }

        public boolean isDisabled() {
            if (this.allowInternallyEvenIfDisabled) {
                return false;
            }
            return Boolean.TRUE.equals(WorkflowExecutionContext.this.replayableDisabled);
        }

        public void checkNotDisabled() {
            if (this.isDisabled()) {
                throw new IllegalStateException("Replays disabled on " + WorkflowExecutionContext.this);
            }
        }
    }

    public static enum WorkflowContextType {
        SENSOR,
        EFFECTOR,
        POLICY,
        NESTED_WORKFLOW,
        OTHER;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class OldStepRecord {
        int countStarted = 0;
        int countCompleted = 0;
        WorkflowStepInstanceExecutionContext context;
        Boolean replayableFromHere;
        Map<String, Object> workflowScratch;
        Map<String, Object> workflowScratchUpdates;
        Set<Integer> previous;
        Set<Integer> next;
        String previousTaskId;
        String nextTaskId;
    }

    public static enum WorkflowStatus {
        STAGED(false, false, false, false),
        RUNNING(true, false, false, false),
        SUCCESS(true, true, false, true),
        ERROR_SHUTDOWN(true, true, true, false),
        ERROR_ENTITY_DESTROYED(true, true, true, true),
        ERROR_CANCELLED(true, true, true, true),
        ERROR(true, true, true, true);

        public final boolean started;
        public final boolean ended;
        public final boolean error;
        public final boolean expirable;

        private WorkflowStatus(boolean started, boolean ended, boolean error, boolean expirable) {
            this.started = started;
            this.ended = ended;
            this.error = error;
            this.expirable = expirable;
        }
    }
}

