/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform operations against Apache Lucene Solr.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SolrEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Solr component.
     */
    public interface SolrEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSolrEndpointBuilder advanced() {
            return (AdvancedSolrEndpointBuilder) this;
        }

        /**
         * Use async request processing (when supported by the solr client).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param async the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder async(boolean async) {
            doSetProperty("async", async);
            return this;
        }
        /**
         * Use async request processing (when supported by the solr client).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param async the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder async(String async) {
            doSetProperty("async", async);
            return this;
        }
        /**
         * If true, each producer insert/delete operation will be automatically
         * performing a commit.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param autoCommit the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder autoCommit(boolean autoCommit) {
            doSetProperty("autoCommit", autoCommit);
            return this;
        }
        /**
         * If true, each producer insert/delete operation will be automatically
         * performing a commit.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param autoCommit the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder autoCommit(String autoCommit) {
            doSetProperty("autoCommit", autoCommit);
            return this;
        }
        /**
         * The name of the collection to act against.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * The time in ms to wait before connection will time out.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: producer
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder connectionTimeout(Long connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * The time in ms to wait before connection will time out.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: producer
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * For the delete instruction, interprete body as query/queries instead
         * of id/ids.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param deleteByQuery the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder deleteByQuery(boolean deleteByQuery) {
            doSetProperty("deleteByQuery", deleteByQuery);
            return this;
        }
        /**
         * For the delete instruction, interprete body as query/queries instead
         * of id/ids.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param deleteByQuery the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder deleteByQuery(String deleteByQuery) {
            doSetProperty("deleteByQuery", deleteByQuery);
            return this;
        }
        /**
         * Starting index of the response.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder from(Integer from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Starting index of the response.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * What operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.solr.SolrOperation</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder operation(org.apache.camel.component.solr.SolrOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * What operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.solr.SolrOperation</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The path of the update request handler (use for update requests / set
         * solr parameter qt for search requests).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param requestHandler the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder requestHandler(String requestHandler) {
            doSetProperty("requestHandler", requestHandler);
            return this;
        }
        /**
         * The time in ms to wait before the request will time out (former
         * soTimeout).
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder requestTimeout(Long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * The time in ms to wait before the request will time out (former
         * soTimeout).
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder requestTimeout(String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Size of the response.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param size the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder size(Integer size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * Size of the response.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param size the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder size(String size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The certificate that can be used to access the solr host. It can be
         * loaded by default from classpath, but you can prefix with classpath:,
         * file:, or http: to load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param certificatePath the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder certificatePath(String certificatePath) {
            doSetProperty("certificatePath", certificatePath);
            return this;
        }
        /**
         * Enable SSL.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param enableSSL the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder enableSSL(boolean enableSSL) {
            doSetProperty("enableSSL", enableSSL);
            return this;
        }
        /**
         * Enable SSL.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param enableSSL the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder enableSSL(String enableSSL) {
            doSetProperty("enableSSL", enableSSL);
            return this;
        }
        /**
         * Password for authenticating.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Basic authenticate user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default SolrEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Solr component.
     */
    public interface AdvancedSolrEndpointBuilder
            extends
                EndpointProducerBuilder {
        default SolrEndpointBuilder basic() {
            return (SolrEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSolrEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSolrEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The solr client to connect to solr. When solrClient bean is provided,
         * all connection properties will be used from that solrClient (host,
         * port, username, password, connectionTimeout, requestTimeout,
         * enableSSL, ...). When not explicitly configured, camel uses the
         * HttpJdkSolrClient.
         * 
         * The option is a: <code>org.apache.solr.client.solrj.SolrClient</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param solrClient the value to set
         * @return the dsl builder
         */
        default AdvancedSolrEndpointBuilder solrClient(org.apache.solr.client.solrj.SolrClient solrClient) {
            doSetProperty("solrClient", solrClient);
            return this;
        }
        /**
         * The solr client to connect to solr. When solrClient bean is provided,
         * all connection properties will be used from that solrClient (host,
         * port, username, password, connectionTimeout, requestTimeout,
         * enableSSL, ...). When not explicitly configured, camel uses the
         * HttpJdkSolrClient.
         * 
         * The option will be converted to a
         * <code>org.apache.solr.client.solrj.SolrClient</code> type.
         * 
         * Group: advanced
         * 
         * @param solrClient the value to set
         * @return the dsl builder
         */
        default AdvancedSolrEndpointBuilder solrClient(String solrClient) {
            doSetProperty("solrClient", solrClient);
            return this;
        }
    }

    public interface SolrBuilders {
        /**
         * Solr (camel-solr)
         * Perform operations against Apache Lucene Solr.
         * 
         * Category: search,monitoring
         * Since: 4.8
         * Maven coordinates: org.apache.camel:camel-solr
         * 
         * @return the dsl builder for the headers' name.
         */
        default SolrHeaderNameBuilder solr() {
            return SolrHeaderNameBuilder.INSTANCE;
        }
        /**
         * Solr (camel-solr)
         * Perform operations against Apache Lucene Solr.
         * 
         * Category: search,monitoring
         * Since: 4.8
         * Maven coordinates: org.apache.camel:camel-solr
         * 
         * Syntax: <code>solr:host:port/basePath</code>
         * 
         * Path parameter: host (required)
         * The solr instance host name (set to 'default' to use the host name
         * defined on component level)
         * 
         * Path parameter: port
         * The solr instance port number
         * Default value: 8983
         * 
         * Path parameter: basePath
         * The solr instance base path (usually /solr)
         * Default value: /solr
         * 
         * @param path host:port/basePath
         * @return the dsl builder
         */
        default SolrEndpointBuilder solr(String path) {
            return SolrEndpointBuilderFactory.endpointBuilder("solr", path);
        }
        /**
         * Solr (camel-solr)
         * Perform operations against Apache Lucene Solr.
         * 
         * Category: search,monitoring
         * Since: 4.8
         * Maven coordinates: org.apache.camel:camel-solr
         * 
         * Syntax: <code>solr:host:port/basePath</code>
         * 
         * Path parameter: host (required)
         * The solr instance host name (set to 'default' to use the host name
         * defined on component level)
         * 
         * Path parameter: port
         * The solr instance port number
         * Default value: 8983
         * 
         * Path parameter: basePath
         * The solr instance base path (usually /solr)
         * Default value: /solr
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port/basePath
         * @return the dsl builder
         */
        default SolrEndpointBuilder solr(String componentName, String path) {
            return SolrEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Solr component.
     */
    public static class SolrHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SolrHeaderNameBuilder INSTANCE = new SolrHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SolrOperation}.
         */
        public String solrOperation() {
            return "CamelSolrOperation";
        }
        /**
         * The collection to execute the request against.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SolrCollection}.
         */
        public String solrCollection() {
            return "CamelSolrCollection";
        }
        /**
         * The request handler to execute the solr request against.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SolrRequestHandler}.
         */
        public String solrRequestHandler() {
            return "CamelSolrRequestHandler";
        }
        /**
         * The query to execute.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SolrQueryString}.
         */
        public String solrQueryString() {
            return "CamelSolrQueryString";
        }
        /**
         * The size of the response.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SolrSize}.
         */
        public String solrSize() {
            return "CamelSolrSize";
        }
        /**
         * The starting index of the response.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SolrFrom}.
         */
        public String solrFrom() {
            return "CamelSolrFrom";
        }
        /**
         * The solr parameters to use for the request.
         * 
         * The option is a: {@code org.apache.solr.common.params.SolrParams}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SolrParams}.
         */
        public String solrParams() {
            return "CamelSolrParams";
        }
        /**
         * For the delete instruction, interpret body as query/queries instead
         * of id/ids.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Default: false
         * Group: producer
         * 
         * @return the name of the header {@code SolrDeleteByQuery}.
         */
        public String solrDeleteByQuery() {
            return "CamelSolrDeleteByQuery";
        }
        /**
         * The content type is used to identify the type when inserting files.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Content-Type}.
         */
        public String contentType() {
            return "Content-Type";
        }
    }
    static SolrEndpointBuilder endpointBuilder(String componentName, String path) {
        class SolrEndpointBuilderImpl extends AbstractEndpointBuilder implements SolrEndpointBuilder, AdvancedSolrEndpointBuilder {
            public SolrEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SolrEndpointBuilderImpl(path);
    }
}