/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ibm.cos.IBMCOSComponent;

/**
 * Store and retrieve objects from IBM Cloud Object Storage.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface IbmCosComponentBuilderFactory {

    /**
     * IBM Cloud Object Storage (camel-ibm-cos)
     * Store and retrieve objects from IBM Cloud Object Storage.
     * 
     * Category: cloud,file
     * Since: 4.16
     * Maven coordinates: org.apache.camel:camel-ibm-cos
     * 
     * @return the dsl builder
     */
    static IbmCosComponentBuilder ibmCos() {
        return new IbmCosComponentBuilderImpl();
    }

    /**
     * Builder for the IBM Cloud Object Storage component.
     */
    interface IbmCosComponentBuilder extends ComponentBuilder<IBMCOSComponent> {
    
        
        /**
         * Automatically create the bucket if it doesn't exist.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
    
        /**
         * The component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.cos.IBMCOSConfiguration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder configuration(org.apache.camel.component.ibm.cos.IBMCOSConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * The delimiter to use for listing objects.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder delimiter(java.lang.String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
    
        /**
         * IBM COS Endpoint URL (e.g.,
         * https://s3.us-south.cloud-object-storage.appdomain.cloud).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param endpointUrl the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder endpointUrl(java.lang.String endpointUrl) {
            doSetProperty("endpointUrl", endpointUrl);
            return this;
        }
    
        /**
         * IBM COS Location/Region (e.g., us-south, eu-gb).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param location the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder location(java.lang.String location) {
            doSetProperty("location", location);
            return this;
        }
    
        /**
         * The prefix to use for listing objects.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder prefix(java.lang.String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        
        /**
         * Delete the object from IBM COS after it has been retrieved.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder deleteAfterRead(boolean deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
    
        /**
         * The destination bucket to move objects to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param destinationBucket the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder destinationBucket(java.lang.String destinationBucket) {
            doSetProperty("destinationBucket", destinationBucket);
            return this;
        }
    
        /**
         * The prefix to add to objects in the destination bucket.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param destinationBucketPrefix the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder destinationBucketPrefix(java.lang.String destinationBucketPrefix) {
            doSetProperty("destinationBucketPrefix", destinationBucketPrefix);
            return this;
        }
    
        /**
         * The suffix to add to objects in the destination bucket.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param destinationBucketSuffix the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder destinationBucketSuffix(java.lang.String destinationBucketSuffix) {
            doSetProperty("destinationBucketSuffix", destinationBucketSuffix);
            return this;
        }
    
        /**
         * To get the object from the bucket with the given file name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param fileName the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder fileName(java.lang.String fileName) {
            doSetProperty("fileName", fileName);
            return this;
        }
    
        
        /**
         * Include the object body in the exchange.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeBody the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder includeBody(boolean includeBody) {
            doSetProperty("includeBody", includeBody);
            return this;
        }
    
        
        /**
         * Include folders/directories when listing objects.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeFolders the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder includeFolders(boolean includeFolders) {
            doSetProperty("includeFolders", includeFolders);
            return this;
        }
    
        
        /**
         * Move the object to a different bucket after it has been retrieved.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param moveAfterRead the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder moveAfterRead(boolean moveAfterRead) {
            doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }
    
        
        /**
         * Whether to automatically close the object input stream after
         * processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param autocloseBody the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder autocloseBody(boolean autocloseBody) {
            doSetProperty("autocloseBody", autocloseBody);
            return this;
        }
    
        
        /**
         * Delete the object from the local filesystem after uploading.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param deleteAfterWrite the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }
    
        /**
         * The key name for the object.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param keyName the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder keyName(java.lang.String keyName) {
            doSetProperty("keyName", keyName);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Use multi-part upload for large files.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param multiPartUpload the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder multiPartUpload(boolean multiPartUpload) {
            doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }
    
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.cos.IBMCOSOperations&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder operation(org.apache.camel.component.ibm.cos.IBMCOSOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        
        /**
         * Part size for multi-part uploads (default 25MB).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 26214400
         * Group: producer
         * 
         * @param partSize the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder partSize(long partSize) {
            doSetProperty("partSize", partSize);
            return this;
        }
    
        /**
         * The storage class to use when storing objects (e.g., STANDARD, VAULT,
         * COLD, FLEX).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param storageClass the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder storageClass(java.lang.String storageClass) {
            doSetProperty("storageClass", storageClass);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * Reference to an IBM COS Client instance in the registry.
         * 
         * The option is a:
         * &lt;code&gt;com.ibm.cloud.objectstorage.services.s3.AmazonS3&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cosClient the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder cosClient(com.ibm.cloud.objectstorage.services.s3.AmazonS3 cosClient) {
            doSetProperty("cosClient", cosClient);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    
        /**
         * IBM Cloud API Key for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder apiKey(java.lang.String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    
        /**
         * IBM COS Service Instance ID (CRN).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param serviceInstanceId the value to set
         * @return the dsl builder
         */
        default IbmCosComponentBuilder serviceInstanceId(java.lang.String serviceInstanceId) {
            doSetProperty("serviceInstanceId", serviceInstanceId);
            return this;
        }
    }

    class IbmCosComponentBuilderImpl
            extends AbstractComponentBuilder<IBMCOSComponent>
            implements IbmCosComponentBuilder {
        @Override
        protected IBMCOSComponent buildConcreteComponent() {
            return new IBMCOSComponent();
        }
        private org.apache.camel.component.ibm.cos.IBMCOSConfiguration getOrCreateConfiguration(IBMCOSComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.ibm.cos.IBMCOSConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "autoCreateBucket": getOrCreateConfiguration((IBMCOSComponent) component).setAutoCreateBucket((boolean) value); return true;
            case "configuration": ((IBMCOSComponent) component).setConfiguration((org.apache.camel.component.ibm.cos.IBMCOSConfiguration) value); return true;
            case "delimiter": getOrCreateConfiguration((IBMCOSComponent) component).setDelimiter((java.lang.String) value); return true;
            case "endpointUrl": getOrCreateConfiguration((IBMCOSComponent) component).setEndpointUrl((java.lang.String) value); return true;
            case "location": getOrCreateConfiguration((IBMCOSComponent) component).setLocation((java.lang.String) value); return true;
            case "prefix": getOrCreateConfiguration((IBMCOSComponent) component).setPrefix((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((IBMCOSComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "deleteAfterRead": getOrCreateConfiguration((IBMCOSComponent) component).setDeleteAfterRead((boolean) value); return true;
            case "destinationBucket": getOrCreateConfiguration((IBMCOSComponent) component).setDestinationBucket((java.lang.String) value); return true;
            case "destinationBucketPrefix": getOrCreateConfiguration((IBMCOSComponent) component).setDestinationBucketPrefix((java.lang.String) value); return true;
            case "destinationBucketSuffix": getOrCreateConfiguration((IBMCOSComponent) component).setDestinationBucketSuffix((java.lang.String) value); return true;
            case "fileName": getOrCreateConfiguration((IBMCOSComponent) component).setFileName((java.lang.String) value); return true;
            case "includeBody": getOrCreateConfiguration((IBMCOSComponent) component).setIncludeBody((boolean) value); return true;
            case "includeFolders": getOrCreateConfiguration((IBMCOSComponent) component).setIncludeFolders((boolean) value); return true;
            case "moveAfterRead": getOrCreateConfiguration((IBMCOSComponent) component).setMoveAfterRead((boolean) value); return true;
            case "autocloseBody": getOrCreateConfiguration((IBMCOSComponent) component).setAutocloseBody((boolean) value); return true;
            case "deleteAfterWrite": getOrCreateConfiguration((IBMCOSComponent) component).setDeleteAfterWrite((boolean) value); return true;
            case "keyName": getOrCreateConfiguration((IBMCOSComponent) component).setKeyName((java.lang.String) value); return true;
            case "lazyStartProducer": ((IBMCOSComponent) component).setLazyStartProducer((boolean) value); return true;
            case "multiPartUpload": getOrCreateConfiguration((IBMCOSComponent) component).setMultiPartUpload((boolean) value); return true;
            case "operation": getOrCreateConfiguration((IBMCOSComponent) component).setOperation((org.apache.camel.component.ibm.cos.IBMCOSOperations) value); return true;
            case "partSize": getOrCreateConfiguration((IBMCOSComponent) component).setPartSize((long) value); return true;
            case "storageClass": getOrCreateConfiguration((IBMCOSComponent) component).setStorageClass((java.lang.String) value); return true;
            case "autowiredEnabled": ((IBMCOSComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "cosClient": getOrCreateConfiguration((IBMCOSComponent) component).setCosClient((com.ibm.cloud.objectstorage.services.s3.AmazonS3) value); return true;
            case "healthCheckConsumerEnabled": ((IBMCOSComponent) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((IBMCOSComponent) component).setHealthCheckProducerEnabled((boolean) value); return true;
            case "apiKey": getOrCreateConfiguration((IBMCOSComponent) component).setApiKey((java.lang.String) value); return true;
            case "serviceInstanceId": getOrCreateConfiguration((IBMCOSComponent) component).setServiceInstanceId((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}