/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SelectQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheableQuery
implements Query {
    protected static final Logger logger = LoggerFactory.getLogger(SelectQuery.class);

    protected abstract BaseQueryMetadata getBaseMetaData();

    public QueryCacheStrategy getCacheStrategy() {
        return this.getBaseMetaData().getCacheStrategy();
    }

    public void setCacheStrategy(QueryCacheStrategy strategy) {
        this.getBaseMetaData().setCacheStrategy(strategy);
    }

    @Deprecated
    public String[] getCacheGroups() {
        return this.getBaseMetaData().getCacheGroups();
    }

    public String getCacheGroup() {
        return this.getBaseMetaData().getCacheGroup();
    }

    @Deprecated
    public void setCacheGroups(String ... cacheGroups) {
        this.getBaseMetaData().setCacheGroups(cacheGroups);
        if (cacheGroups.length > 1) {
            logger.warn("Multiple cache groups usage have been deprecated, only first one will be used.");
        }
    }

    public void setCacheGroup(String cacheGroup) {
        this.getBaseMetaData().setCacheGroup(cacheGroup);
    }

    public void useLocalCache() {
        this.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
    }

    public void useLocalCache(String cacheGroup) {
        this.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        this.setCacheGroup(cacheGroup);
    }

    @Deprecated
    public void useLocalCache(String ... cacheGroups) {
        this.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        this.setCacheGroups(cacheGroups);
    }

    @Deprecated
    public void useSharedCache(String ... cacheGroups) {
        this.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        this.setCacheGroups(cacheGroups);
    }

    public void useSharedCache() {
        this.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
    }

    public void useSharedCache(String cacheGroup) {
        this.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        this.setCacheGroup(cacheGroup);
    }
}

