/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.dbsync.filter.NameFilter;
import org.apache.cayenne.dbsync.filter.NamePatternMatcher;
import org.apache.cayenne.dbsync.naming.DbEntityNameStemmer;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.PatternStemmer;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultDbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultModelMergeDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.LoggingDbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.ModelMergeDelegate;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.slf4j.Logger;

public class DbImportConfiguration {
    private static final String DATA_MAP_LOCATION_SUFFIX = ".map.xml";
    private final DataSourceInfo dataSourceInfo = new DataSourceInfo();
    private final DbLoaderConfiguration dbLoaderConfiguration = new DbLoaderConfiguration();
    private File targetDataMap;
    private String defaultPackage;
    private String meaningfulPkTables;
    private String adapter;
    private boolean usePrimitives;
    private boolean useJava7Types;
    private Logger logger;
    private String namingStrategy;
    private String stripFromTableNames;
    private boolean forceDataMapCatalog;
    private boolean forceDataMapSchema;
    private boolean useDataMapReverseEngineering;
    private File cayenneProject;

    public String getStripFromTableNames() {
        return this.stripFromTableNames;
    }

    public void setStripFromTableNames(String stripFromTableNames) {
        this.stripFromTableNames = stripFromTableNames;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public File getTargetDataMap() {
        return this.targetDataMap;
    }

    public void setTargetDataMap(File map) {
        this.targetDataMap = map;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    public String getMeaningfulPkTables() {
        return this.meaningfulPkTables;
    }

    public void setMeaningfulPkTables(String meaningfulPkTables) {
        this.meaningfulPkTables = meaningfulPkTables;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    public boolean isUseJava7Types() {
        return this.useJava7Types;
    }

    public void setUseJava7Types(boolean useJava7Types) {
        this.useJava7Types = useJava7Types;
    }

    public File getCayenneProject() {
        return this.cayenneProject;
    }

    public void setCayenneProject(File cayenneProject) {
        this.cayenneProject = cayenneProject;
    }

    public NameFilter createMeaningfulPKFilter() {
        if (this.meaningfulPkTables == null) {
            return NamePatternMatcher.EXCLUDE_ALL;
        }
        String[] patternStrings = this.meaningfulPkTables.split(",");
        Pattern[] patterns = new Pattern[patternStrings.length];
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = Pattern.compile(patternStrings[i]);
        }
        return new NamePatternMatcher(patterns, new Pattern[0]);
    }

    public ObjectNameGenerator createNameGenerator() {
        String namingStrategy = this.getNamingStrategy();
        if (namingStrategy != null && !namingStrategy.equals(DefaultObjectNameGenerator.class.getName())) {
            try {
                Class<?> generatorClass = Thread.currentThread().getContextClassLoader().loadClass(namingStrategy);
                return (ObjectNameGenerator)generatorClass.newInstance();
            }
            catch (Exception e) {
                throw new CayenneRuntimeException("Error creating name generator: " + namingStrategy, (Throwable)e, new Object[0]);
            }
        }
        return new DefaultObjectNameGenerator(this.createStemmer());
    }

    protected DbEntityNameStemmer createStemmer() {
        return this.stripFromTableNames == null || this.stripFromTableNames.length() == 0 ? NoStemStemmer.getInstance() : new PatternStemmer(this.stripFromTableNames, false);
    }

    public String getDriver() {
        return this.dataSourceInfo.getJdbcDriver();
    }

    public void setDriver(String jdbcDriver) {
        this.dataSourceInfo.setJdbcDriver(jdbcDriver);
    }

    public String getPassword() {
        return this.dataSourceInfo.getPassword();
    }

    public void setPassword(String password) {
        this.dataSourceInfo.setPassword(password);
    }

    public String getUsername() {
        return this.dataSourceInfo.getUserName();
    }

    public void setUsername(String userName) {
        this.dataSourceInfo.setUserName(userName);
    }

    public String getUrl() {
        return this.dataSourceInfo.getDataSourceUrl();
    }

    public void setUrl(String dataSourceUrl) {
        this.dataSourceInfo.setDataSourceUrl(dataSourceUrl);
    }

    public DataNodeDescriptor createDataNodeDescriptor() {
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setAdapterType(this.getAdapter());
        nodeDescriptor.setDataSourceDescriptor(this.dataSourceInfo);
        return nodeDescriptor;
    }

    public String getDataMapName() {
        String name = this.targetDataMap.getName();
        if (!name.endsWith(DATA_MAP_LOCATION_SUFFIX)) {
            throw new CayenneRuntimeException("DataMap file name must end with '%s': '%s'", new Object[]{DATA_MAP_LOCATION_SUFFIX, name});
        }
        return name.substring(0, name.length() - DATA_MAP_LOCATION_SUFFIX.length());
    }

    public ModelMergeDelegate createMergeDelegate() {
        return new DefaultModelMergeDelegate();
    }

    public DbLoaderDelegate createLoaderDelegate() {
        if (this.getLogger() != null) {
            return new LoggingDbLoaderDelegate(this.getLogger());
        }
        return new DefaultDbLoaderDelegate();
    }

    public DbLoaderConfiguration getDbLoaderConfig() {
        return this.dbLoaderConfiguration;
    }

    public void setFiltersConfig(FiltersConfig filtersConfig) {
        this.dbLoaderConfiguration.setFiltersConfig(filtersConfig);
    }

    public String toString() {
        StringBuilder res = new StringBuilder("Importer options:");
        for (String line : this.dbLoaderConfiguration.toString().split("\n")) {
            res.append("    ").append(line).append("\n");
        }
        return res.toString();
    }

    public DataSourceInfo getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    public void setSkipRelationshipsLoading(Boolean skipRelationshipsLoading) {
        this.dbLoaderConfiguration.setSkipRelationshipsLoading(skipRelationshipsLoading);
    }

    public void setSkipPrimaryKeyLoading(Boolean skipPrimaryKeyLoading) {
        this.dbLoaderConfiguration.setSkipPrimaryKeyLoading(skipPrimaryKeyLoading);
    }

    public void setTableTypes(String[] tableTypes) {
        this.dbLoaderConfiguration.setTableTypes(tableTypes);
    }

    public void setForceDataMapCatalog(boolean forceDataMapCatalog) {
        this.forceDataMapCatalog = forceDataMapCatalog;
    }

    public boolean isForceDataMapCatalog() {
        return this.forceDataMapCatalog;
    }

    public void setForceDataMapSchema(boolean forceDataMapSchema) {
        this.forceDataMapSchema = forceDataMapSchema;
    }

    public boolean isForceDataMapSchema() {
        return this.forceDataMapSchema;
    }

    public boolean isUseDataMapReverseEngineering() {
        return this.useDataMapReverseEngineering;
    }

    public void setUseDataMapReverseEngineering(boolean useDataMapReverseEngineering) {
        this.useDataMapReverseEngineering = useDataMapReverseEngineering;
    }
}

