/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TarFileObjectTest {
    private void testReadSpecialNameFileInFile(String testFilePath, String scheme) throws FileSystemException {
        File testFile = new File(testFilePath);
        String[] fileNames = new String[]{"file.txt", "file^.txt", "file~.txt", "file?.txt", "file@.txt", "file$.txt", "file*.txt", "file&.txt", "file#.txt", "file%.txt", "file!.txt"};
        FileSystemManager manager = VFS.getManager();
        String baseUrl = scheme + ":file:" + testFile.getAbsolutePath();
        try (FileObject fileObject = manager.resolveFile(baseUrl);){
            Assertions.assertEquals((int)fileObject.getChildren().length, (int)fileNames.length);
            for (String fileName : fileNames) {
                Assertions.assertNotNull((Object)fileObject.getChild(fileName), (String)("can't read file " + fileName));
            }
        }
    }

    @Test
    public void testReadSpecialNameFileInTarFile() throws FileSystemException {
        this.testReadSpecialNameFileInFile("src/test/resources/test-data/special_fileName.tar", "tar");
    }

    @Test
    public void testReadSpecialNameFileInTbz2File() throws FileSystemException {
        this.testReadSpecialNameFileInFile("src/test/resources/test-data/special_fileName.tbz2", "tbz2");
    }

    @Test
    public void testReadSpecialNameFileInTgzFile() throws FileSystemException {
        this.testReadSpecialNameFileInFile("src/test/resources/test-data/special_fileName.tgz", "tgz");
    }
}

