/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.udp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.mina.core.buffer.IoBuffer;

public class IoSessionInputStream
extends InputStream {
    private volatile IoBuffer buf;
    private volatile IOException exception;

    public IoSessionInputStream(IoBuffer b) {
        this.buf = IoBuffer.allocate((int)b.limit());
        this.buf.put(b);
        this.buf.flip();
    }

    public IoSessionInputStream() {
        this.buf = null;
    }

    @Override
    public int available() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.buf == null) {
            return 0;
        }
        return this.buf.remaining();
    }

    @Override
    public void close() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    @Override
    public int read() throws IOException {
        this.waitForData();
        if (this.exception != null) {
            throw this.exception;
        }
        return this.buf.get() & 0xFF;
    }

    public synchronized void waitForData() throws IOException {
        if (this.exception == null && this.buf == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException();
            }
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.waitForData();
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.buf.remaining() == 0) {
            return -1;
        }
        int readBytes = len > this.buf.remaining() ? this.buf.remaining() : len;
        this.buf.get(b, off, readBytes);
        return readBytes;
    }

    public synchronized void throwException(IOException e) {
        if (this.exception == null) {
            this.exception = e;
        }
        this.notifyAll();
    }

    public synchronized void setBuffer(IoBuffer b) {
        this.buf = IoBuffer.allocate((int)b.limit());
        this.buf.put(b);
        this.buf.flip();
        this.notifyAll();
    }
}

