/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class BackupRegistrationMessage
extends PacketImpl {
    private TransportConfiguration connector;
    private String clusterUser;
    private String clusterPassword;
    private boolean backupWantsFailBack;

    public BackupRegistrationMessage(TransportConfiguration tc, String user, String password, boolean backupWantsFailBack) {
        this();
        this.connector = tc;
        this.clusterUser = user;
        this.clusterPassword = password;
        this.backupWantsFailBack = backupWantsFailBack;
    }

    public BackupRegistrationMessage() {
        super((byte)115);
    }

    public TransportConfiguration getConnector() {
        return this.connector;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeString(this.clusterUser);
        buffer.writeString(this.clusterPassword);
        buffer.writeBoolean(this.backupWantsFailBack);
        this.connector.encode(buffer);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.clusterUser = buffer.readString();
        this.clusterPassword = buffer.readString();
        this.backupWantsFailBack = buffer.readBoolean();
        this.connector = new TransportConfiguration();
        this.connector.decode(buffer);
    }

    public String getClusterUser() {
        return this.clusterUser;
    }

    public String getClusterPassword() {
        return this.clusterPassword;
    }

    public boolean isFailBackRequest() {
        return this.backupWantsFailBack;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.backupWantsFailBack, this.clusterPassword, this.clusterUser, this.connector);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BackupRegistrationMessage)) {
            return false;
        }
        BackupRegistrationMessage other = (BackupRegistrationMessage)((Object)obj);
        return this.backupWantsFailBack == other.backupWantsFailBack && Objects.equals(this.clusterPassword, other.clusterPassword) && Objects.equals(this.clusterUser, other.clusterUser) && Objects.equals(this.connector, other.connector);
    }
}

