/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class BackupRequestMessage
extends PacketImpl {
    private int backupSize;
    private SimpleString nodeID;
    private String journalDirectory;
    private String bindingsDirectory;
    private String largeMessagesDirectory;
    private String pagingDirectory;

    public BackupRequestMessage() {
        super((byte)127);
    }

    public BackupRequestMessage(int backupSize, String journalDirectory, String bindingsDirectory, String largeMessagesDirectory, String pagingDirectory) {
        super((byte)127);
        this.backupSize = backupSize;
        this.journalDirectory = journalDirectory;
        this.bindingsDirectory = bindingsDirectory;
        this.largeMessagesDirectory = largeMessagesDirectory;
        this.pagingDirectory = pagingDirectory;
    }

    public BackupRequestMessage(int backupSize, SimpleString nodeID) {
        super((byte)127);
        this.backupSize = backupSize;
        this.nodeID = nodeID;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeInt(this.backupSize);
        buffer.writeNullableString(this.journalDirectory);
        buffer.writeNullableString(this.bindingsDirectory);
        buffer.writeNullableString(this.largeMessagesDirectory);
        buffer.writeNullableString(this.pagingDirectory);
        buffer.writeNullableSimpleString(this.nodeID);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.backupSize = buffer.readInt();
        this.journalDirectory = buffer.readNullableString();
        this.bindingsDirectory = buffer.readNullableString();
        this.largeMessagesDirectory = buffer.readNullableString();
        this.pagingDirectory = buffer.readNullableString();
        this.nodeID = buffer.readNullableSimpleString();
    }

    public int getBackupSize() {
        return this.backupSize;
    }

    public SimpleString getNodeID() {
        return this.nodeID;
    }

    public String getJournalDirectory() {
        return this.journalDirectory;
    }

    public String getBindingsDirectory() {
        return this.bindingsDirectory;
    }

    public String getLargeMessagesDirectory() {
        return this.largeMessagesDirectory;
    }

    public String getPagingDirectory() {
        return this.pagingDirectory;
    }
}

