/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.SSLContext;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.SSLContextServerParameters;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.bootstrap.ConfigurationBuilderImpl;
import org.apache.cxf.jaxrs.bootstrap.InstanceImpl;
import org.apache.cxf.jaxrs.impl.CacheControlHeaderProvider;
import org.apache.cxf.jaxrs.impl.CookieHeaderProvider;
import org.apache.cxf.jaxrs.impl.DateHeaderProvider;
import org.apache.cxf.jaxrs.impl.EntityPartBuilderImpl;
import org.apache.cxf.jaxrs.impl.EntityTagHeaderProvider;
import org.apache.cxf.jaxrs.impl.LinkBuilderImpl;
import org.apache.cxf.jaxrs.impl.LinkHeaderProvider;
import org.apache.cxf.jaxrs.impl.MediaTypeHeaderProvider;
import org.apache.cxf.jaxrs.impl.NewCookieHeaderProvider;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.impl.VariantListBuilderImpl;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.transport.http.HTTPServerEngineFactoryParametersProvider;

public class RuntimeDelegateImpl
extends RuntimeDelegate {
    private static final int DEFAULT_HTTP_PORT = 8080;
    private static final int DEFAULT_HTTPS_PORT = 8443;
    protected Map<Class<?>, RuntimeDelegate.HeaderDelegate<?>> headerProviders = new HashMap();

    public RuntimeDelegateImpl() {
        this.headerProviders.put(MediaType.class, new MediaTypeHeaderProvider());
        this.headerProviders.put(CacheControl.class, new CacheControlHeaderProvider());
        this.headerProviders.put(EntityTag.class, new EntityTagHeaderProvider());
        this.headerProviders.put(Cookie.class, new CookieHeaderProvider());
        this.headerProviders.put(NewCookie.class, new NewCookieHeaderProvider());
        this.headerProviders.put(Link.class, new LinkHeaderProvider());
        this.headerProviders.put(Date.class, new DateHeaderProvider());
    }

    public <T> T createInstance(Class<T> type) {
        if (type.isAssignableFrom(Response.ResponseBuilder.class)) {
            return type.cast(new ResponseBuilderImpl());
        }
        if (type.isAssignableFrom(UriBuilder.class)) {
            return type.cast(new UriBuilderImpl());
        }
        if (type.isAssignableFrom(Variant.VariantListBuilder.class)) {
            return type.cast((Object)new VariantListBuilderImpl());
        }
        return null;
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("HeaderDelegate type is null");
        }
        return this.headerProviders.get(type);
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new ResponseBuilderImpl();
    }

    public UriBuilder createUriBuilder() {
        return new UriBuilderImpl();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilderImpl();
    }

    public <T> T createEndpoint(Application app, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        if (app == null || !Server.class.isAssignableFrom(endpointType) && !JAXRSServerFactoryBean.class.isAssignableFrom(endpointType)) {
            throw new IllegalArgumentException();
        }
        JAXRSServerFactoryBean bean = ResourceUtils.createApplication(app, false, false, false, null);
        if (JAXRSServerFactoryBean.class.isAssignableFrom(endpointType)) {
            return endpointType.cast((Object)bean);
        }
        bean.setStart(false);
        Server server = bean.create();
        return endpointType.cast(server);
    }

    public Link.Builder createLinkBuilder() {
        return new LinkBuilderImpl();
    }

    public SeBootstrap.Configuration.Builder createConfigurationBuilder() {
        return new ConfigurationBuilderImpl();
    }

    public CompletionStage<SeBootstrap.Instance> bootstrap(Application application, SeBootstrap.Configuration configuration) {
        JAXRSServerFactoryBean factory = ResourceUtils.createApplication(application, false, false, false, null);
        SeBootstrap.Configuration.Builder instanceConfigurationBuilder = SeBootstrap.Configuration.builder().from((Object)configuration);
        if (!configuration.hasProperty("jakarta.ws.rs.SeBootstrap.Host")) {
            instanceConfigurationBuilder = instanceConfigurationBuilder.host("localhost");
        }
        String protocol = "HTTP";
        if (!configuration.hasProperty("jakarta.ws.rs.SeBootstrap.Protocol")) {
            instanceConfigurationBuilder = instanceConfigurationBuilder.protocol(protocol);
        } else {
            Object object = configuration.property("jakarta.ws.rs.SeBootstrap.Protocol");
            if (object instanceof String) {
                String p;
                protocol = p = (String)object;
            }
        }
        if (!configuration.hasProperty("jakarta.ws.rs.SeBootstrap.Port")) {
            instanceConfigurationBuilder = instanceConfigurationBuilder.port(Integer.valueOf(RuntimeDelegateImpl.getDefaultPort(protocol)));
        } else if (configuration.port() == 0) {
            instanceConfigurationBuilder = instanceConfigurationBuilder.port(Integer.valueOf(RuntimeDelegateImpl.findFreePort()));
        } else if (configuration.port() == -1) {
            instanceConfigurationBuilder = instanceConfigurationBuilder.port(Integer.valueOf(RuntimeDelegateImpl.getDefaultPort(protocol)));
        }
        if (!configuration.hasProperty("jakarta.ws.rs.SeBootstrap.RootPath")) {
            instanceConfigurationBuilder = instanceConfigurationBuilder.rootPath("/");
        }
        final SeBootstrap.Configuration instanceConfiguration = instanceConfigurationBuilder.build();
        URI address = instanceConfiguration.baseUriBuilder().path(factory.getAddress()).build(new Object[0]);
        factory.setAddress(address.toString());
        factory.setStart(true);
        if ("https".equalsIgnoreCase(configuration.protocol())) {
            SSLContext sslContext = configuration.sslContext();
            SSLContextServerParameters parameters = sslContext != null ? new SSLContextServerParameters(sslContext) : new TLSServerParameters();
            SeBootstrap.Configuration.SSLClientAuthentication sslClientAuthentication = configuration.sslClientAuthentication();
            if (sslClientAuthentication != null) {
                ClientAuthentication clientAuthentication = new ClientAuthentication();
                if (sslClientAuthentication == SeBootstrap.Configuration.SSLClientAuthentication.OPTIONAL) {
                    clientAuthentication.setWant(Boolean.valueOf(true));
                } else if (sslClientAuthentication == SeBootstrap.Configuration.SSLClientAuthentication.MANDATORY) {
                    clientAuthentication.setRequired(Boolean.valueOf(true));
                }
                parameters.setClientAuthentication(clientAuthentication);
            }
            factory.getBus().setExtension((Object)new HTTPServerEngineFactoryParametersProvider(){
                final /* synthetic */ TLSServerParameters val$parameters;
                {
                    this.val$parameters = tLSServerParameters;
                }

                public Optional<TLSServerParameters> getDefaultTlsServerParameters(Bus bus, String host, int port, String protocol, String id) {
                    if ("https".equalsIgnoreCase(protocol) && port == instanceConfiguration.port()) {
                        return Optional.of(this.val$parameters);
                    }
                    return Optional.empty();
                }
            }, HTTPServerEngineFactoryParametersProvider.class);
        }
        return CompletableFuture.supplyAsync(() -> factory.create()).thenApply(s -> new InstanceImpl((Server)s, instanceConfiguration));
    }

    public CompletionStage<SeBootstrap.Instance> bootstrap(final Class<? extends Application> clazz, SeBootstrap.Configuration configuration) {
        try {
            Application application = AccessController.doPrivileged(new PrivilegedExceptionAction<Application>(){

                @Override
                public Application run() throws Exception {
                    return (Application)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            });
            return this.bootstrap(application, configuration);
        }
        catch (Exception ex) {
            return CompletableFuture.failedStage(ex);
        }
    }

    public EntityPart.Builder createEntityPartBuilder(String partName) throws IllegalArgumentException {
        return new EntityPartBuilderImpl(partName);
    }

    private static int getDefaultPort(String protocol) {
        return protocol.equalsIgnoreCase("http") ? 8080 : 8443;
    }

    private static int findFreePort() {
        return AccessController.doPrivileged(() -> {
            Integer n;
            ServerSocket socket = new ServerSocket(0);
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return -1;
                }
            }
            socket.close();
            return n;
        });
    }
}

