/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.embedded;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.impl.LegacyJMSConfiguration;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String workDir = "/app";
    private static volatile EmbeddedActiveMQ embeddedServer;

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            workDir = args[0];
            logger.debug("User supplied work dir {}", (Object)workDir);
        }
        Object propertiesConfigPath = "/config/," + workDir + "/etc/";
        if (args.length == 2) {
            propertiesConfigPath = args[1];
            logger.debug("User supplied properties config path {}", propertiesConfigPath);
        }
        FileConfiguration configuration = new FileConfiguration();
        String dataDir = workDir + "/data";
        Main.configureDataDirectory(configuration, dataDir);
        File bringYourOwnXml = new File(workDir + "/etc/broker.xml");
        if (bringYourOwnXml.exists()) {
            logger.debug("byo config found {}", (Object)bringYourOwnXml);
            configuration = Main.loadFromXmlFile(bringYourOwnXml, configuration);
        }
        embeddedServer = new EmbeddedActiveMQ();
        embeddedServer.setPropertiesResourcePath((String)propertiesConfigPath);
        embeddedServer.setConfiguration(configuration);
        embeddedServer.createActiveMQServer();
        ActiveMQServer activeMQServer = embeddedServer.getActiveMQServer();
        CountDownLatch serverStopped = new CountDownLatch(1);
        Main.registerCallbackToTriggerLatchOnStopped(activeMQServer, serverStopped);
        Main.exitWithErrorOnStartFailure(activeMQServer);
        Main.addShutdownHookForServerStop(embeddedServer);
        logger.debug("starting server");
        embeddedServer.start();
        logger.debug("await server stop");
        serverStopped.await();
        embeddedServer = null;
    }

    private static void exitWithErrorOnStartFailure(ActiveMQServer activeMQServer) {
        activeMQServer.registerActivationFailureListener(exception -> {
            logger.error("server failed to start {}, exit(1) in thread", (Throwable)exception);
            new Thread("exit(1)-on-start-failure"){

                @Override
                public void run() {
                    logger.error("exit(1)");
                    Runtime.getRuntime().exit(1);
                }
            }.start();
        });
    }

    private static void registerCallbackToTriggerLatchOnStopped(ActiveMQServer activeMQServer, final CountDownLatch serverStopped) {
        activeMQServer.registerActivateCallback(new ActivateCallback(){

            @Override
            public void stop(ActiveMQServer server) {
                logger.trace("server stop, state {}", (Object)server.getState());
                serverStopped.countDown();
            }

            @Override
            public void shutdown(ActiveMQServer server) {
                logger.trace("server shutdown, state {}", (Object)server.getState());
                serverStopped.countDown();
            }
        });
    }

    private static void addShutdownHookForServerStop(final EmbeddedActiveMQ server) {
        Runtime.getRuntime().addShutdownHook(new Thread("shutdown-hook"){

            @Override
            public void run() {
                try {
                    logger.trace("stop via shutdown hook");
                    server.stop();
                }
                catch (Exception ignored) {
                    logger.trace("Error on stop {}", (Throwable)ignored);
                }
            }
        });
    }

    public static FileConfiguration loadFromXmlFile(File bringYourOwnXml, FileConfiguration base) throws Exception {
        FileDeploymentManager deploymentManager = new FileDeploymentManager(bringYourOwnXml.toURI().toASCIIString());
        LegacyJMSConfiguration legacyJMSConfiguration = new LegacyJMSConfiguration(base);
        deploymentManager.addDeployable(base).addDeployable(legacyJMSConfiguration);
        deploymentManager.readConfiguration();
        return base;
    }

    public static void configureDataDirectory(ConfigurationImpl configuration, String dataDir) {
        configuration.setJournalDirectory(dataDir);
        configuration.setBindingsDirectory(dataDir + "/bindings");
        configuration.setLargeMessagesDirectory(dataDir + "/largemessages");
        configuration.setPagingDirectory(dataDir + "/paging");
    }

    public static EmbeddedActiveMQ getEmbeddedServer() {
        return embeddedServer;
    }
}

