/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UsernameTokenUtil {
    public static final int DEFAULT_ITERATION = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(UsernameTokenUtil.class);

    private UsernameTokenUtil() {
    }

    public static byte[] generateDerivedKey(byte[] password, byte[] salt, int iteration) throws WSSecurityException {
        byte[] pwSalt = new byte[salt.length + password.length];
        System.arraycopy(password, 0, pwSalt, 0, password.length);
        System.arraycopy(salt, 0, pwSalt, password.length, salt.length);
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "decoding.general");
        }
        byte[] k = sha.digest(pwSalt);
        int iter = iteration;
        if (iter <= 0) {
            iter = 1000;
        }
        for (int i = 1; i < iter; ++i) {
            k = sha.digest(k);
        }
        return k;
    }

    public static byte[] generateDerivedKey(String password, byte[] salt, int iteration) throws WSSecurityException {
        return UsernameTokenUtil.generateDerivedKey(password.getBytes(StandardCharsets.UTF_8), salt, iteration);
    }

    public static byte[] generateSalt(boolean useForMac) {
        byte[] saltValue = null;
        try {
            saltValue = UsernameTokenUtil.generateNonce(16);
        }
        catch (WSSecurityException ex) {
            LOG.debug(ex.getMessage(), (Throwable)((Object)ex));
            return null;
        }
        saltValue[0] = useForMac ? 1 : 2;
        return saltValue;
    }

    private static byte[] generateNonce(int length) throws WSSecurityException {
        try {
            return XMLSecurityConstants.generateBytes((int)length);
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex, "empty", new Object[]{"Error in generating nonce of length " + length});
        }
    }

    public static String doPasswordDigest(byte[] nonce, String created, String password) throws WSSecurityException {
        return UsernameTokenUtil.doPasswordDigest(nonce, created, password.getBytes(StandardCharsets.UTF_8));
    }

    public static String doPasswordDigest(byte[] nonce, String created, byte[] password) throws WSSecurityException {
        byte[] digestBytes = UsernameTokenUtil.doRawPasswordDigest(nonce, created, password);
        return XMLUtils.encodeToString((byte[])digestBytes);
    }

    public static byte[] doRawPasswordDigest(byte[] nonce, String created, byte[] password) throws WSSecurityException {
        try {
            byte[] b1 = nonce != null ? nonce : new byte[]{};
            byte[] b2 = created != null ? created.getBytes(StandardCharsets.UTF_8) : new byte[]{};
            byte[] b3 = password;
            byte[] b4 = new byte[b1.length + b2.length + b3.length];
            int offset = 0;
            System.arraycopy(b1, 0, b4, offset, b1.length);
            System.arraycopy(b2, 0, b4, offset += b1.length, b2.length);
            System.arraycopy(b3, 0, b4, offset += b2.length, b3.length);
            return KeyUtils.generateDigest(b4);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "decoding.general");
        }
    }

    public static String getRawPassword(CallbackHandler callbackHandler, String username, String password, String passwordType) throws WSSecurityException {
        if (callbackHandler == null) {
            LOG.debug("CallbackHandler is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(username, password, passwordType, 2);
        try {
            callbackHandler.handle(new Callback[]{pwCb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, e);
        }
        return pwCb.getPassword();
    }
}

