/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.dsom;

import java.io.Serializable;
import org.apache.daffodil.core.dsom.DFDLSchemaFile;
import org.apache.daffodil.lib.exceptions.SchemaFileLocation;
import org.apache.daffodil.lib.exceptions.XercesSchemaFileLocation;
import org.apache.daffodil.lib.iapi.Diagnostic;
import org.apache.daffodil.lib.iapi.WarnID$XmlParser$;
import org.apache.daffodil.runtime1.dsom.SchemaDefinitionError;
import org.apache.daffodil.runtime1.dsom.SchemaDefinitionWarning;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DFDLSchemaFileLoadErrorHandler
implements ErrorHandler {
    private final SchemaFileLocation schemaFileLocation;
    private Seq<SAXParseException> loaderErrors_;
    private Seq<SAXParseException> loaderWarnings_;

    public DFDLSchemaFileLoadErrorHandler(SchemaFileLocation schemaFileLocation) {
        this.schemaFileLocation = schemaFileLocation;
        this.loaderErrors_ = package$.MODULE$.Nil();
        this.loaderWarnings_ = package$.MODULE$.Nil();
    }

    private void reset() {
        this.loaderErrors_ = package$.MODULE$.Nil();
        this.loaderWarnings_ = package$.MODULE$.Nil();
    }

    private Seq<SAXParseException> loaderErrors() {
        return this.loaderErrors_;
    }

    private Seq<SAXParseException> loaderWarnings() {
        return this.loaderWarnings_;
    }

    private Seq<Diagnostic> loaderSDEs() {
        return (Seq)this.loaderErrors().map((Function1 & Serializable)err -> {
            String errMessage = err.getMessage();
            XercesSchemaFileLocation xsfl = new XercesSchemaFileLocation((SAXParseException)err, this.schemaFileLocation);
            return new SchemaDefinitionError(xsfl, "Error loading schema due to %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{errMessage}));
        });
    }

    private Seq<Diagnostic> loaderSDWs() {
        return (Seq)this.loaderWarnings().map((Function1 & Serializable)w -> {
            String warnMessage = w.getMessage();
            XercesSchemaFileLocation xsfl = new XercesSchemaFileLocation((SAXParseException)w, this.schemaFileLocation);
            return new SchemaDefinitionWarning(WarnID$XmlParser$.MODULE$, xsfl, "Warning loading schema due to %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{warnMessage}));
        });
    }

    public Seq<Diagnostic> loadingDiagnostics() {
        return (Seq)this.loaderSDEs().$plus$plus(this.loaderSDWs());
    }

    public void handleLoadErrors(DFDLSchemaFile context) {
        this.loaderSDEs().foreach((Function1)(JProcedure1 & Serializable)_$4 -> context.error((Diagnostic)_$4));
        this.loaderSDWs().foreach((Function1)(JProcedure1 & Serializable)_$5 -> context.warn((Diagnostic)_$5));
        Option optErr = this.loaderSDEs().headOption();
        this.reset();
        optErr.foreach((Function1 & Serializable)_$6 -> {
            throw context.toss((Throwable)_$6);
        });
    }

    @Override
    public void warning(SAXParseException exception) {
        this.loaderWarnings_ = (Seq)this.loaderWarnings_.$colon$plus((Object)exception);
    }

    @Override
    public void error(SAXParseException exception) {
        this.loaderErrors_ = (Seq)this.loaderErrors_.$colon$plus((Object)exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.error(exception);
    }
}

