/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.lib.iapi.Diagnostic;
import org.apache.daffodil.lib.schema.annotation.props.gen.FailureType;
import org.apache.daffodil.lib.schema.annotation.props.gen.FailureType$ProcessingError$;
import org.apache.daffodil.runtime1.dsom.CompiledExpression;
import org.apache.daffodil.runtime1.dsom.SchemaDefinitionDiagnosticBase;
import org.apache.daffodil.runtime1.processors.RuntimeData;
import org.apache.daffodil.runtime1.processors.parsers.AssertionFailed;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.ParseError;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public interface AssertParserMixin {
    public CompiledExpression<Object> messageExpr();

    public boolean discrim();

    public FailureType failureType();

    public static void handleAssertionResult$(AssertParserMixin $this, boolean res, PState state, RuntimeData context) {
        $this.handleAssertionResult(res, state, context);
    }

    default public void handleAssertionResult(boolean res, PState state, RuntimeData context) {
        if (!res) {
            String message = this.getAssertFailureMessage(state);
            FailureType failureType = this.failureType();
            FailureType$ProcessingError$ failureType$ProcessingError$ = FailureType$ProcessingError$.MODULE$;
            if (!(failureType != null ? !failureType.equals(failureType$ProcessingError$) : failureType$ProcessingError$ != null)) {
                AssertionFailed diag = new AssertionFailed(context.schemaFileLocation(), state, message);
                state.setFailed(diag);
                return;
            }
            state.validationError("%s", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{message}));
            return;
        }
        if (this.discrim()) {
            state.resolvePointOfUncertainty();
            return;
        }
    }

    private String getAssertFailureMessage(PState state) {
        Object object;
        try {
            object = (String)this.messageExpr().evaluate(state);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ParseError || throwable2 instanceof SchemaDefinitionDiagnosticBase) {
                Diagnostic e = (Diagnostic)throwable2;
                String kindString = this.discrim() ? "Discriminator" : "Assertion";
                object = kindString + " message expression evaluation failed: " + e.getMessage();
            }
            throw throwable;
        }
        String message = object;
        return message;
    }
}

