/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.common.positional.PositionalSegment;
import org.apache.datasketches.filters.bloomfilter.BitArray;
import org.apache.datasketches.filters.bloomfilter.DirectBitArray;
import org.apache.datasketches.filters.bloomfilter.HeapBitArray;
import org.apache.datasketches.hash.XxHash;
import org.apache.datasketches.hash.XxHash64;

public final class BloomFilter
implements MemorySegmentStatus {
    public static final long MAX_SIZE_BITS = (long)(Integer.MAX_VALUE - Family.BLOOMFILTER.getMaxPreLongs()) * 64L;
    private static final int SER_VER = 1;
    private static final int EMPTY_FLAG_MASK = 4;
    private static final long BIT_ARRAY_OFFSET = 16L;
    private static final int FLAGS_BYTE = 3;
    private final long seed_;
    private final short numHashes_;
    private final BitArray bitArray_;
    private final MemorySegment wseg_;

    BloomFilter(long numBits, int numHashes, long seed) {
        this.seed_ = seed;
        this.numHashes_ = (short)numHashes;
        this.bitArray_ = new HeapBitArray(numBits);
        this.wseg_ = null;
    }

    BloomFilter(long numBits, int numHashes, long seed, MemorySegment wseg) {
        if (wseg.byteSize() < (long)Family.BLOOMFILTER.getMaxPreLongs()) {
            throw new SketchesArgumentException("Provided MemorySegment capacity insufficient to initialize BloomFilter");
        }
        PositionalSegment posSeg = PositionalSegment.wrap(wseg);
        posSeg.setByte((byte)Family.BLOOMFILTER.getMaxPreLongs());
        posSeg.setByte((byte)1);
        posSeg.setByte((byte)Family.BLOOMFILTER.getID());
        posSeg.setByte((byte)0);
        posSeg.setShort((short)numHashes);
        posSeg.setShort((short)0);
        posSeg.setLong(seed);
        this.seed_ = seed;
        this.numHashes_ = (short)numHashes;
        this.bitArray_ = DirectBitArray.initialize(numBits, wseg.asSlice(16L, wseg.byteSize() - 16L));
        this.wseg_ = wseg;
    }

    BloomFilter(short numHashes, long seed, BitArray bitArray, MemorySegment wseg) {
        this.seed_ = seed;
        this.numHashes_ = numHashes;
        this.bitArray_ = bitArray;
        this.wseg_ = wseg;
    }

    public static BloomFilter heapify(MemorySegment seg) {
        return BloomFilter.internalHeapifyOrWrap(seg, false, false);
    }

    public static BloomFilter wrap(MemorySegment seg) {
        return BloomFilter.internalHeapifyOrWrap(seg, true, false);
    }

    public static BloomFilter writableWrap(MemorySegment wseg) {
        return BloomFilter.internalHeapifyOrWrap(wseg, true, true);
    }

    private static BloomFilter internalHeapifyOrWrap(MemorySegment wseg, boolean isWrap, boolean isWritable) {
        boolean isEmpty;
        PositionalSegment posSeg = PositionalSegment.wrap(wseg);
        byte preLongs = posSeg.getByte();
        byte serVer = posSeg.getByte();
        byte familyID = posSeg.getByte();
        byte flags = posSeg.getByte();
        BloomFilter.checkArgument(preLongs < Family.BLOOMFILTER.getMinPreLongs() || preLongs > Family.BLOOMFILTER.getMaxPreLongs(), "Possible corruption: Incorrect number of preamble bytes specified in header");
        BloomFilter.checkArgument(serVer != 1, "Possible corruption: Unrecognized serialization version: " + serVer);
        BloomFilter.checkArgument(familyID != Family.BLOOMFILTER.getID(), "Possible corruption: Incorrect FamilyID for bloom filter. Found: " + familyID);
        short numHashes = posSeg.getShort();
        posSeg.getShort();
        BloomFilter.checkArgument(numHashes < 1, "Possible corruption: Need strictly positive number of hash functions. Found: " + numHashes);
        long seed = posSeg.getLong();
        boolean bl = isEmpty = (flags & 4) != 0;
        if (isWrap) {
            BitArray bitArray = isWritable ? BitArray.writableWrap(wseg.asSlice(16L, wseg.byteSize() - 16L), isEmpty) : BitArray.wrap(wseg.asSlice(16L, wseg.byteSize() - 16L), isEmpty);
            return new BloomFilter(numHashes, seed, bitArray, wseg);
        }
        BitArray bitArray = BitArray.heapify(posSeg, isEmpty);
        return new BloomFilter(numHashes, seed, bitArray, null);
    }

    public void reset() {
        this.bitArray_.reset();
    }

    public boolean isEmpty() {
        return this.bitArray_.isEmpty();
    }

    public long getBitsUsed() {
        return this.bitArray_.getNumBitsSet();
    }

    public long getCapacity() {
        return this.bitArray_.getCapacity();
    }

    public short getNumHashes() {
        return this.numHashes_;
    }

    public long getSeed() {
        return this.seed_;
    }

    @Override
    public boolean hasMemorySegment() {
        return this.wseg_ != null;
    }

    public boolean isReadOnly() {
        return this.wseg_ != null && this.bitArray_.isReadOnly();
    }

    @Override
    public boolean isOffHeap() {
        return this.hasMemorySegment() && this.bitArray_.isOffHeap();
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return MemorySegmentStatus.isSameResource(this.wseg_, that);
    }

    public double getFillPercentage() {
        return (double)this.bitArray_.getNumBitsSet() / (double)this.bitArray_.getCapacity();
    }

    public void update(long item) {
        long h0 = XxHash.hashLong(item, this.seed_);
        long h1 = XxHash.hashLong(item, h0);
        this.updateInternal(h0, h1);
    }

    public void update(double item) {
        long[] data = new long[]{Double.doubleToLongBits(item)};
        long h0 = XxHash.hashLongArr(data, 0, 1, this.seed_);
        long h1 = XxHash.hashLongArr(data, 0, 1, h0);
        this.updateInternal(h0, h1);
    }

    public void update(String item) {
        if (item == null || item.isEmpty()) {
            return;
        }
        byte[] strBytes = item.getBytes(StandardCharsets.UTF_8);
        long h0 = XxHash.hashByteArr(strBytes, 0, strBytes.length, this.seed_);
        long h1 = XxHash.hashByteArr(strBytes, 0, strBytes.length, h0);
        this.updateInternal(h0, h1);
    }

    public void update(byte[] data) {
        if (data == null) {
            return;
        }
        long h0 = XxHash.hashByteArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashByteArr(data, 0, data.length, h0);
        this.updateInternal(h0, h1);
    }

    public void update(char[] data) {
        if (data == null) {
            return;
        }
        long h0 = XxHash.hashCharArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashCharArr(data, 0, data.length, h0);
        this.updateInternal(h0, h1);
    }

    public void update(short[] data) {
        if (data == null) {
            return;
        }
        long h0 = XxHash.hashShortArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashShortArr(data, 0, data.length, h0);
        this.updateInternal(h0, h1);
    }

    public void update(int[] data) {
        if (data == null) {
            return;
        }
        long h0 = XxHash.hashIntArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashIntArr(data, 0, data.length, h0);
        this.updateInternal(h0, h1);
    }

    public void update(long[] data) {
        if (data == null) {
            return;
        }
        long h0 = XxHash.hashLongArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashLongArr(data, 0, data.length, h0);
        this.updateInternal(h0, h1);
    }

    public void update(MemorySegment seg) {
        if (seg == null) {
            return;
        }
        long h0 = XxHash64.hash(seg, 0L, seg.byteSize(), this.seed_);
        long h1 = XxHash64.hash(seg, 0L, seg.byteSize(), h0);
        this.updateInternal(h0, h1);
    }

    private void updateInternal(long h0, long h1) {
        long numBits = this.bitArray_.getCapacity();
        for (int i = 1; i <= this.numHashes_; ++i) {
            long hashIndex = (h0 + (long)i * h1 >>> 1) % numBits;
            this.bitArray_.setBit(hashIndex);
        }
    }

    public boolean queryAndUpdate(long item) {
        long h0 = XxHash.hashLong(item, this.seed_);
        long h1 = XxHash.hashLong(item, h0);
        return this.queryAndUpdateInternal(h0, h1);
    }

    public boolean queryAndUpdate(double item) {
        long[] data = new long[]{Double.doubleToLongBits(item)};
        long h0 = XxHash.hashLongArr(data, 0, 1, this.seed_);
        long h1 = XxHash.hashLongArr(data, 0, 1, h0);
        return this.queryAndUpdateInternal(h0, h1);
    }

    public boolean queryAndUpdate(String item) {
        if (item == null || item.isEmpty()) {
            return false;
        }
        byte[] strBytes = item.getBytes(StandardCharsets.UTF_8);
        long h0 = XxHash.hashByteArr(strBytes, 0, strBytes.length, this.seed_);
        long h1 = XxHash.hashByteArr(strBytes, 0, strBytes.length, h0);
        return this.queryAndUpdateInternal(h0, h1);
    }

    public boolean queryAndUpdate(byte[] data) {
        long h0 = XxHash.hashByteArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashByteArr(data, 0, data.length, h0);
        return this.queryAndUpdateInternal(h0, h1);
    }

    public boolean queryAndUpdate(char[] data) {
        if (data == null) {
            return false;
        }
        long h0 = XxHash.hashCharArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashCharArr(data, 0, data.length, h0);
        return this.queryAndUpdateInternal(h0, h1);
    }

    public boolean queryAndUpdate(short[] data) {
        if (data == null) {
            return false;
        }
        long h0 = XxHash.hashShortArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashShortArr(data, 0, data.length, h0);
        return this.queryAndUpdateInternal(h0, h1);
    }

    public boolean queryAndUpdate(int[] data) {
        if (data == null) {
            return false;
        }
        long h0 = XxHash.hashIntArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashIntArr(data, 0, data.length, h0);
        return this.queryAndUpdateInternal(h0, h1);
    }

    public boolean queryAndUpdate(long[] data) {
        if (data == null) {
            return false;
        }
        long h0 = XxHash.hashLongArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashLongArr(data, 0, data.length, h0);
        return this.queryAndUpdateInternal(h0, h1);
    }

    public boolean queryAndUpdate(MemorySegment seg) {
        if (seg == null) {
            return false;
        }
        long h0 = XxHash64.hash(seg, 0L, seg.byteSize(), this.seed_);
        long h1 = XxHash64.hash(seg, 0L, seg.byteSize(), h0);
        return this.queryAndUpdateInternal(h0, h1);
    }

    private boolean queryAndUpdateInternal(long h0, long h1) {
        long numBits = this.bitArray_.getCapacity();
        boolean valueAlreadyExists = true;
        for (int i = 1; i <= this.numHashes_; ++i) {
            long hashIndex = (h0 + (long)i * h1 >>> 1) % numBits;
            valueAlreadyExists &= this.bitArray_.getAndSetBit(hashIndex);
        }
        return valueAlreadyExists;
    }

    public boolean query(long item) {
        long h0 = XxHash.hashLong(item, this.seed_);
        long h1 = XxHash.hashLong(item, h0);
        return this.queryInternal(h0, h1);
    }

    public boolean query(double item) {
        long[] data = new long[]{Double.doubleToLongBits(item)};
        long h0 = XxHash.hashLongArr(data, 0, 1, this.seed_);
        long h1 = XxHash.hashLongArr(data, 0, 1, h0);
        return this.queryInternal(h0, h1);
    }

    public boolean query(String item) {
        if (item == null || item.isEmpty()) {
            return false;
        }
        byte[] strBytes = item.getBytes(StandardCharsets.UTF_8);
        long h0 = XxHash.hashByteArr(strBytes, 0, strBytes.length, this.seed_);
        long h1 = XxHash.hashByteArr(strBytes, 0, strBytes.length, h0);
        return this.queryInternal(h0, h1);
    }

    public boolean query(byte[] data) {
        if (data == null) {
            return false;
        }
        long h0 = XxHash.hashByteArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashByteArr(data, 0, data.length, h0);
        return this.queryInternal(h0, h1);
    }

    public boolean query(char[] data) {
        if (data == null) {
            return false;
        }
        long h0 = XxHash.hashCharArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashCharArr(data, 0, data.length, h0);
        return this.queryInternal(h0, h1);
    }

    public boolean query(short[] data) {
        if (data == null) {
            return false;
        }
        long h0 = XxHash.hashShortArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashShortArr(data, 0, data.length, h0);
        return this.queryInternal(h0, h1);
    }

    public boolean query(int[] data) {
        if (data == null) {
            return false;
        }
        long h0 = XxHash.hashIntArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashIntArr(data, 0, data.length, h0);
        return this.queryInternal(h0, h1);
    }

    public boolean query(long[] data) {
        if (data == null) {
            return false;
        }
        long h0 = XxHash.hashLongArr(data, 0, data.length, this.seed_);
        long h1 = XxHash.hashLongArr(data, 0, data.length, h0);
        return this.queryInternal(h0, h1);
    }

    public boolean query(MemorySegment seg) {
        if (seg == null) {
            return false;
        }
        long h0 = XxHash64.hash(seg, 0L, seg.byteSize(), this.seed_);
        long h1 = XxHash64.hash(seg, 0L, seg.byteSize(), h0);
        return this.queryInternal(h0, h1);
    }

    private boolean queryInternal(long h0, long h1) {
        long numBits = this.bitArray_.getCapacity();
        for (int i = 1; i <= this.numHashes_; ++i) {
            long hashIndex = (h0 + (long)i * h1 >>> 1) % numBits;
            if (this.bitArray_.getBit(hashIndex)) continue;
            return false;
        }
        return true;
    }

    public void union(BloomFilter other) {
        if (other == null) {
            return;
        }
        if (!this.isCompatible(other)) {
            throw new SketchesArgumentException("Cannot union sketches with different seeds, hash functions, or sizes");
        }
        this.bitArray_.union(other.bitArray_);
    }

    public void intersect(BloomFilter other) {
        if (other == null) {
            return;
        }
        if (!this.isCompatible(other)) {
            throw new SketchesArgumentException("Cannot union sketches with different seeds, hash functions, or sizes");
        }
        this.bitArray_.intersect(other.bitArray_);
    }

    public void invert() {
        this.bitArray_.invert();
    }

    public boolean isCompatible(BloomFilter other) {
        return other != null && this.seed_ == other.seed_ && this.numHashes_ == other.numHashes_ && this.bitArray_.getArrayLength() == other.bitArray_.getArrayLength();
    }

    public long getSerializedSizeBytes() {
        long sizeBytes = 16L;
        return sizeBytes += this.bitArray_.getSerializedSizeBytes();
    }

    public static long getSerializedSize(long numBits) {
        return 16L + BitArray.getSerializedSizeBytes(numBits);
    }

    public byte[] toByteArray() {
        long sizeBytes = this.getSerializedSizeBytes();
        if (sizeBytes > Integer.MAX_VALUE) {
            throw new SketchesStateException("Cannot serialize a BloomFilter of this size using toByteArray(); use toLongArray() instead.");
        }
        byte[] bytes = new byte[(int)sizeBytes];
        if (this.wseg_ == null) {
            MemorySegment seg = MemorySegment.ofArray(bytes);
            PositionalSegment posSeg = PositionalSegment.wrap(seg);
            int numPreLongs = this.isEmpty() ? Family.BLOOMFILTER.getMinPreLongs() : Family.BLOOMFILTER.getMaxPreLongs();
            posSeg.setByte((byte)numPreLongs);
            posSeg.setByte((byte)1);
            posSeg.setByte((byte)Family.BLOOMFILTER.getID());
            posSeg.setByte((byte)(this.bitArray_.isEmpty() ? 4 : 0));
            posSeg.setShort(this.numHashes_);
            posSeg.setShort((short)0);
            posSeg.setLong(this.seed_);
            ((HeapBitArray)this.bitArray_).writeToSegmentAsStream(posSeg);
        } else {
            MemorySegment.copy(this.wseg_, ValueLayout.JAVA_BYTE, 0L, bytes, 0, (int)sizeBytes);
            if (this.isEmpty()) {
                bytes[3] = (byte)(bytes[3] | 4);
            }
        }
        return bytes;
    }

    public long[] toLongArray() {
        long sizeBytes = this.getSerializedSizeBytes();
        long[] longs = new long[(int)(sizeBytes >> 3)];
        if (this.wseg_ == null) {
            MemorySegment wseg = MemorySegment.ofArray(longs);
            PositionalSegment posSeg = PositionalSegment.wrap(wseg);
            int numPreLongs = this.isEmpty() ? Family.BLOOMFILTER.getMinPreLongs() : Family.BLOOMFILTER.getMaxPreLongs();
            posSeg.setByte((byte)numPreLongs);
            posSeg.setByte((byte)1);
            posSeg.setByte((byte)Family.BLOOMFILTER.getID());
            posSeg.setByte((byte)(this.bitArray_.isEmpty() ? 4 : 0));
            posSeg.setShort(this.numHashes_);
            posSeg.setShort((short)0);
            posSeg.setLong(this.seed_);
            ((HeapBitArray)this.bitArray_).writeToSegmentAsStream(posSeg);
        } else {
            MemorySegment.copy(this.wseg_, ValueLayout.JAVA_LONG_UNALIGNED, 0L, longs, 0, (int)(sizeBytes >>> 3));
            if (this.isEmpty()) {
                longs[0] = longs[0] | 0x4000000L;
            }
        }
        return longs;
    }

    private static void checkArgument(boolean condition, String message) {
        if (condition) {
            throw new SketchesArgumentException(message);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("   numBits      : ").append(this.bitArray_.getCapacity()).append(Util.LS);
        sb.append("   numHashes    : ").append(this.numHashes_).append(Util.LS);
        sb.append("   seed         : ").append(this.seed_).append(Util.LS);
        sb.append("   bitsUsed     : ").append(this.bitArray_.getNumBitsSet()).append(Util.LS);
        sb.append("   fill %       : ").append(this.getFillPercentage()).append(Util.LS);
        sb.append("### END SKETCH SUMMARY").append(Util.LS);
        return sb.toString();
    }
}

