/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.quantiles.DataToStringsSketch;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToStringsSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final BagFactory BAG_FACTORY = BagFactory.getInstance();
    private static final Comparator<String> COMPARATOR = Comparator.naturalOrder();
    private static final ArrayOfItemsSerDe<String> SER_DE = new ArrayOfStringsSerDe();

    @Test
    public void execNullInputTuple() throws Exception {
        DataToStringsSketch func = new DataToStringsSketch();
        Tuple resultTuple = (Tuple)func.exec(null);
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        DataToStringsSketch func = new DataToStringsSketch();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple());
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyBag() throws Exception {
        DataToStringsSketch func = new DataToStringsSketch();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void execWrongValueType() throws Exception {
        DataToStringsSketch func = new DataToStringsSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)1.0));
        func.exec(TUPLE_FACTORY.newTuple((Object)bag));
    }

    @Test
    public void execNormalCase() throws Exception {
        DataToStringsSketch func = new DataToStringsSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
    }

    @Test
    public void execMixedNormalCase() throws Exception {
        DataToStringsSketch func = new DataToStringsSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        bag.add(null);
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
    }

    @Test
    public void accumulator() throws Exception {
        DataToStringsSketch func = new DataToStringsSketch();
        Tuple resultTuple = (Tuple)func.getValue();
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(null);
        resultTuple = (Tuple)func.getValue();
        sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple());
        resultTuple = (Tuple)func.getValue();
        sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        resultTuple = (Tuple)func.getValue();
        sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        resultTuple = (Tuple)func.getValue();
        sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
        bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        bag.add(null);
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        resultTuple = (Tuple)func.getValue();
        sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
        func.cleanup();
        resultTuple = (Tuple)func.getValue();
        sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToStringsSketch().getInitial()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple());
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertTrue((boolean)(resultTuple.get(0) instanceof DataBag));
        Assert.assertEquals((long)((DataBag)resultTuple.get(0)).size(), (long)1L);
    }

    @Test
    public void algebraicIntermediateIsSameAsFinal() {
        Assert.assertEquals((String)new DataToStringsSketch().getIntermed(), (String)new DataToStringsSketch().getFinal());
    }

    @Test
    public void algebraicIntermediateFinalNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToStringsSketch().getIntermed()).newInstance();
        Tuple resultTuple = (Tuple)func.exec(null);
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateFinalEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToStringsSketch().getIntermed()).newInstance();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple());
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateFinalNormalCase() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToStringsSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        bag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        ItemsSketch qs = ItemsSketch.getInstance(COMPARATOR);
        qs.update((Object)"b");
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs.toByteArray(SER_DE))));
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test
    public void algebraicIntermediateFinalMixedNullCase() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToStringsSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        innerBag.add(null);
        bag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        ItemsSketch qs = ItemsSketch.getInstance(COMPARATOR);
        qs.update((Object)"b");
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs.toByteArray(SER_DE))));
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        ItemsSketch<String> sketch = DataToStringsSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicIntermediateFinalWrongType() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToStringsSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        func.exec(TUPLE_FACTORY.newTuple((Object)bag));
    }

    @Test
    public void schema() throws Exception {
        DataToStringsSketch func = new DataToStringsSketch();
        Schema schema = func.outputSchema(new Schema());
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((int)schema.size(), (int)1);
        Assert.assertEquals((byte)schema.getField((int)0).type, (byte)110);
        Assert.assertEquals((int)schema.getField((int)0).schema.size(), (int)1);
        Assert.assertEquals((byte)schema.getField((int)0).schema.getField((int)0).type, (byte)50);
    }

    private static ItemsSketch<String> getSketch(Tuple tuple) throws Exception {
        Assert.assertNotNull((Object)tuple);
        Assert.assertEquals((int)tuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)tuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        return ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), COMPARATOR, SER_DE);
    }
}

