/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.pig.quantiles.GetKFromStringsSketch;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetKFromStringsSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final Comparator<String> COMPARATOR = Comparator.naturalOrder();
    private static final ArrayOfItemsSerDe<String> SER_DE = new ArrayOfStringsSerDe();

    @Test
    public void defalutK() throws Exception {
        GetKFromStringsSketch func = new GetKFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        Integer result = (Integer)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)))));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)128);
    }

    @Test
    public void customK() throws Exception {
        GetKFromStringsSketch func = new GetKFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance((int)1024, COMPARATOR);
        Integer result = (Integer)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)))));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)1024);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooFewInputs() throws Exception {
        GetKFromStringsSketch func = new GetKFromStringsSketch();
        func.exec(TUPLE_FACTORY.newTuple());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooManyInputs() throws Exception {
        GetKFromStringsSketch func = new GetKFromStringsSketch();
        func.exec(TUPLE_FACTORY.newTuple(2));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetKFromStringsSketch func = new GetKFromStringsSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0)));
    }
}

