/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.pig.quantiles.GetPmfFromStringsSketch;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetPmfFromStringsSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final Comparator<String> COMPARATOR = Comparator.naturalOrder();
    private static final ArrayOfItemsSerDe<String> SER_DE = new ArrayOfStringsSerDe();

    @Test
    public void emptySketch() throws Exception {
        GetPmfFromStringsSketch func = new GetPmfFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), "a")));
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void normalCase() throws Exception {
        GetPmfFromStringsSketch func = new GetPmfFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        for (int i = 1; i <= 10; ++i) {
            sketch.update((Object)String.format("%02d", i));
        }
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), "02", "07")));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)0.1);
        Assert.assertEquals((double)((Double)resultTuple.get(1)), (double)0.5);
        Assert.assertEquals((double)((Double)resultTuple.get(2)), (double)0.4);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongNumberOfInputs() throws Exception {
        GetPmfFromStringsSketch func = new GetPmfFromStringsSketch();
        func.exec(TUPLE_FACTORY.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetPmfFromStringsSketch func = new GetPmfFromStringsSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeOfSplitPoint() throws Exception {
        GetPmfFromStringsSketch func = new GetPmfFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), 1)));
    }
}

