/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.pig.PigTestingUtil;
import org.apache.datasketches.pig.theta.AexcludeB;
import org.apache.datasketches.pig.theta.Estimate;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AexcludeBTest {
    @Test
    public void checkConstructors() {
        AexcludeB aNOTb = new AexcludeB();
        aNOTb = new AexcludeB("9001");
        aNOTb = new AexcludeB(9001L);
        Assert.assertNotNull((Object)aNOTb);
    }

    @Test
    public void checkNullCombinations() throws IOException {
        Tuple resultTuple;
        AexcludeB aNbFunc = new AexcludeB();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(2);
        try {
            resultTuple = (Tuple)aNbFunc.exec(inputTuple);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        inputTuple = TupleFactory.getInstance().newTuple(2);
        inputTuple.set(1, (Object)PigTestingUtil.createDbaFromQssRange(256, 0, 128));
        try {
            resultTuple = (Tuple)aNbFunc.exec(inputTuple);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        inputTuple = TupleFactory.getInstance().newTuple(2);
        inputTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, 0, 256));
        try {
            resultTuple = (Tuple)aNbFunc.exec(inputTuple);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        inputTuple = TupleFactory.getInstance().newTuple(2);
        inputTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, 0, 256));
        inputTuple.set(1, (Object)PigTestingUtil.createDbaFromQssRange(256, 0, 128));
        resultTuple = (Tuple)aNbFunc.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)128.0, (double)0.0);
    }

    @Test
    public void outputSchemaTest() throws IOException {
        AexcludeB udf = new AexcludeB("512");
        Schema inputSchema = null;
        Schema nullOutputSchema = null;
        Schema outputSchema = null;
        Schema.FieldSchema outputOuterFs0 = null;
        Schema outputInnerSchema = null;
        Schema.FieldSchema outputInnerFs0 = null;
        inputSchema = Schema.generateNestedSchema((byte)120, (byte[])new byte[]{50});
        nullOutputSchema = udf.outputSchema(null);
        outputSchema = udf.outputSchema(inputSchema);
        outputOuterFs0 = outputSchema.getField(0);
        outputInnerSchema = outputOuterFs0.schema;
        outputInnerFs0 = outputInnerSchema.getField(0);
        Assert.assertNull((Object)nullOutputSchema, (String)"Should be null");
        Assert.assertNotNull((Object)outputOuterFs0, (String)"outputSchema.getField(0) schema may not be null");
        String expected = "tuple";
        String result = DataType.findTypeName((byte)outputOuterFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        expected = "bytearray";
        Assert.assertNotNull((Object)outputInnerFs0, (String)"innerSchema.getField(0) schema may not be null");
        result = DataType.findTypeName((byte)outputInnerFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        StringBuilder sb = new StringBuilder();
        sb.append("input schema: ").append(inputSchema).append(PigTestingUtil.LS).append("output schema: ").append(outputSchema).append(PigTestingUtil.LS).append("outputOuterFs: ").append(outputOuterFs0).append(", type: ").append(DataType.findTypeName((byte)outputOuterFs0.type)).append(PigTestingUtil.LS).append("outputInnerSchema: ").append(outputInnerSchema).append(PigTestingUtil.LS).append("outputInnerFs0: ").append(outputInnerFs0).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs0.type)).append(PigTestingUtil.LS);
        AexcludeBTest.println(sb.toString());
    }

    @Test
    public void printlnTest() {
        AexcludeBTest.println(this.getClass().getSimpleName());
    }

    static void println(String s) {
    }
}

