/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RuntimeInfoTest
extends BaseJDBCTestCase {
    private static String[] RuntimeinfoCmd = new String[]{"-Demma.verbosity.level=silent", "org.apache.derby.drda.NetworkServerControl", "runtimeinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
    private static String[] RuntimeinfoLocaleCmd = new String[]{"-Demma.verbosity.level=silent", "-Duser.language=err", "-Duser.country=DE", "org.apache.derby.drda.NetworkServerControl", "runtimeinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/functionTests/tests/derbynet/RuntimeInfoTest.policy";
    private static final Locale englishLocale = new Locale("en", "US");
    private static final Locale germanLocale = new Locale("de", "DE");
    private static final String stdout_err_tags = "<[^<>]*STD.*>";
    private static final HashMap<Locale, HashMap<String, String>> outputs;

    public RuntimeInfoTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("RuntimeInfoTest");
        baseTestSuite.addTest(RuntimeInfoTest.decorateTest(englishLocale, "testRunTests"));
        baseTestSuite.addTest(RuntimeInfoTest.decorateTest(germanLocale, "testRunTests"));
        baseTestSuite.addTest(RuntimeInfoTest.decorateTest(englishLocale, "testRuntimeInfoWithLongValues"));
        return baseTestSuite;
    }

    public void testRunTests() throws Exception {
        this.x_testRuntimeInfoWithActiveConn();
        this.x_testRuntimeInfoLocale();
        this.x_testRuntimeInfoAfterConnClose();
    }

    public void x_testRuntimeInfoWithActiveConn() throws Exception {
        Process process = RuntimeInfoTest.execJavaCmd(RuntimeinfoCmd);
        String string = this.sed(RuntimeInfoTest.readProcessOutput(process));
        this.printIfVerbose("testRuntimeInfo", string);
        String string2 = outputs.get(Locale.getDefault()).get("RuntimeInfoWithActiveConn").toString();
        RuntimeInfoTest.assertEquals((String)"Output doesn't match", (String)string2, (String)string);
    }

    public void x_testRuntimeInfoLocale() throws Exception {
        Connection connection = this.getConnection();
        Connection connection2 = this.openDefaultConnection();
        PreparedStatement preparedStatement = RuntimeInfoTest.prepareAndExecuteQuery(connection, "SELECT count(*) from sys.systables");
        PreparedStatement preparedStatement2 = RuntimeInfoTest.prepareAndExecuteQuery(connection, "VALUES(1)");
        Connection connection3 = this.openDefaultConnection();
        PreparedStatement preparedStatement3 = RuntimeInfoTest.prepareAndExecuteQuery(connection2, "SELECT count(*) from sys.systables");
        PreparedStatement preparedStatement4 = RuntimeInfoTest.prepareAndExecuteQuery(connection2, "VALUES(2)");
        Process process = RuntimeInfoTest.execJavaCmd(RuntimeinfoLocaleCmd);
        String string = this.sed(RuntimeInfoTest.readProcessOutput(process));
        this.printIfVerbose("testRuntimeInfoLocale", string);
        int n = 0;
        String string2 = "\tSYSLH0001\tSELECT count(*) from sys.systables\n\tSYSLH0002\tVALUES(1)\n";
        String string3 = "\tSYSLH0002\tVALUES(1)\n\tSYSLH0001\tSELECT count(*) from sys.systables\n";
        n = string.indexOf(string2);
        if (n == -1) {
            n = string.indexOf(string3);
            RuntimeInfoTest.assertTrue((n != -1 ? 1 : 0) != 0);
        }
        n = 0;
        string2 = "\tSYSLH0001\tSELECT count(*) from sys.systables\n\tSYSLH0002\tVALUES(2)\n";
        string3 = "\tSYSLH0002\tVALUES(2)\n\tSYSLH0001\tSELECT count(*) from sys.systables\n";
        n = string.indexOf(string2);
        if (n == -1) {
            n = string.indexOf(string3);
            RuntimeInfoTest.assertTrue((n != -1 ? 1 : 0) != 0);
        }
        n = 0;
        string2 = outputs.get(Locale.getDefault()).get("RuntimeInfoLocaleString").toString();
        RuntimeInfoTest.assertTrue((string.indexOf(string2) != -1 ? 1 : 0) != 0);
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
        preparedStatement4.close();
        connection.close();
        connection2.close();
        connection3.close();
    }

    public void x_testRuntimeInfoAfterConnClose() throws Exception {
        String string = outputs.get(Locale.getDefault()).get("RuntimeInfoAfterConnClose");
        String string2 = null;
        int n = 60;
        while (!string.equals(string2 = this.sed(NetworkServerTestSetup.getNetworkServerControl(TestConfiguration.getCurrent().getPort()).getRuntimeInfo())) && --n > 0) {
            RuntimeInfoTest.sleep(1000L);
        }
        NetworkServerTestSetup.getNetworkServerControl().shutdown();
        this.printIfVerbose("testRuntimeInfoMethod", string2);
        RuntimeInfoTest.assertEquals((String)"Output doesn't match", (String)string, (String)string2);
    }

    public void testRuntimeInfoWithLongValues() throws Exception {
        for (int i = 0; i < 200; ++i) {
            RuntimeInfoTest.prepareAndExecuteQuery(this.openDefaultConnection(), "VALUES 'Hello, World! How are you today?',\n'Not that bad today, actually. Thanks for asking.'\n-- Let's add some more text to increase the output length.\n-- And even more here... The statement text, including this\n-- comment, will be included in the runtimeinfo output.\n");
        }
        String string = NetworkServerTestSetup.getNetworkServerControl().getRuntimeInfo();
        RuntimeInfoTest.println(string);
        RuntimeInfoTest.assertEquals((int)65535, (int)string.length());
    }

    public static PreparedStatement prepareAndExecuteQuery(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        return preparedStatement;
    }

    private String sed(String string) {
        HashMap<String, String> hashMap = outputs.get(Locale.getDefault());
        string = string.replaceAll(hashMap.get("sedMemorySearch"), hashMap.get("sedMemoryReplace"));
        string = string.replaceAll(hashMap.get("sedSessionNumberSearch"), hashMap.get("sedSessionNumberReplace"));
        string = string.replaceAll(stdout_err_tags, "");
        string = string.trim();
        return string;
    }

    private void printIfVerbose(String string, String string2) {
        RuntimeInfoTest.println("\n\n>>>" + string + ">>>");
        RuntimeInfoTest.println(string2);
        RuntimeInfoTest.println("<<<" + string + "<<<\n\n");
    }

    private static Test decorateTest(Locale locale, String string) {
        Object object = new RuntimeInfoTest(string);
        object = TestConfiguration.clientServerDecorator((Test)object);
        object = TestConfiguration.singleUseDatabaseDecorator((Test)object);
        object = new LocaleTestSetup((Test)object, locale);
        return new SecurityManagerSetup((Test)object, POLICY_FILE_NAME);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("RuntimeInfoWithActiveConn", "--- Derby Network Server Runtime Information ---\n---------- Session Information ---------------\nSession # :##\n\n\n-------------------------------------------------------------\n# Connection Threads : 1\n# Active Sessions : 1\n# Waiting  Sessions : 0\n\nTotal Memory : #####\tFree Memory : #####");
        hashMap.put("RuntimeInfoAfterConnClose", "--- Derby Network Server Runtime Information ---\n---------- Session Information ---------------\nSession # :##\n\n\n-------------------------------------------------------------\n# Connection Threads : 4\n# Active Sessions : 1\n# Waiting  Sessions : 0\n\nTotal Memory : #####\tFree Memory : #####");
        hashMap.put("sedMemorySearch", "(?m)Memory : [0-9]*");
        hashMap.put("sedMemoryReplace", "Memory : #####");
        hashMap.put("sedSessionNumberSearch", "(?m)^(Session # :)\\d+");
        hashMap.put("sedSessionNumberReplace", "$1##");
        hashMap.put("RuntimeInfoLocaleString", "\tStmt ID\t\tSQLText\n\t-------------\t-----------\n\n\n\nSession");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("RuntimeInfoWithActiveConn", "--- Laufzeitinformationen zu Derby Network Server ---\n---------- Sessioninformationen ---------------\nSessionnummer:##\n\n\n-------------------------------------------------------------\nAnzahl Verbindungsthreads: 1\nAnzahl aktive Sessions: 1\nAnzahl wartende Sessions: 0\n\nSpeicher gesamt: #####\tFreier Speicher: #####");
        hashMap2.put("RuntimeInfoAfterConnClose", "--- Laufzeitinformationen zu Derby Network Server ---\n---------- Sessioninformationen ---------------\nSessionnummer:##\n\n\n-------------------------------------------------------------\nAnzahl Verbindungsthreads: 4\nAnzahl aktive Sessions: 1\nAnzahl wartende Sessions: 0\n\nSpeicher gesamt: #####\tFreier Speicher: #####");
        hashMap2.put("sedMemorySearch", "Speicher gesamt: [0-9]*\tFreier Speicher: [0-9]*");
        hashMap2.put("sedMemoryReplace", "Speicher gesamt: #####\tFreier Speicher: #####");
        hashMap2.put("sedSessionNumberSearch", "(?m)^(Sessionnummer:)\\d+");
        hashMap2.put("sedSessionNumberReplace", "$1##");
        hashMap2.put("RuntimeInfoLocaleString", "\tAnwsg-ID\t\tSQL-Text\n\t-------------\t-----------\n\n\n\nSessionnummer");
        outputs = new HashMap();
        outputs.put(englishLocale, hashMap);
        outputs.put(germanLocale, hashMap2);
    }
}

