/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SavepointJdbc30Test
extends BaseJDBCTestCase {
    public SavepointJdbc30Test(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SavepointJdbc30_JSR169Test suite");
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("SavepointJdbc30_JSR169Test:embedded");
        baseTestSuite2.addTestSuite(SavepointJdbc30Test.class);
        baseTestSuite2.addTest(SavepointJdbc30Test.getEmbeddedSuite("SavepointJdbc30_JSR169Test:embedded only"));
        baseTestSuite.addTest((Test)baseTestSuite2);
        BaseTestSuite baseTestSuite3 = new BaseTestSuite("SavepointJdbc30_JSR169Test:client");
        baseTestSuite3.addTestSuite(SavepointJdbc30Test.class);
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)baseTestSuite3));
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite2 = new BaseTestSuite("SavepointJdbc30_JSR169Test:embedded XADataSource");
            baseTestSuite2.addTestSuite(SavepointJdbc30Test.class);
            baseTestSuite2.addTest(SavepointJdbc30Test.getEmbeddedSuite("SavepointJdbc30_JSR169Test:embedded only XADataSource"));
            baseTestSuite.addTest(TestConfiguration.connectionXADecorator((Test)baseTestSuite2));
            baseTestSuite3 = new BaseTestSuite("SavepointJdbc30_JSR169Test:client XADatasource");
            baseTestSuite3.addTestSuite(SavepointJdbc30Test.class);
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionXADecorator((Test)baseTestSuite3)));
        }
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 1, 2)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t1 (c11 int, c12 smallint)");
                statement.execute("create table t2 (c11 int)");
                this.getConnection().commit();
            }
        };
    }

    private static Test getEmbeddedSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        Method[] methodArray = SavepointJdbc30Test.class.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string2;
            Method method = methodArray[i];
            if (method.getParameterTypes().length > 0 || !method.getReturnType().equals(Void.TYPE) || !(string2 = method.getName()).startsWith("x")) continue;
            baseTestSuite.addTest((Test)new SavepointJdbc30Test(string2));
        }
        return baseTestSuite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("truncate table t1");
        statement.execute("truncate table t2");
        this.commit();
    }

    public void testNoSavepointsIfAutoCommit() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        try {
            connection.setSavepoint();
            SavepointJdbc30Test.fail((String)"No unnamed savepoints allowed if autocommit is true");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("XJ010", sQLException);
        }
        try {
            connection.setSavepoint("notallowed");
            SavepointJdbc30Test.fail((String)"No named savepoints allowed if autocommit is true");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("XJ010", sQLException);
        }
    }

    public void testReusingSavepoints() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint("s1");
        connection.releaseSavepoint(savepoint);
        connection.setSavepoint("s1");
        connection.rollback();
    }

    public void testNullName() throws SQLException {
        Connection connection = this.getConnection();
        try {
            connection.setSavepoint(null);
            SavepointJdbc30Test.fail((String)"FAIL 3 Null savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("XJ011", sQLException);
        }
        connection.rollback();
    }

    public void testNamesAndIds() throws SQLException {
        Savepoint savepoint;
        Connection connection = this.getConnection();
        try {
            savepoint = connection.setSavepoint();
            savepoint.getSavepointId();
            savepoint.getSavepointName();
            SavepointJdbc30Test.fail((String)"FAIL 4 getSavepointName on id savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("XJ014", sQLException);
        }
        connection.rollback();
        try {
            savepoint = connection.setSavepoint("s1");
            savepoint.getSavepointName();
            savepoint.getSavepointId();
            SavepointJdbc30Test.fail((String)"FAIL 4 getSavepointId on named savepoint ");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("XJ013", sQLException);
        }
        connection.rollback();
    }

    public void testBug4465() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint("s1");
        connection.commit();
        connection.setSavepoint("s2");
        Statement statement = this.createStatement();
        statement.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            connection.releaseSavepoint(savepoint);
            SavepointJdbc30Test.fail((String)"FAIL 5a - release savepoint from a different transaction did not raise error");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
        connection.commit();
        savepoint = connection.setSavepoint("s1");
        connection.commit();
        connection.setSavepoint("s2");
        statement.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            connection.rollback(savepoint);
            SavepointJdbc30Test.fail((String)"FAIL 5b - rollback savepoint from a different transaction did not raise error");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
        connection.commit();
    }

    public void testReleaseReleasedSavepoint() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint("s1");
        connection.releaseSavepoint(savepoint);
        connection.setSavepoint("s2");
        Statement statement = this.createStatement();
        statement.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            connection.releaseSavepoint(savepoint);
            SavepointJdbc30Test.fail((String)"FAIL 6a - releasing a released savepoint did not raise error");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
        connection.commit();
    }

    public void testRollbackReleasedSavepoint() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint("s1");
        connection.releaseSavepoint(savepoint);
        connection.setSavepoint("s2");
        Statement statement = this.createStatement();
        statement.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            connection.rollback(savepoint);
            SavepointJdbc30Test.fail((String)"FAIL 6b - rollback a released savepoint did not raise error");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
        connection.commit();
    }

    public void testReleaseSavepointFromOtherTransaction() throws SQLException {
        Connection connection;
        Connection connection2;
        block3: {
            connection2 = this.getConnection();
            Savepoint savepoint = connection2.setSavepoint("s1");
            Statement statement = this.createStatement();
            statement.executeUpdate("INSERT INTO T1 VALUES(2,1)");
            connection = this.openDefaultConnection();
            try {
                connection.releaseSavepoint(savepoint);
                SavepointJdbc30Test.fail((String)"FAIL 6c - releasing another transaction's savepoint did not raise error");
            }
            catch (SQLException sQLException) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("XJ010", sQLException);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("XJ008", sQLException);
            }
        }
        connection2.commit();
        connection.commit();
    }

    public void testSwapSavepointsAcrossConnectionAndRelease() throws SQLException {
        Connection connection;
        Connection connection2;
        block3: {
            connection2 = this.getConnection();
            connection = this.openDefaultConnection();
            connection.setAutoCommit(false);
            Savepoint savepoint = connection.setSavepoint("s1");
            Statement statement = this.createStatement();
            statement.executeUpdate("INSERT INTO T1 VALUES(2,1)");
            connection2.setSavepoint("s1");
            try {
                connection2.releaseSavepoint(savepoint);
                SavepointJdbc30Test.fail((String)"FAIL 7a - releasing a another transaction's savepoint did not raise error");
            }
            catch (SQLException sQLException) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B502", sQLException);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("XJ097", sQLException);
            }
        }
        connection2.commit();
        connection.commit();
    }

    public void testSwapSavepointsAcrossConnectionsAndRollback() throws SQLException {
        Connection connection;
        Connection connection2;
        block3: {
            connection2 = this.getConnection();
            connection = this.openDefaultConnection();
            connection.setAutoCommit(false);
            Savepoint savepoint = connection.setSavepoint("s1");
            Statement statement = this.createStatement();
            statement.executeUpdate("INSERT INTO T1 VALUES(2,1)");
            connection2.setSavepoint("s1");
            try {
                connection2.rollback(savepoint);
                SavepointJdbc30Test.fail((String)"FAIL 7b - rolling back a another transaction's savepoint did not raise error");
            }
            catch (SQLException sQLException) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B502", sQLException);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("XJ097", sQLException);
            }
        }
        connection2.commit();
        connection.commit();
    }

    public void testSavepointName() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint("myname");
        String string = savepoint.getSavepointName();
        SavepointJdbc30Test.assertEquals((String)string, (String)"myname");
        connection.rollback();
    }

    public void testNameCaseSensitivity() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint("MyName");
        String string = savepoint.getSavepointName();
        SavepointJdbc30Test.assertEquals((String)string, (String)"MyName");
        connection.rollback();
    }

    public void testRollbackMultipleTimes() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint("MyName");
        connection.rollback(savepoint);
        connection.rollback(savepoint);
        connection.rollback();
    }

    public void testReleaseMultipleTimes() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint("MyName");
        connection.releaseSavepoint(savepoint);
        try {
            connection.releaseSavepoint(savepoint);
            SavepointJdbc30Test.fail((String)"FAIL 12 releasing a savepoint multiple times should fail");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
        connection.rollback();
    }

    public void testSavepointFromEarlierTransactionAfterToggleAutocommit() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint("MyName");
        connection.setAutoCommit(true);
        connection.setAutoCommit(false);
        Savepoint savepoint2 = connection.setSavepoint("MyName1");
        try {
            connection.releaseSavepoint(savepoint);
            SavepointJdbc30Test.fail((String)"FAIL 13 shouldn't be able to use a savepoint from earlier transaction after setting autocommit on and off");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
        connection.releaseSavepoint(savepoint2);
        connection.rollback();
    }

    public void testRollbackReleasesSavepointArray() throws SQLException {
        Connection connection = this.getConnection();
        Connection connection2 = this.openDefaultConnection();
        connection2.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into t1 values(1,1)");
        statement.executeUpdate("insert into t1 values(2,0)");
        connection.commit();
        statement.executeUpdate("update t1 set c11=c11+1 where c12 > 0");
        Statement statement2 = connection2.createStatement();
        Savepoint savepoint = connection2.setSavepoint("MyName");
        try {
            statement2.executeUpdate("update t1 set c11=c11+1 where c12 < 1");
            SavepointJdbc30Test.fail((String)"FAIL 14 should have gotten lock time out");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("40XL1", sQLException);
        }
        try {
            connection2.releaseSavepoint(savepoint);
            SavepointJdbc30Test.fail((String)"FAIL 14 A non-user initiated transaction rollback should release the internal savepoint array");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
        connection.rollback();
        connection2.rollback();
        statement.execute("delete from t1");
        connection.commit();
    }

    public void testSavepointsInBatch() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("delete from t1");
        statement.addBatch("insert into t1 values(1,1)");
        statement.addBatch("insert into t1 values(2,2)");
        Savepoint savepoint = connection.setSavepoint();
        statement.addBatch("insert into t1 values(3,3)");
        statement.executeBatch();
        connection.rollback(savepoint);
        this.assertTableRowCount("T1", 0);
        connection.rollback();
    }

    public void testGrammarCheck() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        try {
            statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS");
            SavepointJdbc30Test.fail((String)"FAIL 16 Should have gotten exception for missing ON ROLLBACK RETAIN CURSORS");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("42X01", sQLException);
        }
        try {
            statement.executeUpdate("SAVEPOINT s1 UNIQUE ON ROLLBACK RETAIN CURSORS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 16 Should have gotten exception for multiple ON ROLLBACK RETAIN CURSORS");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("42613", sQLException);
        }
        try {
            statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN LOCKS");
            SavepointJdbc30Test.fail((String)"FAIL 16 Should have gotten exception for multiple ON ROLLBACK RETAIN LOCKS");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("42613", sQLException);
        }
        try {
            statement.executeUpdate("SAVEPOINT s1 UNIQUE UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 16 Should have gotten exception for multiple UNIQUE keywords");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("42613", sQLException);
        }
        statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN CURSORS ON ROLLBACK RETAIN LOCKS");
        statement.executeUpdate("RELEASE TO SAVEPOINT s1");
        this.getConnection().rollback();
    }

    public void testNoNestedSavepointsWhenUsingSQL() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        statement.executeUpdate("SAVEPOINT s1 UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        try {
            statement.executeUpdate("SAVEPOINT s2 UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 17a Should have gotten exception for nested savepoints");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B002", sQLException);
        }
        statement.executeUpdate("RELEASE TO SAVEPOINT s1");
        statement.executeUpdate("SAVEPOINT s2 UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        this.getConnection().rollback();
        statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        try {
            statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 17b Should have gotten exception for nested savepoints");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B002", sQLException);
        }
        this.getConnection().rollback();
    }

    public void testNoNestedSavepointsInsideJdbcSavepoint() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint();
        Statement statement = this.getConnection().createStatement();
        try {
            statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 18 shouldn't be able set SQL savepoint nested inside JDBC savepoints");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B002", sQLException);
        }
        connection.releaseSavepoint(savepoint);
        statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        connection.rollback();
    }

    public void testNoNestedSavepointsInsideSqlSavepoint() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        try {
            statement.executeUpdate("SAVEPOINT s2 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 19 shouldn't be able set SQL savepoint nested inside SQL savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B002", sQLException);
        }
        statement.executeUpdate("RELEASE TO SAVEPOINT s1");
        statement.executeUpdate("SAVEPOINT s2 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        this.getConnection().rollback();
    }

    public void testRollbackSqlSavepointSameAsJdbc() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("DELETE FROM T1");
        connection.commit();
        statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        statement.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        statement.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        statement.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        statement.execute("ROLLBACK TO SAVEPOINT s1");
        ResultSet resultSet = statement.executeQuery("select count(*) from t1");
        resultSet.next();
        SavepointJdbc30Test.assertEquals((int)resultSet.getInt(1), (int)0);
        connection.rollback();
    }

    public void testReleaseSqlSavepointAndRollback() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        statement.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        statement.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        statement.executeUpdate("INSERT INTO T1 VALUES(3,1)");
        statement.executeUpdate("RELEASE TO SAVEPOINT s1");
        connection.rollback();
        ResultSet resultSet = statement.executeQuery("select count(*) from t1");
        resultSet.next();
        SavepointJdbc30Test.assertEquals((int)resultSet.getInt(1), (int)0);
        connection.rollback();
    }

    public void testNoSqlSavepointStartingWithSYS() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("SAVEPOINT SYSs2 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 22 shouldn't be able to create a SQL savepoint starting with name SYS");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("42939", sQLException);
        }
        this.getConnection().rollback();
    }

    public void testBug5817() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table savepoint (savepoint int, release int)");
        ResultSet resultSet = statement.executeQuery("select count(*) from savepoint");
        resultSet.next();
        SavepointJdbc30Test.assertEquals((String)(" There should have been 0 rows in the table, but found " + resultSet.getInt(1)), (int)resultSet.getInt(1), (int)0);
        statement.execute("SAVEPOINT savepoint ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        statement.executeUpdate("INSERT INTO savepoint VALUES(1,1)");
        statement.execute("RELEASE SAVEPOINT savepoint");
        resultSet = statement.executeQuery("select count(*) from savepoint");
        resultSet.next();
        SavepointJdbc30Test.assertEquals((String)("There should have been 1 rows in the table, but found " + resultSet.getInt(1)), (int)resultSet.getInt(1), (int)1);
        statement.execute("SAVEPOINT release ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        statement.executeUpdate("INSERT INTO savepoint VALUES(2,1)");
        statement.execute("ROLLBACK TO SAVEPOINT release");
        resultSet = statement.executeQuery("select count(*) from savepoint");
        resultSet.next();
        SavepointJdbc30Test.assertEquals((String)("ERROR: There should have been 1 rows in the table, but found " + resultSet.getInt(1)), (int)resultSet.getInt(1), (int)1);
        statement.execute("RELEASE SAVEPOINT release");
        this.getConnection().rollback();
    }

    public void testNameLengthMax128Chars() throws SQLException {
        try {
            this.getConnection().setSavepoint("MyName1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
            SavepointJdbc30Test.fail((String)"FAIL 24 shouldn't be able to create a SQL savepoint with name exceeding 128 characters");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("42622", sQLException);
        }
        this.getConnection().rollback();
    }

    public void testNoSqlSavepointStartingWithSYSThroughJdbc() throws SQLException {
        try {
            this.getConnection().setSavepoint("SYSs2");
            SavepointJdbc30Test.fail((String)"FAIL 25 shouldn't be able to create a SQL savepoint starting with name SYS through jdbc");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("42939", sQLException);
        }
        this.getConnection().rollback();
    }

    public void testRollbackNullSavepoint() throws SQLException {
        block3: {
            try {
                this.getConnection().rollback(null);
                SavepointJdbc30Test.fail((String)"FAIL 26a rollback of null savepoint did not raise error ");
            }
            catch (SQLException sQLException) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B001", sQLException);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("3B502", sQLException);
            }
        }
    }

    public void testReleaseNullSavepoint() throws SQLException {
        block3: {
            try {
                this.getConnection().releaseSavepoint(null);
                SavepointJdbc30Test.fail((String)"FAIL 26b release of null savepoint did not raise error ");
            }
            catch (SQLException sQLException) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B001", sQLException);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("3B502", sQLException);
            }
        }
    }

    public void testQuotes() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table test_quotes(x int)");
        statement.execute("insert into test_quotes values 1");
        Savepoint savepoint = this.getConnection().setSavepoint("a \" b ' c");
        statement.execute("insert into test_quotes values 2");
        this.getConnection().rollback(savepoint);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from test_quotes"), "1");
        this.getConnection().releaseSavepoint(savepoint);
    }

    public void xtestNoConflictWithGeneratedName() throws SQLException {
        Connection connection = this.getConnection();
        connection.setSavepoint();
        connection.setSavepoint("i.SAVEPT0");
        connection.rollback();
    }

    public void xtestRollbackWillReleaseLaterSavepoints() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.execute("DELETE FROM T1");
        Savepoint savepoint = connection.setSavepoint();
        statement.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        Savepoint savepoint2 = connection.setSavepoint("s1");
        statement.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        Savepoint savepoint3 = connection.setSavepoint("s2");
        statement.executeUpdate("INSERT INTO T1 VALUES(3,1)");
        connection.rollback(savepoint2);
        this.assertTableRowCount("T1", 1);
        try {
            connection.releaseSavepoint(savepoint3);
            SavepointJdbc30Test.fail((String)"FAIL 41a release of rolled back savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
        try {
            connection.rollback(savepoint3);
            SavepointJdbc30Test.fail((String)"FAIL 41b release of rolled back savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
        connection.rollback(savepoint);
        this.assertTableRowCount("T1", 0);
        connection.rollback();
    }

    public void xtestRollbackWillReleaseActiveSavepoints() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint();
        connection.rollback();
        try {
            connection.rollback(savepoint);
            SavepointJdbc30Test.fail((String)"FAIL 42 release of rolled back savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
    }

    public void xtestCommitWillReleaseActiveSavepoints() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint();
        connection.commit();
        try {
            connection.rollback(savepoint);
            SavepointJdbc30Test.fail((String)"FAIL 42a Rollback after commit.");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B001", sQLException);
        }
    }

    public void xtestReuseNameAfterRelease() throws SQLException {
        Savepoint savepoint;
        Connection connection;
        block3: {
            connection = this.getConnection();
            savepoint = connection.setSavepoint("s1");
            try {
                connection.setSavepoint("s1");
                SavepointJdbc30Test.fail((String)"Should not be able to set two savepoints with the same name");
            }
            catch (SQLException sQLException) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B501", sQLException);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("3B002", sQLException);
            }
        }
        connection.releaseSavepoint(savepoint);
        connection.setSavepoint("s1");
        connection.rollback();
    }

    public void xtestReuseNameAfterRollback() throws SQLException {
        Connection connection;
        block3: {
            connection = this.getConnection();
            Savepoint savepoint = connection.setSavepoint("MyName");
            connection.rollback(savepoint);
            try {
                connection.setSavepoint("MyName");
                SavepointJdbc30Test.fail((String)"FAIL 45 reuse of savepoint name after rollback should fail");
            }
            catch (SQLException sQLException) {
                if (SavepointJdbc30Test.usingEmbedded()) {
                    SavepointJdbc30Test.assertSQLState("3B501", sQLException);
                }
                if (!SavepointJdbc30Test.usingDerbyNetClient()) break block3;
                SavepointJdbc30Test.assertSQLState("3B002", sQLException);
            }
        }
        connection.rollback();
    }

    public void xtestCursorsCloseOnRollback() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement(1003, 1007, 1);
        Statement statement2 = this.createStatement();
        statement2.executeUpdate("DELETE FROM T1");
        statement2.executeUpdate("INSERT INTO T1 VALUES(19,1)");
        statement2.executeUpdate("INSERT INTO T1 VALUES(19,2)");
        statement2.executeUpdate("INSERT INTO T1 VALUES(19,3)");
        ResultSet resultSet = statement2.executeQuery("select * from t1");
        resultSet.next();
        ResultSet resultSet2 = statement.executeQuery("select * from t1");
        resultSet2.next();
        Savepoint savepoint = connection.setSavepoint();
        ResultSet resultSet3 = statement2.executeQuery("select * from t1");
        resultSet3.next();
        ResultSet resultSet4 = statement.executeQuery("select * from t1");
        resultSet4.next();
        connection.rollback(savepoint);
        try {
            resultSet.next();
            SavepointJdbc30Test.fail((String)"FAIL 46 shouldn't be able to use a resultset (declared before the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("XCL16", sQLException);
        }
        try {
            resultSet2.next();
            SavepointJdbc30Test.fail((String)"FAIL 46 shouldn't be able to use a holdable resultset (declared before the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("XCL16", sQLException);
        }
        try {
            resultSet3.next();
            SavepointJdbc30Test.fail((String)"FAIL 46 shouldn't be able to use a resultset (declared within the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("XCL16", sQLException);
        }
        try {
            resultSet4.next();
            SavepointJdbc30Test.fail((String)"FAIL 46 shouldn't be able to use a holdable resultset (declared within the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("XCL16", sQLException);
        }
        connection.rollback();
    }

    public void xtestGetSavepoint() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint();
        Savepoint savepoint2 = connection.setSavepoint();
        savepoint.getSavepointId();
        savepoint2.getSavepointId();
        connection.releaseSavepoint(savepoint2);
        savepoint2 = connection.setSavepoint();
        savepoint2.getSavepointId();
        connection.commit();
        savepoint2 = connection.setSavepoint();
        savepoint2.getSavepointId();
        connection.rollback();
        savepoint2 = connection.setSavepoint();
        savepoint2.getSavepointId();
        connection.rollback();
    }

    public void xtestNestedSavepoints() throws SQLException {
        Connection connection = this.getConnection();
        Savepoint savepoint = connection.setSavepoint();
        Savepoint savepoint2 = connection.setSavepoint();
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 48 shouldn't be able set SQL savepoint nested inside JDBC/SQL savepoints");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B002", sQLException);
        }
        connection.releaseSavepoint(savepoint2);
        try {
            statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            SavepointJdbc30Test.fail((String)"FAIL 48 Should have gotten exception for nested SQL savepoint");
        }
        catch (SQLException sQLException) {
            SavepointJdbc30Test.assertSQLState("3B002", sQLException);
        }
        connection.releaseSavepoint(savepoint);
        statement.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        connection.rollback();
    }
}

