/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class VarargsTest
extends GeneratedColumnsHelper {
    private static final String NEEDS_DERBY_STYLE = "42ZC9";
    private static final String NEEDS_JAVA_STYLE = "42ZCA";
    private static final String RETURNS_RESULT_SETS = "42ZCB";
    private static final String AMBIGUOUS = "42X73";
    private static final String NO_SUCH_METHOD = "42X50";
    private static final String BAD_TIME_FORMAT = "22007";
    private static final String BAD_BOOLEAN_FORMAT = "22018";
    private static final String NEEDS_DJRS_STYLE = "42ZB2";
    private static final String NEEDS_PARAMETER_MARKER = "42886";

    public VarargsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("UserDefinedAggregatesTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(VarargsTest.class));
        return baseTestSuite;
    }

    public void test_01_basicSyntax() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create function varargsDerbyStyle( a int ... ) returns int\nparameter style derby language java no sql\nexternal name 'Foo.foo'\n");
        this.goodStatement(connection, "create function varargsTableFunction( a int ... )\nreturns table( b int )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'Foo.foo'\n");
        this.goodStatement(connection, "create function nonvarargsJavaStyle( a int ) returns int\nparameter style java language java no sql\nexternal name 'Foo.foo'\n");
        this.goodStatement(connection, "create procedure varargsDerbyStyle( a int ... )\nlanguage java parameter style derby no sql\nexternal name 'Foo.foo'\n");
        this.goodStatement(connection, "create procedure nonvarargsJavaStyle( a int )\nlanguage java parameter style java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(NEEDS_DERBY_STYLE, "create function varargsJavaStyle( a int ... ) returns int\nparameter style java language java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(NEEDS_JAVA_STYLE, "create function nonvarargsDerbyStyle( a int ) returns int\nparameter style derby language java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(NEEDS_DERBY_STYLE, "create procedure varargsDerbyStyle( a int ... )\nlanguage java parameter style java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(NEEDS_JAVA_STYLE, "create procedure nonvarargsDerbyStyle( a int )\nlanguage java parameter style derby no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError("42X01", "create function varargsDerbyStyleNoParam( ... ) returns int\nparameter style derby language java no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError("42X01", "create procedure varargsDerbyStyleNoParam( ... )\nlanguage java parameter style derby no sql\nexternal name 'Foo.foo'\n");
        this.expectCompilationError(RETURNS_RESULT_SETS, "create procedure varargsDerbyStyle( a int ... )\nlanguage java parameter style derby no sql result sets 1\nexternal name 'Foo.foo'\n");
    }

    public void test_02_simple() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create function maximum( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.max'\n");
        this.goodStatement(connection, "create function formatMessage( message varchar( 32672 ),  args varchar( 32672 ) ... ) returns varchar( 32672 )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.formatMessage'\n");
        this.assertResults(connection, "values maximum()", new String[][]{{null}}, false);
        this.assertResults(connection, "values maximum( null )", new String[][]{{null}}, false);
        this.assertResults(connection, "values maximum( 1 )", new String[][]{{"1"}}, false);
        this.assertResults(connection, "values maximum( 1, 3, 2 )", new String[][]{{"3"}}, false);
        this.assertResults(connection, "values formatMessage( 'First {0} then {1} then {2}', 'one', 'two', 'three' )", new String[][]{{"First one then two then three"}}, false);
    }

    public void test_03_misc() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create function ambiguousTypes( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.ambiguousTypes'\n");
        this.expectCompilationError(AMBIGUOUS, "values ambiguousTypes( 1, 2, 3 )");
        this.goodStatement(connection, "create function maxInts( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.maxInts'\n");
        this.assertResults(connection, "values maxInts( 3 )", new String[][]{{"3"}}, false);
        this.assertResults(connection, "values maxInts( 1, 2, 5, 4, 3 )", new String[][]{{"5"}}, false);
        this.goodStatement(connection, "create function nonVarargsMethod( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.nonVarargsMethod'\n");
        this.expectCompilationError(NO_SUCH_METHOD, "values nonVarargsMethod( 3 )");
        this.goodStatement(connection, "create function vnvr_vararg( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.vnvr'\n");
        this.goodStatement(connection, "create function vnvr_nonvararg( a int ) returns int\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.vnvr'\n");
        this.assertResults(connection, "values vnvr_vararg( 3 )", new String[][]{{"3"}}, false);
        this.assertResults(connection, "values vnvr_nonvararg( 3 )", new String[][]{{"-3"}}, false);
        this.goodStatement(connection, "create function lnv( a int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.lnv'\n");
        this.goodStatement(connection, "create function lnv_1( a int, b int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.lnv'\n");
        this.goodStatement(connection, "create function lnv_2( a int, b int, c int ... ) returns int\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.lnv'\n");
        this.assertResults(connection, "values lnv( 5, 4, 3, 2, 1 )", new String[][]{{"5"}}, false);
        this.assertResults(connection, "values lnv_1( 5, 4, 3, 2, 1 )", new String[][]{{"4"}}, false);
        this.assertResults(connection, "values lnv_2( 5, 4, 3, 2, 1 )", new String[][]{{"3"}}, false);
    }

    public void test_04_inOut() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection connection = this.getConnection();
        CallableStatement callableStatement = null;
        this.goodStatement(connection, "create procedure inVarargs( out result varchar( 32672 ), b int ... )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.inVarargs'\n");
        callableStatement = this.chattyPrepareCall(connection, "call inVarargs( ?, ? )");
        callableStatement.registerOutParameter(1, 12);
        callableStatement.setInt(2, 5);
        callableStatement.execute();
        VarargsTest.assertEquals((String)"RESULT:  5", (String)callableStatement.getString(1));
        callableStatement = this.chattyPrepareCall(connection, "call inVarargs( ?, ?, ? )");
        callableStatement.registerOutParameter(1, 12);
        callableStatement.setInt(2, 5);
        callableStatement.setInt(3, 4);
        callableStatement.execute();
        VarargsTest.assertEquals((String)"RESULT:  5 4", (String)callableStatement.getString(1));
        callableStatement = this.chattyPrepareCall(connection, "call inVarargs( ?, ?, ?, ? )");
        callableStatement.registerOutParameter(1, 12);
        callableStatement.setInt(2, 5);
        callableStatement.setInt(3, 4);
        callableStatement.setInt(4, 3);
        callableStatement.execute();
        VarargsTest.assertEquals((String)"RESULT:  5 4 3", (String)callableStatement.getString(1));
        this.goodStatement(connection, "create procedure outVarargs( seed int, out b int ... )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.outVarargs'\n");
        callableStatement = this.chattyPrepareCall(connection, "call outVarargs( ? )");
        callableStatement.setInt(1, 5);
        callableStatement.execute();
        callableStatement = this.chattyPrepareCall(connection, "call outVarargs( ?, ? )");
        callableStatement.registerOutParameter(2, 4);
        callableStatement.setInt(1, 5);
        callableStatement.execute();
        VarargsTest.assertEquals((int)5, (int)callableStatement.getInt(2));
        callableStatement = this.chattyPrepareCall(connection, "call outVarargs( ?, ?, ? )");
        callableStatement.registerOutParameter(2, 4);
        callableStatement.registerOutParameter(3, 4);
        callableStatement.setInt(1, 5);
        callableStatement.execute();
        VarargsTest.assertEquals((int)5, (int)callableStatement.getInt(2));
        VarargsTest.assertEquals((int)6, (int)callableStatement.getInt(3));
        callableStatement = this.chattyPrepareCall(connection, "call outVarargs( ?, ?, ?, ? )");
        callableStatement.registerOutParameter(2, 4);
        callableStatement.registerOutParameter(3, 4);
        callableStatement.registerOutParameter(4, 4);
        callableStatement.setInt(1, 5);
        callableStatement.execute();
        VarargsTest.assertEquals((int)5, (int)callableStatement.getInt(2));
        VarargsTest.assertEquals((int)6, (int)callableStatement.getInt(3));
        VarargsTest.assertEquals((int)7, (int)callableStatement.getInt(4));
        this.goodStatement(connection, "create procedure inoutVarargs( seed int, inout b int ... )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.inoutVarargs'\n");
        callableStatement = this.chattyPrepareCall(connection, "call inoutVarargs( ? )");
        callableStatement.setInt(1, 5);
        callableStatement.execute();
        callableStatement = this.chattyPrepareCall(connection, "call inoutVarargs( ?, ? )");
        callableStatement.registerOutParameter(2, 4);
        callableStatement.setInt(1, 5);
        callableStatement.setInt(2, 3);
        callableStatement.execute();
        VarargsTest.assertEquals((int)8, (int)callableStatement.getInt(2));
        callableStatement = this.chattyPrepareCall(connection, "call inoutVarargs( ?, ?, ? )");
        callableStatement.registerOutParameter(2, 4);
        callableStatement.registerOutParameter(3, 4);
        callableStatement.setInt(1, 5);
        callableStatement.setInt(2, 3);
        callableStatement.setInt(3, 10);
        callableStatement.execute();
        VarargsTest.assertEquals((int)8, (int)callableStatement.getInt(2));
        VarargsTest.assertEquals((int)15, (int)callableStatement.getInt(3));
        callableStatement = this.chattyPrepareCall(connection, "call inoutVarargs( ?, ?, ?, ? )");
        callableStatement.registerOutParameter(2, 4);
        callableStatement.registerOutParameter(3, 4);
        callableStatement.registerOutParameter(4, 4);
        callableStatement.setInt(1, 5);
        callableStatement.setInt(2, 3);
        callableStatement.setInt(3, 10);
        callableStatement.setInt(4, 100);
        callableStatement.execute();
        VarargsTest.assertEquals((int)8, (int)callableStatement.getInt(2));
        VarargsTest.assertEquals((int)15, (int)callableStatement.getInt(3));
        VarargsTest.assertEquals((int)105, (int)callableStatement.getInt(4));
    }

    public void test_05_datatypes() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create function makeBlob( a varchar( 32672 ) ) returns blob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeBlob'\n");
        this.goodStatement(connection, "create function makeBytes( a varchar( 32672 ) ) returns char(1) for bit data\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeBytes'\n");
        this.goodStatement(connection, "create function makeVarBytes( a varchar( 32672 ) ) returns varchar(10) for bit data\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeBytes'\n");
        this.goodStatement(connection, "create function makeLongVarBytes( a varchar( 32672 ) ) returns long varchar for bit data\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeBytes'\n");
        this.goodStatement(connection, "create function makeClob( a varchar( 32672 ) ) returns clob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.makeClob'\n");
        this.goodStatement(connection, "create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create function makePrice( currencyCode char( 3 ), amount decimal( 31, 5 ), timeInstant Timestamp )\nreturns Price language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.vetDatatype(connection, "boolean", "boolean", "true", "false", "true", "1", "1", "2");
        this.vetDatatype(connection, "long", "bigint", "1", "2", "3", "1", "3", "6");
        this.vetDatatype(connection, "int", "int", "1", "2", "3", "1", "3", "6");
        this.vetDatatype(connection, "short", "smallint", "1", "2", "3", "1", "3", "6");
        this.vetDatatype(connection, "bigdecimal", "decimal(5,2)", "1.0", "2.0", "3.0", "1", "3", "6");
        this.vetDatatype(connection, "bigdecimal", "numeric(5,2)", "1.0", "2.0", "3.0", "1", "3", "6");
        this.vetDatatype(connection, "double", "double", "1.0", "2.0", "3.0", "1.0", "3.0", "6.0");
        this.vetDatatype(connection, "float", "real", "1.0", "2.0", "3.0", "1.0", "3.0", "6.0");
        this.vetDatatype(connection, "double", "float", "1.0", "2.0", "3.0", "1.0", "3.0", "6.0");
        this.vetDatatype(connection, "blob", "blob", "makeBlob( '1' )", "makeBlob( '2' )", "makeBlob( '3' )", "1", "3", "6");
        this.vetDatatype(connection, "clob", "clob", "makeClob( '1' )", "makeClob( '2' )", "makeClob( '3' )", "1", "12", "123");
        this.vetDatatype(connection, "byte[]", "char(1) for bit data", "makeBytes( '1' )", "makeBytes( '2' )", "makeBytes( '3' )", "1", "3", "6");
        this.vetDatatype(connection, "byte[]", "varchar(10) for bit data", "makeVarBytes( '1' )", "makeVarBytes( '2' )", "makeVarBytes( '3' )", "1", "3", "6");
        this.vetDatatype(connection, "byte[]", "long varchar for bit data", "makeLongVarBytes( '1' )", "makeLongVarBytes( '2' )", "makeLongVarBytes( '3' )", "1", "3", "6");
        this.vetDatatype(connection, "String", "char(1)", "'1'", "'2'", "'3'", "1", "12", "123");
        this.vetDatatype(connection, "String", "varchar(10)", "'1'", "'2'", "'3'", "1", "12", "123");
        this.vetDatatype(connection, "String", "long varchar", "'1'", "'2'", "'3'", "1", "12", "123");
        this.vetDatatype(connection, "date", "date", "date('1994-02-23')", "date('1995-02-23')", "date('1996-02-23')", "1", "2", "3");
        this.vetDatatype(connection, "time", "time", "time('15:09:02')", "time('14:09:02')", "time('13:09:02')", "1", "2", "3");
        this.vetDatatype(connection, "timestamp", "timestamp", "timestamp('1962-09-23 03:23:34.234')", "timestamp('1963-09-23 03:23:34.234')", "timestamp('1964-09-23 03:23:34.234')", "1", "2", "3");
        this.vetDatatype(connection, "Price", "Price", "makePrice( 'USD', cast( 9.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') )", "makePrice( 'USD', cast( 10.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') )", "makePrice( 'USD', cast( 11.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') )", "1", "2", "3");
        this.goodStatement(connection, "create table all_types\n(\n    bigint_col  bigint,\n    blob_col    blob,\n    boolean_col boolean,\n    char_col    char( 1 ),\n    char_for_bit_data_col   char( 1 ) for bit data,\n    clob_col    clob,\n    date_col    date,\n    decimal_col decimal,\n    double_col  double,\n    float_col   float,\n    integer_col int,\n    long_varchar_col    long varchar,\n    long_varchar_for_bit_data_col   long varchar for bit data,\n    numeric_col    numeric,\n    real_col       real,\n    smallint_col   smallint,\n    time_col       time,\n    timestamp_col  timestamp,\n    varchar_col    varchar( 5 ),\n    varchar_for_bit_data_col  varchar( 10 ) for bit data,\n    price_col    price\n)\n");
        this.goodStatement(connection, "insert into all_types values\n(\n    1,\n    makeBlob( '1' ),\n    true,\n    '1',\n    makeBytes( '1' ),\n    makeClob( '1' ),\n    date( '1994-02-23' ),\n    1.0,\n    1.0,\n    1.0,\n    1,\n    '1',\n    makeLongVarBytes( '1' ),\n    1.0,\n    1.0,\n    1,\n    time( '15:09:02' ),\n    timestamp( '1962-09-23 03:23:34.234' ),\n    '1',\n    makeVarBytes( '1' ),\n    makePrice( 'USD', cast( 9.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') )\n)\n");
        this.vetNumericCoercions(connection, "long", "bigint", "1");
        this.vetNumericCoercions(connection, "int", "int", "1");
        this.vetNumericCoercions(connection, "short", "smallint", "1");
        this.vetNumericCoercions(connection, "bigdecimal", "decimal", "1");
        this.vetNumericCoercions(connection, "bigdecimal", "numeric", "1");
        this.vetNumericCoercions(connection, "float", "real", "1.0");
        this.vetNumericCoercions(connection, "double", "double", "1.0");
        this.vetNumericCoercions(connection, "double", "float", "1.0");
        this.vetStringCoercions(connection, "String", "char(50)");
        this.vetStringCoercions(connection, "clob", "clob");
        this.vetStringCoercions(connection, "String", "varchar(50)");
        this.vetStringCoercions(connection, "String", "long varchar");
        this.vetTimeCoercions(connection, "date", "date");
        this.vetTimeCoercions(connection, "time", "time");
        this.vetTimeCoercions(connection, "timestamp", "timestamp");
        this.vetBinaryCoercions(connection, "byte[]", "char(1) for bit data");
        this.vetBinaryCoercions(connection, "byte[]", "varchar(10) for bit data");
        this.vetBinaryCoercions(connection, "byte[]", "long varchar for bit data");
        this.vetBooleanCoercions(connection, "boolean", "boolean");
        this.vetPriceCoercions(connection, "Price", "Price");
    }

    private void vetDatatype(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws Exception {
        this.createAddFunc(connection, string2);
        this.assertResults(connection, "values addFunc( '" + string2 + "' )", new String[][]{{null}}, false);
        this.assertResults(connection, "values addFunc( '" + string2 + "', " + string3 + " )", new String[][]{{string + " " + string2 + " " + string6}}, false);
        this.assertResults(connection, "values addFunc( '" + string2 + "', " + string3 + ", " + string4 + " )", new String[][]{{string + " " + string2 + " " + string7}}, false);
        this.assertResults(connection, "values addFunc( '" + string2 + "', " + string3 + ", " + string4 + ", " + string5 + " )", new String[][]{{string + " " + string2 + " " + string8}}, false);
        this.dropAddFunc(connection);
    }

    private void createAddFunc(Connection connection, String string) throws Exception {
        this.goodStatement(connection, "create function addFunc( seed varchar( 50 ), a " + string + " ... ) returns varchar( 50 )\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.add'\n");
    }

    private void dropAddFunc(Connection connection) throws Exception {
        this.goodStatement(connection, "drop function addFunc");
    }

    private void vetNumericCoercions(Connection connection, String string, String string2, String string3) throws Exception {
        this.createAddFunc(connection, string2);
        this.vetGoodCoercion(connection, string, string2, "bigint_col", string3);
        this.vetGoodCoercion(connection, string, string2, "decimal_col", string3);
        this.vetGoodCoercion(connection, string, string2, "double_col", string3);
        this.vetGoodCoercion(connection, string, string2, "float_col", string3);
        this.vetGoodCoercion(connection, string, string2, "integer_col", string3);
        this.vetGoodCoercion(connection, string, string2, "numeric_col", string3);
        this.vetGoodCoercion(connection, string, string2, "real_col", string3);
        this.vetGoodCoercion(connection, string, string2, "smallint_col", string3);
        this.vetBadCoercion(connection, string2, "blob_col", "42821");
        this.vetBadCoercion(connection, string2, "boolean_col", "42821");
        this.vetBadCoercion(connection, string2, "char_col", "42821");
        this.vetBadCoercion(connection, string2, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "clob_col", "42821");
        this.vetBadCoercion(connection, string2, "date_col", "42821");
        this.vetBadCoercion(connection, string2, "long_varchar_col", "42821");
        this.vetBadCoercion(connection, string2, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "time_col", "42821");
        this.vetBadCoercion(connection, string2, "timestamp_col", "42821");
        this.vetBadCoercion(connection, string2, "varchar_col", "42821");
        this.vetBadCoercion(connection, string2, "price_col", "42821");
        this.dropAddFunc(connection);
    }

    private void vetGoodCoercion(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        this.assertResults(connection, "select addFunc( '" + string2 + "', " + string3 + " ) from all_types", new String[][]{{string + " " + string2 + " " + string4}}, true);
    }

    private void vetBadCoercion(Connection connection, String string, String string2, String string3) throws Exception {
        this.expectCompilationError(string3, "select addFunc( '" + string + "', " + string2 + " ) from all_types");
    }

    private void vetStringCoercions(Connection connection, String string, String string2) throws Exception {
        this.createAddFunc(connection, string2);
        boolean bl = string.equals("clob") || string2.equals("long varchar");
        this.vetGoodCoercion(connection, string, string2, "char_col", "1");
        this.vetGoodCoercion(connection, string, string2, "clob_col", "1");
        this.vetGoodCoercion(connection, string, string2, "long_varchar_col", "1");
        this.vetGoodCoercion(connection, string, string2, "varchar_col", "1");
        this.vetGoodCoercion(connection, string, string2, "boolean_col", "true");
        if (bl) {
            this.vetBadCoercion(connection, string2, "date_col", "42821");
            this.vetBadCoercion(connection, string2, "time_col", "42821");
            this.vetBadCoercion(connection, string2, "timestamp_col", "42821");
        } else {
            this.vetGoodCoercion(connection, string, string2, "date_col", "1994-02-23");
            this.vetGoodCoercion(connection, string, string2, "time_col", "15:09:02");
            this.vetGoodCoercion(connection, string, string2, "timestamp_col", "1962-09-23 03:23:34.234");
        }
        this.vetBadCoercion(connection, string2, "bigint_col", "42821");
        this.vetBadCoercion(connection, string2, "decimal_col", "42821");
        this.vetBadCoercion(connection, string2, "double_col", "42821");
        this.vetBadCoercion(connection, string2, "float_col", "42821");
        this.vetBadCoercion(connection, string2, "integer_col", "42821");
        this.vetBadCoercion(connection, string2, "numeric_col", "42821");
        this.vetBadCoercion(connection, string2, "real_col", "42821");
        this.vetBadCoercion(connection, string2, "smallint_col", "42821");
        this.vetBadCoercion(connection, string2, "blob_col", "42821");
        this.vetBadCoercion(connection, string2, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "price_col", "42821");
        this.dropAddFunc(connection);
    }

    private void vetTimeCoercions(Connection connection, String string, String string2) throws Exception {
        this.createAddFunc(connection, string2);
        if (string.equals("date")) {
            this.vetGoodCoercion(connection, string, string2, "date_col", "1");
        } else {
            this.vetBadCoercion(connection, string2, "date_col", "42821");
        }
        if (string.equals("time")) {
            this.vetGoodCoercion(connection, string, string2, "time_col", "1");
        } else {
            this.vetBadCoercion(connection, string2, "time_col", "42821");
        }
        if (string.equals("timestamp")) {
            this.vetGoodCoercion(connection, string, string2, "timestamp_col", "1");
        } else {
            this.vetBadCoercion(connection, string2, "timestamp_col", "42821");
        }
        this.vetBadFormat(connection, string2, "char_col", BAD_TIME_FORMAT);
        this.vetBadFormat(connection, string2, "varchar_col", BAD_TIME_FORMAT);
        this.vetBadCoercion(connection, string2, "clob_col", "42821");
        this.vetBadCoercion(connection, string2, "long_varchar_col", "42821");
        this.vetBadCoercion(connection, string2, "boolean_col", "42821");
        this.vetBadCoercion(connection, string2, "bigint_col", "42821");
        this.vetBadCoercion(connection, string2, "decimal_col", "42821");
        this.vetBadCoercion(connection, string2, "double_col", "42821");
        this.vetBadCoercion(connection, string2, "float_col", "42821");
        this.vetBadCoercion(connection, string2, "integer_col", "42821");
        this.vetBadCoercion(connection, string2, "numeric_col", "42821");
        this.vetBadCoercion(connection, string2, "real_col", "42821");
        this.vetBadCoercion(connection, string2, "smallint_col", "42821");
        this.vetBadCoercion(connection, string2, "blob_col", "42821");
        this.vetBadCoercion(connection, string2, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "price_col", "42821");
        this.dropAddFunc(connection);
    }

    private void vetBadFormat(Connection connection, String string, String string2, String string3) throws Exception {
        this.expectExecutionError(connection, string3, "select addFunc( '" + string + "', " + string2 + " ) from all_types");
    }

    private void vetBinaryCoercions(Connection connection, String string, String string2) throws Exception {
        this.createAddFunc(connection, string2);
        this.vetGoodCoercion(connection, string, string2, "char_for_bit_data_col", "1");
        this.vetGoodCoercion(connection, string, string2, "varchar_for_bit_data_col", "1");
        this.vetGoodCoercion(connection, string, string2, "long_varchar_for_bit_data_col", "1");
        this.vetBadCoercion(connection, string2, "char_col", "42821");
        this.vetBadCoercion(connection, string2, "varchar_col", "42821");
        this.vetBadCoercion(connection, string2, "clob_col", "42821");
        this.vetBadCoercion(connection, string2, "long_varchar_col", "42821");
        this.vetBadCoercion(connection, string2, "date_col", "42821");
        this.vetBadCoercion(connection, string2, "time_col", "42821");
        this.vetBadCoercion(connection, string2, "timestamp_col", "42821");
        this.vetBadCoercion(connection, string2, "boolean_col", "42821");
        this.vetBadCoercion(connection, string2, "bigint_col", "42821");
        this.vetBadCoercion(connection, string2, "decimal_col", "42821");
        this.vetBadCoercion(connection, string2, "double_col", "42821");
        this.vetBadCoercion(connection, string2, "float_col", "42821");
        this.vetBadCoercion(connection, string2, "integer_col", "42821");
        this.vetBadCoercion(connection, string2, "numeric_col", "42821");
        this.vetBadCoercion(connection, string2, "real_col", "42821");
        this.vetBadCoercion(connection, string2, "smallint_col", "42821");
        this.vetBadCoercion(connection, string2, "blob_col", "42821");
        this.vetBadCoercion(connection, string2, "price_col", "42821");
        this.dropAddFunc(connection);
    }

    private void vetBooleanCoercions(Connection connection, String string, String string2) throws Exception {
        this.createAddFunc(connection, string2);
        this.vetGoodCoercion(connection, string, string2, "boolean_col", "1");
        this.vetBadFormat(connection, string2, "char_col", BAD_BOOLEAN_FORMAT);
        this.vetBadFormat(connection, string2, "varchar_col", BAD_BOOLEAN_FORMAT);
        this.vetBadFormat(connection, string2, "clob_col", BAD_BOOLEAN_FORMAT);
        this.vetBadFormat(connection, string2, "long_varchar_col", BAD_BOOLEAN_FORMAT);
        this.vetBadCoercion(connection, string2, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "date_col", "42821");
        this.vetBadCoercion(connection, string2, "time_col", "42821");
        this.vetBadCoercion(connection, string2, "timestamp_col", "42821");
        this.vetBadCoercion(connection, string2, "bigint_col", "42821");
        this.vetBadCoercion(connection, string2, "decimal_col", "42821");
        this.vetBadCoercion(connection, string2, "double_col", "42821");
        this.vetBadCoercion(connection, string2, "float_col", "42821");
        this.vetBadCoercion(connection, string2, "integer_col", "42821");
        this.vetBadCoercion(connection, string2, "numeric_col", "42821");
        this.vetBadCoercion(connection, string2, "real_col", "42821");
        this.vetBadCoercion(connection, string2, "smallint_col", "42821");
        this.vetBadCoercion(connection, string2, "blob_col", "42821");
        this.vetBadCoercion(connection, string2, "price_col", "42821");
        this.dropAddFunc(connection);
    }

    private void vetPriceCoercions(Connection connection, String string, String string2) throws Exception {
        this.createAddFunc(connection, string2);
        this.vetGoodCoercion(connection, string, string2, "price_col", "1");
        this.vetBadCoercion(connection, string2, "char_col", "42821");
        this.vetBadCoercion(connection, string2, "varchar_col", "42821");
        this.vetBadCoercion(connection, string2, "clob_col", "42821");
        this.vetBadCoercion(connection, string2, "long_varchar_col", "42821");
        this.vetBadCoercion(connection, string2, "boolean_col", "42821");
        this.vetBadCoercion(connection, string2, "char_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "long_varchar_for_bit_data_col", "42821");
        this.vetBadCoercion(connection, string2, "date_col", "42821");
        this.vetBadCoercion(connection, string2, "time_col", "42821");
        this.vetBadCoercion(connection, string2, "timestamp_col", "42821");
        this.vetBadCoercion(connection, string2, "bigint_col", "42821");
        this.vetBadCoercion(connection, string2, "decimal_col", "42821");
        this.vetBadCoercion(connection, string2, "double_col", "42821");
        this.vetBadCoercion(connection, string2, "float_col", "42821");
        this.vetBadCoercion(connection, string2, "integer_col", "42821");
        this.vetBadCoercion(connection, string2, "numeric_col", "42821");
        this.vetBadCoercion(connection, string2, "real_col", "42821");
        this.vetBadCoercion(connection, string2, "smallint_col", "42821");
        this.vetBadCoercion(connection, string2, "blob_col", "42821");
        this.dropAddFunc(connection);
    }

    public void test_06_tableFunctions() throws Exception {
        if (!this.vmSupportsVarargs()) {
            return;
        }
        Connection connection = this.getConnection();
        this.expectCompilationError(NEEDS_DJRS_STYLE, "create function tf_derby( rowValues varchar( 32672 ) )\nreturns table\n(\n    col1 varchar( 32672 )\n)\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.oneColumnRows'\n");
        this.expectCompilationError(NEEDS_DJRS_STYLE, "create function tf_derby_varargs( rowValues varchar( 32672 ) ... )\nreturns table\n(\n    col1 varchar( 32672 )\n)\nlanguage java parameter style derby no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.oneColumnRows'\n");
        this.goodStatement(connection, "create function oneColumnRows( rowValues varchar( 32672 ) ... )\nreturns table\n(\n    col1 varchar( 32672 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.oneColumnRows'\n");
        this.assertResults(connection, "select * from table( oneColumnRows() ) s", new String[0][], false);
        this.assertResults(connection, "select * from table( oneColumnRows( 'one' ) ) s", new String[][]{{"one"}}, false);
        this.assertResults(connection, "select * from table( oneColumnRows( 'one', 'two' ) ) s", new String[][]{{"one"}, {"two"}}, false);
        this.assertResults(connection, "select * from table( oneColumnRows( 'one', 'two', 'three' ) ) s", new String[][]{{"one"}, {"two"}, {"three"}}, false);
    }

    public void test_07_6047() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create procedure PROC_6047( inout x int )\nparameter style java modifies sql data language java\nexternal name 'DUMMY.PROC_6047'\n");
        this.expectCompilationError(NEEDS_PARAMETER_MARKER, "call PROC_6047(1)");
    }

    private boolean vmSupportsVarargs() {
        return JDBC.vmSupportsJDBC3();
    }
}

