/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.lang.WISCInsert;

public class wisconsin {
    public static void main(String[] stringArray) throws Throwable {
        ij.getPropertyArg((String[])stringArray);
        Connection connection = ij.startJBMS();
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(8);
        wisconsin.createTables(connection, true);
        String string = "org/apache/derbyTesting/functionTests/tests/lang/wisc_setup.sql";
        URL uRL = wisconsin.getTestResource(string);
        InputStream inputStream = wisconsin.openTestResource(uRL);
        if (inputStream == null) {
            throw new Exception("SQL Resource missing:" + string);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 2048);
        ij.runScript((Connection)connection, (InputStream)bufferedInputStream, (String)"US-ASCII", (OutputStream)System.out, (String)null);
        connection.commit();
    }

    public static void createTables(Connection connection, boolean bl) throws SQLException {
        wisconsin.createTables(connection, bl, 10000);
    }

    public static void createTables(Connection connection, boolean bl, int n) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("create table TENKTUP1 ( unique1 int not null, unique2 int not null, two int, four int, ten int, twenty int, onePercent int, tenPercent int, twentyPercent int, fiftyPercent int, unique3 int, evenOnePercent int, oddOnePercent int, stringu1 char(52) not null, stringu2 char(52) not null, string4 char(52) )");
        WISCInsert wISCInsert = new WISCInsert();
        wISCInsert.doWISCInsert(n, "TENKTUP1", connection);
        statement.execute("create unique index TK1UNIQUE1 on TENKTUP1(unique1)");
        statement.execute("create unique index TK1UNIQUE2 on TENKTUP1(unique2)");
        statement.execute("create index TK1TWO on TENKTUP1(two)");
        statement.execute("create index TK1FOUR on TENKTUP1(four)");
        statement.execute("create index TK1TEN on TENKTUP1(ten)");
        statement.execute("create index TK1TWENTY on TENKTUP1(twenty)");
        statement.execute("create index TK1ONEPERCENT on TENKTUP1(onePercent)");
        statement.execute("create index TK1TWENTYPERCENT on TENKTUP1(twentyPercent)");
        statement.execute("create index TK1EVENONEPERCENT on TENKTUP1(evenOnePercent)");
        statement.execute("create index TK1ODDONEPERCENT on TENKTUP1(oddOnePercent)");
        statement.execute("create unique index TK1STRINGU1 on TENKTUP1(stringu1)");
        statement.execute("create unique index TK1STRINGU2 on TENKTUP1(stringu2)");
        statement.execute("create index TK1STRING4 on TENKTUP1(string4)");
        statement.execute("create table TENKTUP2 (unique1 int not null, unique2 int not null, two int, four int, ten int, twenty int, onePercent int, tenPercent int, twentyPercent int, fiftyPercent int, unique3 int, evenOnePercent int, oddOnePercent int, stringu1 char(52), stringu2 char(52), string4 char(52) )");
        wISCInsert = new WISCInsert();
        wISCInsert.doWISCInsert(n, "TENKTUP2", connection);
        statement.execute("create unique index TK2UNIQUE1 on TENKTUP2(unique1)");
        statement.execute("create unique index TK2UNIQUE2 on TENKTUP2(unique2)");
        statement.execute("create table ONEKTUP ( unique1 int not null, unique2 int not null, two int, four int, ten int, twenty int, onePercent int, tenPercent int, twentyPercent int, fiftyPercent int, unique3 int, evenOnePercent int, oddOnePercent int, stringu1 char(52), stringu2 char(52), string4 char(52) )");
        wISCInsert = new WISCInsert();
        wISCInsert.doWISCInsert(1000, "ONEKTUP", connection);
        statement.execute("create unique index ONEKUNIQUE1 on ONEKTUP(unique1)");
        statement.execute("create unique index ONEKUNIQUE2 on ONEKTUP(unique2)");
        statement.execute("create table BPRIME (\t unique1 int, unique2 int, two int, four int, ten int, twenty int, onePercent int, tenPercent int, twentyPercent int, fiftyPercent int, unique3 int, evenOnePercent int, oddOnePercent int, stringu1 char(52), stringu2 char(52), string4 char(52))");
        statement.execute("insert into BPRIME select * from TENKTUP2 where TENKTUP2.unique2 < 1000");
        connection.commit();
        if (!bl) {
            return;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, "BPRIME");
        preparedStatement.setInt(3, 0);
        preparedStatement.executeUpdate();
        connection.commit();
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, "TENKTUP1");
        preparedStatement.setInt(3, 0);
        preparedStatement.executeUpdate();
        connection.commit();
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, "TENKTUP2");
        preparedStatement.setInt(3, 0);
        preparedStatement.executeUpdate();
        connection.commit();
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, "ONEKTUP");
        preparedStatement.setInt(3, 0);
        preparedStatement.executeUpdate();
        connection.commit();
    }

    protected static InputStream openTestResource(final URL uRL) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws IOException {
                return uRL.openStream();
            }
        });
    }

    protected static URL getTestResource(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return this.getClass().getClassLoader().getResource(string);
            }
        });
    }
}

