/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.derbyTesting.functionTests.tests.management.JMXConnectionGetter;

class RemoteConnectionGetter
implements JMXConnectionGetter {
    static final ThreadLocal<Map<MBeanServerConnection, JMXConnector>> connections = new ThreadLocal();
    private final JMXServiceURL url;

    RemoteConnectionGetter(JMXServiceURL jMXServiceURL) {
        this.url = jMXServiceURL;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(String string, String string2) throws Exception {
        String[] stringArray;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        if (string != null) {
            stringArray = new String[]{string, string2};
            hashMap.put("jmx.remote.credentials", stringArray);
        }
        stringArray = JMXConnectorFactory.connect(this.url, hashMap);
        MBeanServerConnection mBeanServerConnection = stringArray.getMBeanServerConnection();
        Map<MBeanServerConnection, JMXConnector> map = connections.get();
        if (map == null) {
            map = new HashMap<MBeanServerConnection, JMXConnector>();
            connections.set(map);
        }
        map.put(mBeanServerConnection, (JMXConnector)stringArray);
        return mBeanServerConnection;
    }

    @Override
    public void close(MBeanServerConnection mBeanServerConnection) throws Exception {
        Map<MBeanServerConnection, JMXConnector> map = connections.get();
        JMXConnector jMXConnector = map.remove(mBeanServerConnection);
        jMXConnector.close();
    }
}

