/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun_Local_3;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_3_p3
extends ReplicationRun_Local_3 {
    static final String CANNOT_CONNECT_TO_DB_IN_SLAVE_MODE = "08004";
    static final String REPLICATION_NOT_IN_MASTER_MODE = "XRE07";
    static final int MAX_TRIES = 20;

    public ReplicationRun_Local_3_p3(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_3_p3 Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_3_p3.class);
        return SecurityManagerSetup.noSecurityManager((Test)baseTestSuite);
    }

    public void testReplication_Local_3_p3_StateNegativeTests() throws Exception {
        Object object;
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        replicationTest = null;
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this.assertException(this._stopMaster(masterServerHost, masterServerPort, masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb), null);
        this.waitForConnect(100L, 10, masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb, masterServerHost, masterServerPort);
        SQLException sQLException = null;
        int n = 20;
        while (n-- > 0) {
            sQLException = null;
            try {
                ClientDataSourceInterface clientDataSourceInterface;
                object = slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb;
                if (JDBC.vmSupportsJNDI()) {
                    Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
                    clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
                    clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                clientDataSourceInterface.setDatabaseName((String)object);
                clientDataSourceInterface.setServerName(slaveServerHost);
                clientDataSourceInterface.setPortNumber(slaveServerPort);
                clientDataSourceInterface.getConnection().close();
                this.util.DEBUG("Successfully connected after shutdown: " + (String)object);
                break;
            }
            catch (SQLException sQLException2) {
                if (sQLException2.getSQLState().equals(CANNOT_CONNECT_TO_DB_IN_SLAVE_MODE)) {
                    sQLException = sQLException2;
                    this.util.DEBUG("got SLAVE_OPERATION_DENIED_WHILE_CONNECTED, sleep");
                    Thread.sleep(1000L);
                    continue;
                }
                sQLException = sQLException2;
                break;
            }
        }
        if (sQLException != null) {
            object = sQLException.getSQLState().equals(CANNOT_CONNECT_TO_DB_IN_SLAVE_MODE) ? "Tried 20 times..." : "Unexpected SQL state: " + sQLException.getSQLState();
            this.util.DEBUG((String)object);
            throw sQLException;
        }
        this.assertException(this._failOver(masterServerHost, masterServerPort, masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb), REPLICATION_NOT_IN_MASTER_MODE);
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }
}

