/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.OldVersions;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.ClassLoaderTestSetup;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCClientSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpgradeTrajectoryTest
extends BaseJDBCTestCase {
    public static final String ALL_TRAJECTORIES_PROPERTY = "derbyTesting.allTrajectories";
    public static Version VERSION_10_0_2_1 = new Version(10, 0, 2, 1);
    public static Version VERSION_10_1_3_1 = new Version(10, 1, 3, 1);
    public static Version VERSION_10_2_2_0 = new Version(10, 2, 2, 0);
    public static Version VERSION_10_5_1_1 = new Version(10, 5, 1, 1);
    public static Version VERSION_10_6_0_0 = new Version(10, 6, 0, 0);
    public static Version.Trajectory TRAJECTORY_10_0_2_1_TO_10_1_3_1 = new Version.Trajectory(new Version[]{VERSION_10_0_2_1, VERSION_10_1_3_1});
    public static String BRANCH_10_0 = "10.0";
    public static String BRANCH_10_1 = "10.1";
    public static String BRANCH_10_2 = "10.2";
    public static String BRANCH_10_3 = "10.3";
    public static String BRANCH_10_4 = "10.4";
    public static String BRANCH_10_5 = "10.5";
    public static final String UPGRADED_DATABASE = "old_database";
    public static final String VIRGIN_DATABASE = "new_database";
    public static final String COMPARISON_DATABASE = "comparison_database";
    private static final String DUMMY_NUMBER = "123";
    private static final String DUMMY_STRING = "BLAHBLAH";
    private static final String DUMMY_TIMESTAMP = "123456";
    private static final String DERBY_4214_1 = "RETURNS VARCHAR(32672)";
    private static final String DERBY_4214_2 = "RETURNS VARCHAR(10890)";
    private static final String DERBY_4215 = "SYSCS_INPLACE_COMPRESS_TABLE";
    private static final boolean TRJ_IGNORE_SOFT_UPGRADE = true;
    private static final boolean TRJ_SAME_BRANCH_NEIGHBORS = false;
    private static final String SYSALIASES = "SYSALIASES";
    private static final String SYSCONGLOMERATES = "SYSCONGLOMERATES";
    private static final String SYSSTATEMENTS = "SYSSTATEMENTS";
    private static final String SYSROUTINEPERMS = "SYSROUTINEPERMS";
    private static final String CONGLOMERATENUMBER = "CONGLOMERATENUMBER";
    private static final String ALIAS = "ALIAS";
    private static final String ALIASID = "ALIASID";
    private static final String SPECIFICNAME = "SPECIFICNAME";
    private static final String STMTID = "STMTID";
    private static final String STMTNAME = "STMTNAME";
    private static final String TEXT = "TEXT";
    private static final String ROUTINEPERMSID = "ROUTINEPERMSID";
    private static final String LASTCOMPILED = "LASTCOMPILED";
    private static final boolean LOQUACIOUS = false;
    private Version.Trajectory _trajectory;
    private String _trajectoryName;
    private boolean[] _hardUpgradeRequests;
    private HashMap<String, String> _unstableColumnValues = new HashMap();
    private static ThreadLocal<ClassLoader> _originalClassLoader = new ThreadLocal();
    private static String[] INITIAL_TABLES = new String[]{"SYSALIASES"};

    public UpgradeTrajectoryTest(Version.Trajectory trajectory, boolean[] blArray) {
        super("testTrajectory");
        this._trajectory = trajectory;
        this._hardUpgradeRequests = blArray;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade trajectory test");
        UpgradeTrajectoryTest.addTrajectories(baseTestSuite);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup((Test)baseTestSuite);
        return SecurityManagerSetup.noSecurityManager((Test)supportFilesSetup);
    }

    private static void addTrajectories(BaseTestSuite baseTestSuite) {
        Version.Trajectory[] trajectoryArray = UpgradeTrajectoryTest.makeTrajectories();
        int n = trajectoryArray.length;
        UpgradeTrajectoryTest.println("Found " + n + " trajectories.");
        for (int i = 0; i < n; ++i) {
            UpgradeTrajectoryTest.addHardUpgradeOnlyTrajectory(baseTestSuite, trajectoryArray[i]);
        }
    }

    private static Version.Trajectory[] makeTrajectories() {
        Version[] versionArray = UpgradeTrajectoryTest.getSupportedVersions();
        Version.Trajectory[] trajectoryArray = UpgradeTrajectoryTest.shouldBuildAllTrajectories() ? UpgradeTrajectoryTest.buildPowerSet(versionArray) : UpgradeTrajectoryTest.buildMinimalSet(versionArray);
        return trajectoryArray;
    }

    private static boolean shouldBuildAllTrajectories() {
        Boolean bl = Boolean.valueOf(UpgradeTrajectoryTest.getSystemProperty(ALL_TRAJECTORIES_PROPERTY));
        return bl;
    }

    private static Version.Trajectory[] makeSampleTrajectories() {
        return new Version.Trajectory[]{new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 1, 3, 1)}), new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 3, 3, 0)}), new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 3, 3, 0), new Version(10, 5, 1, 1)}), new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 3, 3, 0), new Version(10, 6, 0, 0)}), new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 5, 1, 1)}), new Version.Trajectory(new Version[]{new Version(10, 4, 2, 1), new Version(10, 5, 1, 1)})};
    }

    private static Version[] getSupportedVersions() {
        int[][] nArray = OldVersions.getSupportedVersions();
        int n = nArray.length;
        Version[] versionArray = new Version[n];
        for (int i = 0; i < n; ++i) {
            versionArray[i] = new Version(nArray[i]);
        }
        return versionArray;
    }

    private static void addHardUpgradeOnlyTrajectory(BaseTestSuite baseTestSuite, Version.Trajectory trajectory) {
        int n = trajectory.getVersionCount();
        if (n < 2) {
            return;
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
        }
        UpgradeTrajectoryTest.addTrajectory(baseTestSuite, trajectory, blArray);
    }

    private static void addTrajectory(BaseTestSuite baseTestSuite, Version.Trajectory trajectory) {
        int n = trajectory.getVersionCount();
        if (n < 2) {
            return;
        }
        boolean[] blArray = new boolean[n];
        blArray[0] = true;
        UpgradeTrajectoryTest.addTrajectory(baseTestSuite, trajectory, blArray, 1);
    }

    private static void addTrajectory(BaseTestSuite baseTestSuite, Version.Trajectory trajectory, boolean[] blArray, int n) {
        if (n >= trajectory.getVersionCount()) {
            UpgradeTrajectoryTest.addTrajectory(baseTestSuite, trajectory, blArray);
        } else {
            boolean[] blArray2 = UpgradeTrajectoryTest.clone(blArray);
            boolean[] blArray3 = UpgradeTrajectoryTest.clone(blArray);
            blArray2[n] = true;
            UpgradeTrajectoryTest.addTrajectory(baseTestSuite, trajectory, blArray2, n + 1);
            blArray3[n] = false;
            UpgradeTrajectoryTest.addTrajectory(baseTestSuite, trajectory, blArray3, n + 1);
        }
    }

    private static boolean[] clone(boolean[] blArray) {
        int n = blArray.length;
        boolean[] blArray2 = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray2[i] = blArray[i];
        }
        return blArray2;
    }

    private static void addTrajectory(BaseTestSuite baseTestSuite, Version.Trajectory trajectory, boolean[] blArray) {
        UpgradeTrajectoryTest upgradeTrajectoryTest = new UpgradeTrajectoryTest(trajectory, blArray);
        TestSetup testSetup = TestConfiguration.additionalDatabaseDecorator((Test)upgradeTrajectoryTest, UPGRADED_DATABASE);
        testSetup = TestConfiguration.additionalDatabaseDecorator((Test)testSetup, VIRGIN_DATABASE);
        testSetup = TestConfiguration.additionalDatabaseDecorator((Test)testSetup, COMPARISON_DATABASE);
        Properties properties = new Properties();
        properties.setProperty("derby.database.allowPreReleaseUpgrade", "true");
        testSetup = new SystemPropertyTestSetup((Test)testSetup, properties);
        if (trajectory.getVersion(0).compareTo(VERSION_10_2_2_0) < 0) {
            testSetup = new JDBCClientSetup((Test)testSetup, JDBCClient.EMBEDDED_30);
        }
        baseTestSuite.addTest((Test)testSetup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTrajectory() throws Exception {
        this._trajectoryName = this._trajectory.toString() + " " + this.stringifyUpgradeRequests();
        UpgradeTrajectoryTest.println("Testing trajectory: " + this._trajectoryName);
        int n = this._trajectory.getVersionCount();
        UpgradeTrajectoryTest.assertTrue((String)this._trajectoryName, (n > 1 ? 1 : 0) != 0);
        this.saveOriginalClassLoader();
        try {
            Version version;
            Version version2 = version = this._trajectory.getVersion(0);
            this.createDatabase(version, UPGRADED_DATABASE);
            for (int i = 1; i < n; ++i) {
                Version version3 = this._trajectory.getVersion(i);
                boolean bl = this._hardUpgradeRequests[i];
                if (bl) {
                    version2 = version3;
                }
                this.upgradeDatabase(version3, version2, bl, UPGRADED_DATABASE);
            }
            this.createDatabase(version2, VIRGIN_DATABASE);
            this.compareDatabases(version2, UPGRADED_DATABASE, VIRGIN_DATABASE);
        }
        finally {
            this.restoreOriginalClassLoader();
            this.bootDatabase(UPGRADED_DATABASE);
            this.bootDatabase(VIRGIN_DATABASE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareDatabases(Version version, String string, String string2) throws Exception {
        ClassLoaderTestSetup.setThreadLoader(version.getClassLoader());
        DataSource dataSource = this.makeDataSource(string);
        DataSource dataSource2 = this.makeDataSource(string2);
        DataSource dataSource3 = this.bootDatabase(COMPARISON_DATABASE);
        Connection connection = dataSource.getConnection();
        Connection connection2 = dataSource2.getConnection();
        Connection connection3 = dataSource3.getConnection();
        try {
            this.goodStatement(connection3, "create schema " + string);
            this.goodStatement(connection3, "create schema " + string2);
            this.compareResults(connection, connection2, connection3, string, string2, "first_table", "select tablename from sys.systables where tabletype = 'S'");
            for (String string3 : INITIAL_TABLES) {
                this.compareResults(connection, connection2, connection3, string, string2, string3, "select * from sys." + string3);
            }
            ArrayList<String> arrayList = this.listSystemTables(connection3);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4 = arrayList.get(i);
                this.compareResults(connection, connection2, connection3, string, string2, string4, "select * from sys." + string4);
            }
        }
        finally {
            this.shutdownDatabase(dataSource);
            this.shutdownDatabase(dataSource2);
            this.shutdownDatabase(dataSource3);
        }
    }

    private ArrayList<String> listSystemTables(Connection connection) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select tablename from sys.systables where tabletype = 'S' and tablename != 'SYSDUMMY1'");
        int n = INITIAL_TABLES.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" and tablename != '");
            stringBuffer.append(INITIAL_TABLES[i]);
            stringBuffer.append("'");
        }
        stringBuffer.append(" order by tablename");
        PreparedStatement preparedStatement = this.chattyPrepare(connection, stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(1));
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareResults(Connection connection, Connection connection2, Connection connection3, String string, String string2, String string3, String string4) throws Exception {
        String string5 = string + "." + string3;
        String string6 = string2 + "." + string3;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        PreparedStatement preparedStatement = this.chattyPrepare(connection, string4);
        PreparedStatement preparedStatement2 = this.chattyPrepare(connection2, string4);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        Statement statement = null;
        Statement statement2 = null;
        try {
            String string7;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            ResultSetMetaData resultSetMetaData2 = resultSet2.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String string8 = null;
            UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (int)resultSetMetaData.getColumnCount(), (int)resultSetMetaData2.getColumnCount());
            stringBuffer.append("\n( ");
            stringBuffer2.append("\n( ");
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    stringBuffer.append(", ");
                    stringBuffer2.append(", ");
                }
                string7 = resultSetMetaData.getColumnName(i);
                if (i == 1) {
                    string8 = string7;
                }
                arrayList.add(string7);
                UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (String)resultSetMetaData.getColumnName(i), (String)resultSetMetaData2.getColumnName(i));
                UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (int)resultSetMetaData.getColumnType(i), (int)resultSetMetaData2.getColumnType(i));
                stringBuffer.append(string7);
                stringBuffer.append(" varchar( 10000 )");
                stringBuffer2.append("?");
            }
            stringBuffer.append("\n)");
            stringBuffer2.append("\n)");
            String string9 = stringBuffer.toString();
            string7 = stringBuffer2.toString();
            this.goodStatement(connection3, "create table " + string5 + string9);
            this.goodStatement(connection3, "create table " + string6 + string9);
            statement = this.chattyPrepare(connection3, "insert into " + string5 + " values " + string7);
            statement2 = this.chattyPrepare(connection3, "insert into " + string6 + " values " + string7);
            int n2 = this.stuffTable(string3, resultSet, (PreparedStatement)statement);
            int n3 = this.stuffTable(string3, resultSet2, (PreparedStatement)statement2);
            if (!this.suffersDERBY_4215(string3) && !this.suffersDERBY_4216(string3)) {
                UpgradeTrajectoryTest.assertEquals((String)(this._trajectoryName + ": " + string3), (int)n2, (int)n3);
            } else {
                UpgradeTrajectoryTest.assertTrue((String)(this._trajectoryName + ": " + string3), (n2 != n3 ? 1 : 0) != 0);
            }
            this.leftJoin(connection3, arrayList, string3, string5, string6);
            if (!this.suffersDERBY_4216(string3)) {
                this.leftJoin(connection3, arrayList, string3, string6, string5);
            }
        }
        finally {
            resultSet.close();
            resultSet2.close();
            preparedStatement.close();
            preparedStatement2.close();
            if (statement != null) {
                statement.close();
            }
            if (statement2 != null) {
                statement2.close();
            }
        }
    }

    private int stuffTable(String string, ResultSet resultSet, PreparedStatement preparedStatement) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 0;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = resultSetMetaData.getColumnName(i + 1);
        }
        String[] stringArray2 = new String[n];
        while (resultSet.next()) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                stringArray2[n3] = resultSet.getString(n3 + 1);
            }
            this.normalizeRow(string, stringArray, stringArray2);
            for (n3 = 0; n3 < n; ++n3) {
                preparedStatement.setString(n3 + 1, stringArray2[n3]);
            }
            preparedStatement.executeUpdate();
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leftJoin(Connection connection, ArrayList arrayList, String string, String string2, String string3) throws Exception {
        String string4;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string5 = (String)arrayList.get(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select *\nfrom ");
        stringBuffer.append(string2);
        stringBuffer.append(" l left join ");
        stringBuffer.append(string3);
        stringBuffer.append(" r\non ");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append("and ");
            }
            string4 = (String)arrayList.get(i);
            stringBuffer.append("( ( l.");
            stringBuffer.append(string4);
            stringBuffer.append(" = r.");
            stringBuffer.append(string4);
            stringBuffer.append(" ) or ( l.");
            stringBuffer.append(string4);
            stringBuffer.append(" is null and r.");
            stringBuffer.append(string4);
            stringBuffer.append(" is null ) )\n");
        }
        stringBuffer.append("where r.");
        stringBuffer.append(string5);
        stringBuffer.append(" is null");
        try {
            preparedStatement = this.chattyPrepare(connection, stringBuffer.toString());
            resultSet = preparedStatement.executeQuery();
            String string6 = "";
            string4 = this.filterKnownProblems(string, this.printResultSet(resultSet));
            UpgradeTrajectoryTest.assertEquals((String)(this._trajectoryName + ": " + string2 + " vs. " + string3), (String)string6, (String)string4);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private void createDatabase(Version version, String string) throws Exception {
        ClassLoaderTestSetup.setThreadLoader(version.getClassLoader());
        DataSource dataSource = this.bootDatabase(string);
        Connection connection = dataSource.getConnection();
        this.vetDBVersion(version, version, connection);
        this.shutdownDatabase(dataSource);
    }

    private void upgradeDatabase(Version version, Version version2, boolean bl, String string) throws Exception {
        ClassLoaderTestSetup.setThreadLoader(version.getClassLoader());
        DataSource dataSource = this.upgradeDatabase(string, bl);
        Connection connection = dataSource.getConnection();
        this.vetDBVersion(version, version2, connection);
        this.shutdownDatabase(dataSource);
    }

    private DataSource bootDatabase(String string) throws Exception {
        DataSource dataSource = this.makeDataSource(string);
        Method method = dataSource.getClass().getMethod("setCreateDatabase", String.class);
        method.invoke((Object)dataSource, "create");
        Connection connection = dataSource.getConnection();
        return dataSource;
    }

    private DataSource upgradeDatabase(String string, boolean bl) throws Exception {
        Object object;
        DataSource dataSource = this.makeDataSource(string);
        if (bl) {
            object = dataSource.getClass().getMethod("setConnectionAttributes", String.class);
            ((Method)object).invoke((Object)dataSource, "upgrade=true");
        }
        object = dataSource.getConnection();
        return dataSource;
    }

    private DataSource makeDataSource(String string) throws Exception {
        return JDBCDataSource.getDataSourceLogical(string);
    }

    private void shutdownDatabase(DataSource dataSource) {
        JDBCDataSource.shutdownDatabase(dataSource);
    }

    private void vetDBVersion(Version version, Version version2, Connection connection) throws Exception {
        String string = version.toString();
        String string2 = version2.getBranchID();
        String string3 = this.trimDriverVersion(connection.getMetaData().getDriverVersion());
        String string4 = this.getDataVersion(connection);
        UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (String)string, (String)string3);
        UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (String)string2, (String)string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDataVersion(Connection connection) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("values syscs_util.syscs_get_database_property('DataDictionaryVersion')");
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string = resultSet.getString(1);
            return string;
        }
        catch (SQLException sQLException) {
            UpgradeTrajectoryTest.printStackTrace(sQLException);
            String string = null;
            return string;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private String trimDriverVersion(String string) {
        int n = string.indexOf(32);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private void saveOriginalClassLoader() {
        if (_originalClassLoader.get() == null) {
            _originalClassLoader.set(ClassLoaderTestSetup.getThreadLoader());
        }
    }

    private void restoreOriginalClassLoader() {
        ClassLoaderTestSetup.setThreadLoader(_originalClassLoader.get());
    }

    private String stringifyUpgradeRequests() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._hardUpgradeRequests.length;
        stringBuffer.append("( ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (this._hardUpgradeRequests[i]) {
                stringBuffer.append("hard");
                continue;
            }
            stringBuffer.append("soft");
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    @Override
    protected void goodStatement(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    @Override
    protected PreparedStatement chattyPrepare(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private String printResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            return "Null ResultSet!";
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer();
        while (resultSet.next()) {
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    stringBuffer.append(" | ");
                }
                stringBuffer.append(resultSet.getString(i));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void normalizeRow(String string, String[] stringArray, String[] stringArray2) {
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = stringArray2[i];
            if (this.isColumn(SYSCONGLOMERATES, CONGLOMERATENUMBER, string, stringArray[i])) {
                string3 = DUMMY_NUMBER;
            } else if (this.isColumn(SYSALIASES, ALIASID, string, stringArray[i])) {
                string2 = string3;
                string3 = this.getColumnValue(ALIAS, stringArray, stringArray2);
                this._unstableColumnValues.put(string2, string3);
            } else if (this.isColumn(SYSALIASES, SPECIFICNAME, string, stringArray[i])) {
                string2 = string3;
                string3 = this.getColumnValue(ALIAS, stringArray, stringArray2);
                this._unstableColumnValues.put(string2, string3);
            } else if (this.isColumn(SYSSTATEMENTS, STMTID, string, stringArray[i])) {
                string2 = string3;
                string3 = this.getColumnValue(STMTNAME, stringArray, stringArray2);
                this._unstableColumnValues.put(string2, string3);
            } else if (this.isColumn(SYSSTATEMENTS, LASTCOMPILED, string, stringArray[i])) {
                string3 = DUMMY_TIMESTAMP;
            } else if (this.isColumn(SYSSTATEMENTS, TEXT, string, stringArray[i]) && this.suffersDERBY_4216(string)) {
                string3 = DUMMY_STRING;
            } else if (this.isColumn(SYSROUTINEPERMS, ALIASID, string, stringArray[i])) {
                string3 = this._unstableColumnValues.get(string3);
            } else if (this.isColumn(SYSROUTINEPERMS, ROUTINEPERMSID, string, stringArray[i])) {
                string3 = DUMMY_STRING;
            }
            stringArray2[i] = string3;
        }
    }

    private boolean isColumn(String string, String string2, String string3, String string4) {
        return string.equals(string3) && string2.equals(string4);
    }

    private String getColumnValue(String string, String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return stringArray2[i];
        }
        return null;
    }

    private boolean isUUID(String string) {
        return string != null && string.length() == 36 && string.charAt(8) == '-' && string.charAt(13) == '-' && string.charAt(18) == '-';
    }

    private void printQueryResults(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.close();
        preparedStatement.close();
    }

    private void compareQueries(Connection connection, Connection connection2, int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, string);
        PreparedStatement preparedStatement2 = this.chattyPrepare(connection2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        while (resultSet.next()) {
            resultSet2.next();
            for (int i = 1; i <= n; ++i) {
                String string2 = resultSet.getString(i);
                String string3 = resultSet2.getString(i);
                boolean bl = false;
                if (string2 == null) {
                    if (string3 != null) {
                        bl = true;
                    }
                } else if (!string2.equals(string3)) {
                    bl = true;
                }
                if (!bl) continue;
            }
        }
        resultSet.close();
        resultSet2.close();
        preparedStatement.close();
        preparedStatement2.close();
    }

    private static Version.Trajectory[] buildMinimalSet(Version[] versionArray) {
        int n;
        ArrayList<Version.Trajectory> arrayList = new ArrayList<Version.Trajectory>();
        int n2 = versionArray.length;
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = true;
        }
        UpgradeTrajectoryTest.addSubset(versionArray, arrayList, blArray, false);
        for (n = 0; n < n2 - 1; ++n) {
            blArray[n] = false;
            UpgradeTrajectoryTest.addSubset(versionArray, arrayList, blArray, false);
        }
        return UpgradeTrajectoryTest.squeezeArray(arrayList);
    }

    private static Version.Trajectory[] buildPowerSet(Version[] versionArray) {
        ArrayList<Version.Trajectory> arrayList = new ArrayList<Version.Trajectory>();
        int n = versionArray.length;
        boolean[] blArray = new boolean[n];
        UpgradeTrajectoryTest.buildPowerSetMinion(versionArray, arrayList, blArray, 0, false);
        return UpgradeTrajectoryTest.squeezeArray(arrayList);
    }

    private static Version.Trajectory[] squeezeArray(ArrayList<Version.Trajectory> arrayList) {
        Version.Trajectory[] trajectoryArray = new Version.Trajectory[arrayList.size()];
        arrayList.toArray(trajectoryArray);
        return trajectoryArray;
    }

    private static void buildPowerSetMinion(Version[] versionArray, ArrayList<Version.Trajectory> arrayList, boolean[] blArray, int n, boolean bl) {
        int n2 = versionArray.length;
        if (n >= n2) {
            UpgradeTrajectoryTest.addSubset(versionArray, arrayList, blArray, bl);
        } else {
            blArray[n] = true;
            UpgradeTrajectoryTest.buildPowerSetMinion(versionArray, arrayList, blArray, n + 1, bl);
            blArray[n] = false;
            UpgradeTrajectoryTest.buildPowerSetMinion(versionArray, arrayList, blArray, n + 1, bl);
        }
    }

    private static void addSubset(Version[] versionArray, ArrayList<Version.Trajectory> arrayList, boolean[] blArray, boolean bl) {
        Version[] versionArray2;
        int n;
        int n2 = versionArray.length;
        ArrayList<Version[]> arrayList2 = new ArrayList<Version[]>();
        Version[] versionArray3 = null;
        for (n = 0; n < n2; ++n) {
            versionArray2 = versionArray[n];
            if (!blArray[n] || bl && versionArray3 != null && versionArray3.getBranchID().equals(versionArray2.getBranchID())) continue;
            versionArray3 = versionArray2;
            arrayList2.add(versionArray2);
        }
        n = arrayList2.size();
        if (n > 1) {
            versionArray2 = new Version[n];
            arrayList2.toArray(versionArray2);
            arrayList.add(new Version.Trajectory(versionArray2).sort());
        }
    }

    private String filterKnownProblems(String string, String string2) {
        if (this._trajectory.endsAt(BRANCH_10_5) && (this.contains(string2, DERBY_4214_1) || this.contains(string2, DERBY_4214_2))) {
            return "";
        }
        if (this.suffersDERBY_4215(string) && this.contains(string2, DERBY_4215)) {
            return "";
        }
        return string2;
    }

    private boolean suffersDERBY_4215(String string) {
        return SYSROUTINEPERMS.equals(string) && this._trajectory.startsAt(BRANCH_10_0) && !this._trajectory.contains(BRANCH_10_1) && (this._trajectory.contains(BRANCH_10_2) || this._trajectory.contains(BRANCH_10_3) || this._trajectory.contains(BRANCH_10_4)) && this._trajectory.getEndingVersion().compareTo(VERSION_10_6_0_0) < 0;
    }

    private boolean suffersDERBY_4216(String string) {
        return SYSSTATEMENTS.equals(string) && this._trajectory.startsAt(BRANCH_10_0) && this._trajectory.endsAt(BRANCH_10_1);
    }

    private boolean contains(String string, String string2) {
        return string.indexOf(string2) >= 0;
    }
}

