/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.File;
import java.io.FileWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;

public class FTFileUtil {
    public static void mkFile(String string, int n) throws Exception {
        FileWriter fileWriter = new FileWriter(string);
        int n2 = 0;
        String string2 = "Amber!";
        for (int i = 0; i < n; ++i) {
            fileWriter.write(string2, n2, 1);
            if (++n2 < string2.length()) continue;
            n2 = 0;
        }
        fileWriter.close();
    }

    public static void renameFile(String string, String string2, String string3) throws Exception {
        final File file = new File(string, string2);
        final File file2 = new File(string, string3);
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                if (!file.renameTo(file2)) {
                    throw new Exception("unable to rename File: " + file.getAbsolutePath() + " To: " + file2.getAbsolutePath());
                }
                return null;
            }
        });
    }

    public static String fileExists(String string) {
        File file = new File(string);
        return Boolean.toString(PrivilegedFileOpsForTests.exists(file));
    }

    private static boolean removeDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!(file2.isDirectory() ? !FTFileUtil.removeDirectory(file2) : !file2.delete())) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static String removeDirectory(final String string) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FTFileUtil.removeDirectory(new File(string)) ? "true" : "false";
            }
        });
    }
}

