/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.lang;

import java.util.Properties;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;

public class T_Like
extends T_Generic {
    private static final String testService = "likeTest";
    boolean didFAIL;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.sql.execute.ExecutionFactory";
    }

    @Override
    protected void runTests() throws T_Fail {
        Object var1_1 = null;
        boolean bl = false;
        this.didFAIL = false;
        this.out.println("likeTest underway");
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.REPORT("(unitTestMain) Testing likeTest");
        try {
            this.tests();
        }
        catch (StandardException standardException) {
            this.FAIL("exception:" + standardException);
        }
        if (this.didFAIL) {
            throw T_Fail.testFailMsg("see log for details");
        }
        this.out.println("likeTest complete");
    }

    private void expect(String string, Boolean bl, Boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = bl == null && bl2 == null || bl != null && bl2 != null && bl.equals(bl2);
        if (bl3) {
            this.PASS("TEST [" + string + "] == result[" + bl2 + "] ");
        } else {
            this.FAIL("TEST [" + string + "] != result[" + bl2 + "] ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tests() throws StandardException {
        boolean bl = false;
        Boolean bl2 = null;
        char[] cArray = null;
        char[] cArray2 = "hello".toCharArray();
        String string = null;
        String string2 = null;
        this.REPORT("testing null combinations...");
        try {
            this.expect("null like null escape null", Like.like(cArray, (int)0, cArray, (int)0, cArray, (int)0, null), null);
            this.expect("null like 'hello' escape null", Like.like(cArray, (int)0, (char[])cArray2, (int)cArray2.length, cArray, (int)0, null), null);
            this.expect("'hello' like null escape null", Like.like((char[])cArray2, (int)cArray2.length, cArray, (int)0, cArray, (int)0, null), null);
            this.expect("null like null escape '\\'", Like.like(cArray, (int)0, cArray, (int)0, (char[])"\\".toCharArray(), (int)"\\".toCharArray().length, null), null);
            this.expect("null like null escape 'hello'", Like.like(cArray, (int)0, cArray, (int)0, (char[])cArray2, (int)cArray2.length, null), null);
            this.expect("null like 'hello\\' escape '\\'", Like.like(cArray, (int)0, (char[])"hello\\".toCharArray(), (int)"hello\\".toCharArray().length, (char[])"\\".toCharArray(), (int)"\\".toCharArray().length, null), null);
        }
        catch (StandardException standardException) {
            standardException.printStackTrace();
            this.FAIL("unexpected exception");
        }
        this.REPORT("testing valid match cases...");
        try {
            this.expect("'hello' like 'hello' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])cArray2, (int)cArray2.length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like 'h_llo' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])"h_llo".toCharArray(), (int)"h_llo".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like '_ello' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])"_ello".toCharArray(), (int)"_ello".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like 'hell_' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])"hell_".toCharArray(), (int)"hell_".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like '_____' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])"_____".toCharArray(), (int)"_____".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like 'h___e' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])"h___o".toCharArray(), (int)"h___o".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'h' like 'h' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"h".toCharArray(), (int)"h".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '_' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"_".toCharArray(), (int)"_".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '%' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"%".toCharArray(), (int)"%".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '_%' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"_%".toCharArray(), (int)"_%".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '%_' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"%_".toCharArray(), (int)"%_".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '%' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"%".toCharArray(), (int)"%".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'' like '%' escape null", Like.like((char[])"".toCharArray(), (int)"".toCharArray().length, (char[])"%".toCharArray(), (int)"%".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'' like '%%' escape null", Like.like((char[])"".toCharArray(), (int)"".toCharArray().length, (char[])"%%".toCharArray(), (int)"%%".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
            this.expect("'' like '%%%' escape null", Like.like((char[])"".toCharArray(), (int)"".toCharArray().length, (char[])"%%%".toCharArray(), (int)"%%%".toCharArray().length, cArray, (int)0, null), Boolean.TRUE);
        }
        catch (StandardException standardException) {
            standardException.printStackTrace();
            this.FAIL("unexpected exception");
        }
        this.REPORT("testing valid nonmatch cases...");
        try {
            this.expect("'hello' like 'hello ' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])"hello ".toCharArray(), (int)"hello ".toCharArray().length, cArray, (int)0, null), Boolean.FALSE);
            this.expect("'hello ' like 'hello' escape null", Like.like((char[])"hello ".toCharArray(), (int)"hello ".toCharArray().length, (char[])cArray2, (int)cArray2.length, cArray, (int)0, null), Boolean.FALSE);
            this.expect("'hello' like 'hellox' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])"hellox".toCharArray(), (int)"hellox".toCharArray().length, cArray, (int)0, null), Boolean.FALSE);
            this.expect("'hellox' like 'hello' escape null", Like.like((char[])"hellox".toCharArray(), (int)"hellox".toCharArray().length, (char[])cArray2, (int)cArray2.length, cArray, (int)0, null), Boolean.FALSE);
            this.expect("'xhellox' like 'hello' escape null", Like.like((char[])"xhellox".toCharArray(), (int)"xhellox".toCharArray().length, (char[])cArray2, (int)cArray2.length, cArray, (int)0, null), Boolean.FALSE);
            this.expect("'hello' like 'xhellox' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])"xhellox".toCharArray(), (int)"xhellox".toCharArray().length, null, (int)0, null), Boolean.FALSE);
            this.expect("'hello' like 'h___' escape null", Like.like((char[])cArray2, (int)cArray2.length, (char[])"h___".toCharArray(), (int)"h___".toCharArray().length, cArray, (int)0, null), Boolean.FALSE);
            this.expect("'h' like '_%_' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"_%_".toCharArray(), (int)"_%_".toCharArray().length, cArray, (int)0, null), Boolean.FALSE);
            this.expect("'' like '_' escape null", Like.like((char[])"".toCharArray(), (int)"".toCharArray().length, (char[])"_".toCharArray(), (int)"_".toCharArray().length, cArray, (int)0, null), Boolean.FALSE);
        }
        catch (StandardException standardException) {
            standardException.printStackTrace();
            this.FAIL("unexpected exception");
        }
        this.REPORT("testing error cases...");
        try {
            string = null;
            bl = false;
            string2 = "null like null escape 'hello'";
            bl2 = Like.like((char[])cArray2, (int)cArray2.length, (char[])cArray2, (int)cArray2.length, (char[])cArray2, (int)cArray2.length, null);
        }
        catch (StandardException standardException) {
            bl = true;
            string = standardException.getMessage();
        }
        finally {
            if (bl) {
                this.PASS("TEST [" + string2 + "] got exception " + string);
            } else {
                this.FAIL("TEST [" + string2 + "] didn't get exception");
            }
        }
        try {
            string = null;
            bl = false;
            string2 = "'hello' like 'hhh' escape 'h'";
            bl2 = Like.like((char[])cArray2, (int)cArray2.length, (char[])"hhh".toCharArray(), (int)"hhh".toCharArray().length, (char[])"h".toCharArray(), (int)"h".toCharArray().length, null);
        }
        catch (StandardException standardException) {
            bl = true;
            string = standardException.getMessage();
        }
        finally {
            if (bl) {
                this.PASS("TEST [" + string2 + "] got exception " + string);
            } else {
                this.FAIL("TEST [" + string2 + "] didn't get exception");
            }
        }
        try {
            string = null;
            bl = false;
            string2 = "'hello' like 'he%' escape 'h'";
            bl2 = Like.like((char[])cArray2, (int)cArray2.length, (char[])"he%".toCharArray(), (int)"he%".toCharArray().length, (char[])"h".toCharArray(), (int)"h".toCharArray().length, null);
        }
        catch (StandardException standardException) {
            bl = true;
            string = standardException.getMessage();
        }
        finally {
            if (bl) {
                this.PASS("TEST [" + string2 + "] got exception " + string);
            } else {
                this.FAIL("TEST [" + string2 + "] didn't get exception");
            }
        }
    }

    @Override
    protected boolean FAIL(String string) {
        super.FAIL(string);
        this.didFAIL = true;
        return true;
    }
}

