/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PreparedStatementTest42
extends BaseJDBCTestCase {
    private static final String UNIMPLEMENTED_FEATURE = "0A000";
    private static final JDBCType[] ILLEGAL_JDBC_TYPES = new JDBCType[]{JDBCType.ARRAY, JDBCType.DATALINK, JDBCType.DISTINCT, JDBCType.LONGNVARCHAR, JDBCType.NCHAR, JDBCType.NCLOB, JDBCType.NULL, JDBCType.NVARCHAR, JDBCType.OTHER, JDBCType.REF, JDBCType.REF_CURSOR, JDBCType.ROWID, JDBCType.SQLXML, JDBCType.STRUCT};
    private static final int[] ILLEGAL_SQL_TYPES = new int[]{2003, 70, 2001, -16, -15, 2011, -9, 1111, 2006, 2012, -8, 2009, 2002};
    private static ColumnDesc[] _columnDescs = new ColumnDesc[]{new ColumnDesc(JDBCType.BIGINT, "bigint", 0L, 1L, null), new ColumnDesc(JDBCType.BLOB, "blob", PreparedStatementTest42.makeBlob("01234"), PreparedStatementTest42.makeBlob("56789"), null), new ColumnDesc(JDBCType.BOOLEAN, "boolean", Boolean.FALSE, Boolean.TRUE, null), new ColumnDesc(JDBCType.CHAR, "char( 5 )", "01234", "56789", null), new ColumnDesc(JDBCType.BINARY, "char( 5 ) for bit data", PreparedStatementTest42.makeBinary("01234"), PreparedStatementTest42.makeBinary("56789"), null), new ColumnDesc(JDBCType.CLOB, "clob", PreparedStatementTest42.makeClob("01234"), PreparedStatementTest42.makeClob("56789"), null), new ColumnDesc(JDBCType.DATE, "date", new Date(0L), new Date(1L), null), new ColumnDesc(JDBCType.DECIMAL, "decimal", new BigDecimal(0), new BigDecimal(1), null), new ColumnDesc(JDBCType.DOUBLE, "double", 0.0, 1.0, null), new ColumnDesc(JDBCType.FLOAT, "float", 0.0, 1.0, null), new ColumnDesc(JDBCType.INTEGER, "int", 0, 1, null), new ColumnDesc(JDBCType.LONGVARCHAR, "long varchar", "01234", "56789", null), new ColumnDesc(JDBCType.LONGVARBINARY, "long varchar for bit data", PreparedStatementTest42.makeBinary("01234"), PreparedStatementTest42.makeBinary("56789"), null), new ColumnDesc(JDBCType.NUMERIC, "numeric", new BigDecimal(0), new BigDecimal(1), null), new ColumnDesc(JDBCType.REAL, "real", Float.valueOf(0.0f), Float.valueOf(1.0f), null), new ColumnDesc(JDBCType.SMALLINT, "smallint", 0, 1, null), new ColumnDesc(JDBCType.TIME, "time", new Time(0L), new Time(1L), null), new ColumnDesc(JDBCType.TIMESTAMP, "timestamp", new Timestamp(0L), new Timestamp(1L), null), new ColumnDesc(JDBCType.JAVA_OBJECT, "Price", PreparedStatementTest42.makePrice(0L), PreparedStatementTest42.makePrice(1L), null), new ColumnDesc(JDBCType.VARCHAR, "varchar( 5 )", "01234", "56789", null), new ColumnDesc(JDBCType.VARBINARY, "varchar( 5 ) for bit data", PreparedStatementTest42.makeBinary("01234"), PreparedStatementTest42.makeBinary("56789"), null)};

    public PreparedStatementTest42(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("PreparedStatementTest42");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(PreparedStatementTest42.class));
        return baseTestSuite;
    }

    public void test_01_setObject() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatementTest42.setupPrice(connection);
        this.makeTable(connection);
        this.populateTable(connection);
        this.vetTableContents(connection);
        this.updateColumns(connection);
    }

    private void makeTable(Connection connection) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create table allTypes\n(\n");
        stringBuilder.append("\tcol0\tint generated always as identity");
        for (int i = 0; i < _columnDescs.length; ++i) {
            ColumnDesc columnDesc = _columnDescs[i];
            String string = "col" + (i + 1);
            String string2 = columnDesc.sqlType;
            stringBuilder.append("\n\t, " + string + "\t" + string2);
        }
        stringBuilder.append("\n)");
        connection.prepareStatement(stringBuilder.toString()).execute();
    }

    private void populateTable(Connection connection) throws Exception {
        int n;
        PreparedStatement preparedStatement = this.prepareInsert(connection);
        for (n = 0; n < 3; ++n) {
            this.insertRow(preparedStatement, n);
        }
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < _columnDescs.length; ++i) {
                ColumnDesc columnDesc = _columnDescs[i];
                preparedStatement.setObject(i + 1, columnDesc.values[n], columnDesc.jdbcType, 0);
            }
            preparedStatement.executeUpdate();
        }
        for (n = 0; n < ILLEGAL_JDBC_TYPES.length; ++n) {
            try {
                preparedStatement.setObject(1, null, ILLEGAL_JDBC_TYPES[n]);
                PreparedStatementTest42.fail((String)"setObject() should have failed.");
                continue;
            }
            catch (SQLException sQLException) {
                PreparedStatementTest42.assertUnimplemented(sQLException);
            }
        }
        preparedStatement.close();
    }

    private static void assertUnimplemented(SQLException sQLException) throws Exception {
        PreparedStatementTest42.assertSQLState(UNIMPLEMENTED_FEATURE, sQLException);
        PreparedStatementTest42.assertTrue((boolean)(sQLException instanceof SQLFeatureNotSupportedException));
    }

    private PreparedStatement prepareInsert(Connection connection) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append("( ");
        stringBuilder2.append("( ");
        for (int i = 0; i < _columnDescs.length; ++i) {
            String string = "col" + (i + 1);
            if (i > 0) {
                stringBuilder.append(", ");
                stringBuilder2.append(", ");
            }
            stringBuilder.append(string);
            stringBuilder2.append("?");
        }
        stringBuilder.append(" )");
        stringBuilder2.append(" )");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into allTypes " + stringBuilder.toString() + " values " + stringBuilder2.toString());
        return preparedStatement;
    }

    private void insertRow(PreparedStatement preparedStatement, int n) throws Exception {
        for (int i = 0; i < _columnDescs.length; ++i) {
            ColumnDesc columnDesc = _columnDescs[i];
            preparedStatement.setObject(i + 1, columnDesc.values[n], columnDesc.jdbcType);
        }
        preparedStatement.executeUpdate();
    }

    private void vetTableContents(Connection connection) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select * from allTypes order by col0");
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        while (resultSet.next()) {
            int n2 = n % 3;
            for (int i = 0; i < _columnDescs.length; ++i) {
                Object object = PreparedStatementTest42._columnDescs[i].values[n2];
                PreparedStatementTest42.assertObjectEquals(object, resultSet.getObject(i + 2));
            }
            ++n;
        }
        resultSet.close();
        preparedStatement.close();
    }

    private void updateColumns(Connection connection) throws Exception {
        ColumnDesc columnDesc;
        int n;
        PreparedStatement preparedStatement = connection.prepareStatement("select * from allTypes for update", 1003, 1008);
        ResultSet resultSet = null;
        this.prepTable(connection, 0);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        for (n = 0; n < _columnDescs.length; ++n) {
            columnDesc = _columnDescs[n];
            resultSet.updateObject(n + 2, columnDesc.values[1], (SQLType)columnDesc.jdbcType);
        }
        resultSet.updateRow();
        resultSet.close();
        this.vetTable(connection, 1, 1);
        this.prepTable(connection, 0);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        for (n = 0; n < _columnDescs.length; ++n) {
            columnDesc = _columnDescs[n];
            resultSet.updateObject(n + 2, columnDesc.values[1], (SQLType)columnDesc.jdbcType, 0);
        }
        resultSet.updateRow();
        resultSet.close();
        this.vetTable(connection, 1, 1);
        this.prepTable(connection, 0);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        for (n = 0; n < _columnDescs.length; ++n) {
            columnDesc = _columnDescs[n];
            resultSet.updateObject("col" + (n + 1), columnDesc.values[1], (SQLType)columnDesc.jdbcType);
        }
        resultSet.updateRow();
        resultSet.close();
        this.vetTable(connection, 1, 1);
        this.prepTable(connection, 0);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        for (n = 0; n < _columnDescs.length; ++n) {
            columnDesc = _columnDescs[n];
            resultSet.updateObject("col" + (n + 1), columnDesc.values[1], (SQLType)columnDesc.jdbcType, 0);
        }
        resultSet.updateRow();
        resultSet.close();
        this.vetTable(connection, 1, 1);
        this.prepTable(connection, 0);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        PreparedStatementTest42.println("Testing ResultSet.updateObject() on illegal types.");
        for (n = 0; n < ILLEGAL_JDBC_TYPES.length; ++n) {
            try {
                resultSet.updateObject(2, PreparedStatementTest42._columnDescs[0].values[1], (SQLType)ILLEGAL_JDBC_TYPES[n]);
                PreparedStatementTest42.fail((String)"updateObject() should have failed.");
            }
            catch (SQLException sQLException) {
                PreparedStatementTest42.assertUnimplemented(sQLException);
            }
            try {
                resultSet.updateObject(2, PreparedStatementTest42._columnDescs[0].values[1], (SQLType)ILLEGAL_JDBC_TYPES[n], 0);
                PreparedStatementTest42.fail((String)"updateObject() should have failed.");
            }
            catch (SQLException sQLException) {
                PreparedStatementTest42.assertUnimplemented(sQLException);
            }
            try {
                resultSet.updateObject("col2", PreparedStatementTest42._columnDescs[0].values[1], (SQLType)ILLEGAL_JDBC_TYPES[n]);
                PreparedStatementTest42.fail((String)"updateObject() should have failed.");
            }
            catch (SQLException sQLException) {
                PreparedStatementTest42.assertUnimplemented(sQLException);
            }
            try {
                resultSet.updateObject("col2", PreparedStatementTest42._columnDescs[0].values[1], (SQLType)ILLEGAL_JDBC_TYPES[n], 0);
                PreparedStatementTest42.fail((String)"updateObject() should have failed.");
                continue;
            }
            catch (SQLException sQLException) {
                PreparedStatementTest42.assertUnimplemented(sQLException);
            }
        }
        resultSet.close();
        this.vetTable(connection, 0, 1);
    }

    private void prepTable(Connection connection, int n) throws Exception {
        connection.prepareStatement("truncate table allTypes").execute();
        PreparedStatement preparedStatement = this.prepareInsert(connection);
        this.insertRow(preparedStatement, n);
        this.vetTable(connection, n, 1);
    }

    private void vetTable(Connection connection, int n, int n2) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select * from allTypes order by col0");
        ResultSet resultSet = preparedStatement.executeQuery();
        int n3 = 0;
        while (resultSet.next()) {
            for (int i = 0; i < _columnDescs.length; ++i) {
                Object object = PreparedStatementTest42._columnDescs[i].values[n];
                PreparedStatementTest42.assertObjectEquals(object, resultSet.getObject(i + 2));
            }
            ++n3;
        }
        PreparedStatementTest42.assertEquals((int)n2, (int)n3);
        resultSet.close();
        preparedStatement.close();
    }

    public void test_02_registerObject() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatementTest42.registerObjectTest(connection);
    }

    public static void registerObjectTest(Connection connection) throws Exception {
        PreparedStatementTest42.createSchemaObjects(connection);
        PreparedStatementTest42.vetProc(connection);
    }

    private static void createSchemaObjects(Connection connection) throws Exception {
        PreparedStatementTest42.setupPrice(connection);
        PreparedStatementTest42.createProc(connection);
    }

    private static void createProc(Connection connection) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create procedure unpackAllTypes( in valueIdx int");
        for (int i = 0; i < _columnDescs.length; ++i) {
            ColumnDesc columnDesc = _columnDescs[i];
            String string = "param" + (i + 1);
            String string2 = columnDesc.sqlType;
            stringBuilder.append(", out " + string + " " + string2);
        }
        stringBuilder.append(" ) language java parameter style java no sql\n");
        stringBuilder.append("external name 'org.apache.derbyTesting.functionTests.tests.jdbc4.PreparedStatementTest42.unpackAllTypes'");
        String string = stringBuilder.toString();
        PreparedStatementTest42.println(string);
        connection.prepareStatement(string).execute();
    }

    private static void vetProc(Connection connection) throws Exception {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("call unpackAllTypes( ?");
        for (int i = 0; i < _columnDescs.length; ++i) {
            stringBuilder.append(", ?");
        }
        stringBuilder.append(" )");
        String string = stringBuilder.toString();
        PreparedStatementTest42.println(string);
        CallableStatement callableStatement = connection.prepareCall(string);
        int n2 = 0;
        int n3 = 1;
        callableStatement.setInt(n3++, n2);
        for (n = 0; n < _columnDescs.length; ++n) {
            callableStatement.registerOutParameter(n3++, (SQLType)PreparedStatementTest42._columnDescs[n].jdbcType);
        }
        callableStatement.execute();
        PreparedStatementTest42.vetCS(callableStatement, n2);
        n2 = 1;
        n3 = 1;
        callableStatement.setInt(n3++, n2);
        for (n = 0; n < _columnDescs.length; ++n) {
            callableStatement.registerOutParameter(n3++, (SQLType)PreparedStatementTest42._columnDescs[n].jdbcType, 0);
        }
        callableStatement.execute();
        PreparedStatementTest42.vetCS(callableStatement, n2);
        n2 = 0;
        n3 = 1;
        callableStatement.setInt(n3++, n2);
        for (n = 0; n < _columnDescs.length; ++n) {
            callableStatement.registerOutParameter(n3++, (SQLType)PreparedStatementTest42._columnDescs[n].jdbcType, "foo");
        }
        callableStatement.execute();
        PreparedStatementTest42.vetCS(callableStatement, n2);
        n2 = 1;
        n3 = 1;
        callableStatement.setInt(n3++, n2);
        for (n = 0; n < ILLEGAL_JDBC_TYPES.length; ++n) {
            try {
                callableStatement.registerOutParameter(n3++, (SQLType)ILLEGAL_JDBC_TYPES[n], 0);
                PreparedStatementTest42.fail();
                continue;
            }
            catch (SQLException sQLException) {
                PreparedStatementTest42.assertUnimplemented(sQLException);
            }
        }
        try {
            callableStatement.registerOutParameter("param1", (SQLType)PreparedStatementTest42._columnDescs[0].jdbcType);
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        try {
            callableStatement.registerOutParameter("param1", (SQLType)PreparedStatementTest42._columnDescs[0].jdbcType, 0);
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        try {
            callableStatement.registerOutParameter("param1", (SQLType)PreparedStatementTest42._columnDescs[0].jdbcType, "foo");
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        n2 = 1;
        n3 = 1;
        callableStatement.setInt(n3++, n2);
        for (int i = 0; i < ILLEGAL_SQL_TYPES.length; ++i) {
            int n4 = ILLEGAL_SQL_TYPES[i];
            try {
                callableStatement.registerOutParameter(n3++, n4, 0);
                PreparedStatementTest42.fail((String)("Should not have been able to register parameter type " + n4));
                continue;
            }
            catch (SQLException sQLException) {
                PreparedStatementTest42.assertUnimplemented(sQLException);
            }
        }
    }

    private static void vetCS(CallableStatement callableStatement, int n) throws Exception {
        int n2 = 0;
        int n3 = 2;
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n2++].values[n], callableStatement.getObject(n3++));
    }

    public void test_03_setObject() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatementTest42.callableStatementSetObjectTest(connection);
    }

    public static void callableStatementSetObjectTest(Connection connection) throws Exception {
        PreparedStatementTest42.createSetObjectSchemaObjects(connection);
        PreparedStatementTest42.vetSetObjectProc(connection);
    }

    private static void createSetObjectSchemaObjects(Connection connection) throws Exception {
        PreparedStatementTest42.setupPrice(connection);
        PreparedStatementTest42.createSetObjectProc(connection);
    }

    private static void createSetObjectProc(Connection connection) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create procedure packAllTypes( in valueIdx int");
        for (int i = 0; i < _columnDescs.length; ++i) {
            ColumnDesc columnDesc = _columnDescs[i];
            String string = "param" + (i + 1);
            String string2 = columnDesc.sqlType;
            stringBuilder.append(", in " + string + " " + string2);
        }
        stringBuilder.append(" ) language java parameter style java no sql\n");
        stringBuilder.append("external name 'org.apache.derbyTesting.functionTests.tests.jdbc4.PreparedStatementTest42.packAllTypes'");
        String string = stringBuilder.toString();
        PreparedStatementTest42.println(string);
        connection.prepareStatement(string).execute();
    }

    private static void vetSetObjectProc(Connection connection) throws Exception {
        ColumnDesc columnDesc;
        ColumnDesc columnDesc2;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("call packAllTypes( ?");
        for (int i = 0; i < _columnDescs.length; ++i) {
            stringBuilder.append(", ?");
        }
        stringBuilder.append(" )");
        String string = stringBuilder.toString();
        PreparedStatementTest42.println(string);
        CallableStatement callableStatement = connection.prepareCall(string);
        int n2 = 0;
        int n3 = 1;
        callableStatement.setInt(n3++, n2);
        for (n = 0; n < _columnDescs.length; ++n) {
            columnDesc2 = _columnDescs[n];
            callableStatement.setObject(n3++, columnDesc2.values[n2], (SQLType)columnDesc2.jdbcType);
        }
        callableStatement.execute();
        n2 = 1;
        n3 = 1;
        callableStatement.setInt(n3++, n2);
        for (n = 0; n < _columnDescs.length; ++n) {
            columnDesc2 = _columnDescs[n];
            callableStatement.setObject(n3++, columnDesc2.values[n2], (SQLType)columnDesc2.jdbcType, 0);
        }
        callableStatement.execute();
        try {
            columnDesc = _columnDescs[0];
            callableStatement.setObject("param1", columnDesc.values[0], (SQLType)columnDesc.jdbcType);
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        try {
            columnDesc = _columnDescs[0];
            callableStatement.setObject("param1", columnDesc.values[0], (SQLType)columnDesc.jdbcType, 0);
            PreparedStatementTest42.fail((String)"Expected unimplemented feature.");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
    }

    public void test_04_targetTypeIsNull() throws Exception {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("values cast(? as int)");
        try {
            preparedStatement.setObject(1, (Object)1, null);
            PreparedStatementTest42.fail((String)"setObject should fail when type is null");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        try {
            preparedStatement.setObject(1, (Object)1, null, 1);
            PreparedStatementTest42.fail((String)"setObject should fail when type is null");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        Statement statement = this.createStatement(1003, 1008);
        statement.execute("create table t(x int)");
        statement.execute("insert into t values 1");
        ResultSet resultSet = statement.executeQuery("select * from t");
        PreparedStatementTest42.assertTrue((boolean)resultSet.next());
        try {
            resultSet.updateObject("x", (Object)1, null);
            PreparedStatementTest42.fail((String)"updateObject should fail when type is null");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        try {
            resultSet.updateObject(1, (Object)1, null);
            PreparedStatementTest42.fail((String)"updateObject should fail when type is null");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        try {
            resultSet.updateObject("x", (Object)1, null, 1);
            PreparedStatementTest42.fail((String)"updateObject should fail when type is null");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        try {
            resultSet.updateObject(1, (Object)1, null, 1);
            PreparedStatementTest42.fail((String)"updateObject should fail when type is null");
        }
        catch (SQLException sQLException) {
            PreparedStatementTest42.assertUnimplemented(sQLException);
        }
        JDBC.assertEmpty(resultSet);
    }

    public static void unpackAllTypes(int n, Long[] longArray, Blob[] blobArray, Boolean[] booleanArray, String[] stringArray, byte[][] byArray, Clob[] clobArray, Date[] dateArray, BigDecimal[] bigDecimalArray, Double[] doubleArray, Double[] doubleArray2, Integer[] integerArray, String[] stringArray2, byte[][] byArray2, BigDecimal[] bigDecimalArray2, Float[] floatArray, Integer[] integerArray2, Time[] timeArray, Timestamp[] timestampArray, Price[] priceArray, String[] stringArray3, byte[][] byArray3) {
        int n2 = 0;
        longArray[0] = (Long)PreparedStatementTest42._columnDescs[n2++].values[n];
        blobArray[0] = (Blob)PreparedStatementTest42._columnDescs[n2++].values[n];
        booleanArray[0] = (Boolean)PreparedStatementTest42._columnDescs[n2++].values[n];
        stringArray[0] = (String)PreparedStatementTest42._columnDescs[n2++].values[n];
        byArray[0] = (byte[])PreparedStatementTest42._columnDescs[n2++].values[n];
        clobArray[0] = (Clob)PreparedStatementTest42._columnDescs[n2++].values[n];
        dateArray[0] = (Date)PreparedStatementTest42._columnDescs[n2++].values[n];
        bigDecimalArray[0] = (BigDecimal)PreparedStatementTest42._columnDescs[n2++].values[n];
        doubleArray[0] = (Double)PreparedStatementTest42._columnDescs[n2++].values[n];
        doubleArray2[0] = (Double)PreparedStatementTest42._columnDescs[n2++].values[n];
        integerArray[0] = (Integer)PreparedStatementTest42._columnDescs[n2++].values[n];
        stringArray2[0] = (String)PreparedStatementTest42._columnDescs[n2++].values[n];
        byArray2[0] = (byte[])PreparedStatementTest42._columnDescs[n2++].values[n];
        bigDecimalArray2[0] = (BigDecimal)PreparedStatementTest42._columnDescs[n2++].values[n];
        floatArray[0] = (Float)PreparedStatementTest42._columnDescs[n2++].values[n];
        integerArray2[0] = (Integer)PreparedStatementTest42._columnDescs[n2++].values[n];
        timeArray[0] = (Time)PreparedStatementTest42._columnDescs[n2++].values[n];
        timestampArray[0] = (Timestamp)PreparedStatementTest42._columnDescs[n2++].values[n];
        priceArray[0] = (Price)PreparedStatementTest42._columnDescs[n2++].values[n];
        stringArray3[0] = (String)PreparedStatementTest42._columnDescs[n2++].values[n];
        byArray3[0] = (byte[])PreparedStatementTest42._columnDescs[n2++].values[n];
    }

    public static void packAllTypes(int n, Long l, Blob blob, Boolean bl, String string, byte[] byArray, Clob clob, Date date, BigDecimal bigDecimal, Double d, Double d2, Integer n2, String string2, byte[] byArray2, BigDecimal bigDecimal2, Float f, Integer n3, Time time, Timestamp timestamp, Price price, String string3, byte[] byArray3) throws Exception {
        int n4 = 0;
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], l);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], blob);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], bl);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], string);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], byArray);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], clob);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], date);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], bigDecimal);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], d);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], d2);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], n2);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], string2);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], byArray2);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], bigDecimal2);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], f);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], n3);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], time);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], timestamp);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], price);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], string3);
        PreparedStatementTest42.assertObjectEquals(PreparedStatementTest42._columnDescs[n4++].values[n], byArray3);
    }

    private static void setupPrice(Connection connection) throws Exception {
        if (!PreparedStatementTest42.aliasExists(connection, "PRICE")) {
            connection.prepareStatement("create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java").execute();
        }
    }

    private static boolean aliasExists(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from sys.sysaliases where alias = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        preparedStatement.close();
        return n > 0;
    }

    private static Blob makeBlob(String string) {
        return new HarmonySerialBlob(PreparedStatementTest42.makeBinary(string));
    }

    private static Clob makeClob(String string) {
        return new HarmonySerialClob(string);
    }

    private static byte[] makeBinary(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Price makePrice(long l) {
        return Price.makePrice(new BigDecimal(l));
    }

    public static void assertObjectEquals(Object object, Object object2) throws Exception {
        if (object == null) {
            PreparedStatementTest42.assertNull((Object)object2);
            return;
        }
        if (object2 == null) {
            PreparedStatementTest42.assertNull((Object)object);
            return;
        }
        if (object instanceof Blob) {
            PreparedStatementTest42.assertEquals((Blob)object, (Blob)object2);
        } else if (object instanceof Clob) {
            PreparedStatementTest42.assertEquals((Clob)object, (Clob)object2);
        } else if (object instanceof byte[]) {
            PreparedStatementTest42.compareBytes((byte[])object, (byte[])object2);
        } else {
            PreparedStatementTest42.assertEquals((String)object.toString(), (String)object2.toString());
        }
    }

    private static void compareBytes(byte[] byArray, byte[] byArray2) throws Exception {
        int n = byArray.length;
        if (n != byArray2.length) {
            PreparedStatementTest42.fail((String)("left count = " + n + " but right count = " + byArray2.length));
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            PreparedStatementTest42.fail((String)("left[ " + i + " ] = " + byArray[i] + " but right[ " + i + " ] = " + byArray2[i]));
        }
    }

    public static final class ColumnDesc {
        public static final int VALUE_COUNT = 3;
        public final JDBCType jdbcType;
        public final String sqlType;
        public final Object[] values;

        public ColumnDesc(JDBCType jDBCType, String string, Object ... objectArray) {
            this.jdbcType = jDBCType;
            this.sqlType = string;
            this.values = objectArray;
            if (objectArray.length != 3) {
                throw new IllegalArgumentException("Expected 3 values but saw " + objectArray.length);
            }
        }
    }
}

