/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobStoredProcedureTest
extends BaseJDBCTestCase {
    final String testStr = "I am a simple derby test case";
    final long testStrLength = "I am a simple derby test case".length();

    public ClobStoredProcedureTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty: client not supported on JSR169; procs use DriverMgr");
        }
        return TestConfiguration.defaultSuite(ClobStoredProcedureTest.class);
    }

    public void setUp() throws Exception {
        int n = 0;
        this.getConnection().setAutoCommit(false);
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBCREATELOCATOR()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.executeUpdate();
        n = callableStatement.getInt(1);
        callableStatement.close();
        callableStatement = this.prepareCall("CALL SYSIBM.CLOBSETSTRING(?,?,?,?)");
        callableStatement.setInt(1, n);
        callableStatement.setInt(2, 1);
        callableStatement.setLong(3, this.testStrLength);
        callableStatement.setString(4, "I am a simple derby test case");
        callableStatement.execute();
        callableStatement.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.commit();
        super.tearDown();
    }

    public void testGetSubStringSP() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBGETSUBSTRING(?,?,?)");
        callableStatement.registerOutParameter(1, 12);
        callableStatement.setInt(2, 1);
        callableStatement.setLong(3, 1L);
        callableStatement.setInt(4, 10);
        callableStatement.executeUpdate();
        String string = callableStatement.getString(1);
        if ("I am a simple derby test case".substring(0, 10).compareTo(string) != 0) {
            ClobStoredProcedureTest.fail((String)"Error SYSIBM.CLOBGETSUBSTRING returns the wrong string");
        }
        callableStatement.close();
    }

    public void testClobCreateLocatorSP() throws SQLException {
        int n = -1;
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBCREATELOCATOR()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.executeUpdate();
        n = callableStatement.getInt(1);
        ClobStoredProcedureTest.assertEquals((String)"The locator values returned by SYSIBM.CLOBCREATELOCATOR() are incorrect", (int)2, (int)n);
        callableStatement.close();
    }

    public void testClobReleaseLocatorSP() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.CLOBRELEASELOCATOR(?)");
        callableStatement.setInt(1, 1);
        callableStatement.execute();
        callableStatement.close();
        callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBGETLENGTH(?)");
        callableStatement.registerOutParameter(1, -5);
        callableStatement.setInt(2, 1);
        try {
            callableStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            return;
        }
        ClobStoredProcedureTest.fail((String)"Error the locator was not released by SYSIBM.CLOBRELEASELOCATOR");
        callableStatement.close();
    }

    public void testClobGetLengthSP() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBGETLENGTH(?)");
        callableStatement.registerOutParameter(1, -5);
        callableStatement.setInt(2, 1);
        callableStatement.executeUpdate();
        ClobStoredProcedureTest.assertEquals((String)"Error SYSIBM.CLOBGETLENGTH returns the wrong value for the length of the Clob", (long)this.testStrLength, (long)callableStatement.getLong(1));
        callableStatement.close();
    }

    public void testClobGetPositionFromStringSP() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBGETPOSITIONFROMSTRING(?,?,?)");
        callableStatement.registerOutParameter(1, -5);
        callableStatement.setInt(2, 1);
        callableStatement.setString(3, new String("simple"));
        callableStatement.setLong(4, 1L);
        callableStatement.executeUpdate();
        ClobStoredProcedureTest.assertEquals((String)"Error SYSIBM.CLOBGETPOSITIONFROMSTRING returns the wrong value for the position of the SUBSTRING", (long)("I am a simple derby test case".indexOf("simple") + 1), (long)callableStatement.getLong(1));
        callableStatement.close();
    }

    public void testClobSetStringSP() throws SQLException {
        String string = "123456789012345";
        int n = -1;
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBCREATELOCATOR()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.executeUpdate();
        n = callableStatement.getInt(1);
        callableStatement.close();
        callableStatement = this.prepareCall("CALL SYSIBM.CLOBSETSTRING(?,?,?,?)");
        callableStatement.setInt(1, n);
        callableStatement.setInt(2, 1);
        callableStatement.setLong(3, (long)string.length());
        callableStatement.setString(4, string);
        callableStatement.execute();
        callableStatement.close();
        callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBGETSUBSTRING(?,?,?)");
        callableStatement.registerOutParameter(1, 12);
        callableStatement.setInt(2, n);
        callableStatement.setLong(3, 1L);
        callableStatement.setInt(4, string.length());
        callableStatement.executeUpdate();
        String string2 = callableStatement.getString(1);
        if (string.compareTo(string2) != 0) {
            ClobStoredProcedureTest.fail((String)"SYSIBM.CLOBSETSTRING does not insert the right value");
        }
        callableStatement.close();
    }

    public void testClobTruncateSP() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.CLOBTRUNCATE(?,?)");
        callableStatement.setInt(1, 1);
        callableStatement.setLong(2, 10L);
        try {
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        callableStatement.close();
    }

    public void testClobGetPositionFromLocatorSP() throws SQLException {
        int n = 0;
        String string = "simple";
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBCREATELOCATOR()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.executeUpdate();
        n = callableStatement.getInt(1);
        callableStatement.close();
        callableStatement = this.prepareCall("CALL SYSIBM.CLOBSETSTRING(?,?,?,?)");
        callableStatement.setInt(1, n);
        callableStatement.setInt(2, 1);
        callableStatement.setLong(3, (long)string.length());
        callableStatement.setString(4, string);
        callableStatement.execute();
        callableStatement.close();
        callableStatement = this.prepareCall("? = CALL SYSIBM.CLOBGETPOSITIONFROMLOCATOR(?,?,?)");
        callableStatement.registerOutParameter(1, -5);
        callableStatement.setInt(2, 1);
        callableStatement.setInt(3, n);
        callableStatement.setLong(4, 1L);
        callableStatement.executeUpdate();
        ClobStoredProcedureTest.assertEquals((String)"Error SYSIBM.CLOBGETPOSITIONFROMLOCATOR returns the wrong value for the position of the Clob", (long)8L, (long)callableStatement.getLong(1));
        callableStatement.close();
    }
}

