/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class URCoveringIndexTest
extends BaseJDBCTestCase {
    public static Test suite() {
        return TestConfiguration.defaultSuite(URCoveringIndexTest.class);
    }

    public URCoveringIndexTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        String string = "CREATE TABLE tableWithPK (c1 int primary key,c2 int)";
        String string2 = "INSERT INTO tableWithPK values (1, 1)";
        Statement statement = connection.createStatement();
        statement.execute(string);
        statement.execute(string2);
        statement.close();
    }

    private void testUpdateUpdatedTupleWithCoveringIndex(boolean bl, boolean bl2) throws SQLException {
        SQLWarning sQLWarning = null;
        int n = bl ? 1004 : 1003;
        Connection connection = this.getConnection();
        if (!connection.getMetaData().supportsResultSetConcurrency(n, 1008)) {
            return;
        }
        Statement statement = connection.createStatement(n, 1008);
        Statement statement2 = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT c1 FROM tableWithPK");
        resultSet.next();
        int n2 = resultSet.getInt(1);
        statement2.executeUpdate("UPDATE tableWithPK SET c1 = " + (n2 + 10) + "WHERE c1 = " + resultSet.getInt(1));
        resultSet.clearWarnings();
        if (bl2) {
            statement2.executeUpdate("UPDATE tableWithPK set c1 = " + (n2 + 20) + "WHERE CURRENT OF " + resultSet.getCursorName());
            sQLWarning = statement2.getWarnings();
        } else {
            resultSet.updateInt(1, n2 + 20);
            resultSet.updateRow();
            sQLWarning = resultSet.getWarnings();
        }
        JDBC.assertNoWarnings(sQLWarning);
        resultSet.close();
        resultSet = statement2.executeQuery("SELECT c1 FROM tableWithPK");
        resultSet.next();
        URCoveringIndexTest.assertEquals((String)("Expecting c1 to be " + n2 + " + 20"), (int)resultSet.getInt(1), (int)(n2 + 20));
        resultSet.close();
        statement2.close();
        statement.close();
    }

    public void testUpdateUpdatedTupleScrollPostitioned() throws SQLException {
        this.testUpdateUpdatedTupleWithCoveringIndex(true, true);
    }

    public void testUpdateUpdatedTupleScrollUpdateRow() throws SQLException {
        this.testUpdateUpdatedTupleWithCoveringIndex(true, false);
    }

    public void testUpdateUpdatedTupleFOPositioned() throws SQLException {
        this.testUpdateUpdatedTupleWithCoveringIndex(false, true);
    }

    public void testUpdateUpdatedTupleFOUpdateRow() throws SQLException {
        this.testUpdateUpdatedTupleWithCoveringIndex(false, false);
    }
}

