/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class CommentTest
extends BaseJDBCTestCase {
    public CommentTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(CommentTest.class);
    }

    public void testBracketedComments() throws Exception {
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("/* a comment */ VALUES 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("-- eof comment\nVALUES 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES 1 /* a comment */"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES /* a comment */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES /* a comment \n with newline */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES /* SELECT * from FOO */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES /* a comment /* nested comment */ */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES /*/* XXX /*/*/* deeply nested comment */*/*/YYY*/*/ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES 1 --/*/* XXX /*/*/* deeply nested comment */*/*/YYY*/*/ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES 1 --/*/* XXX /*/*/* deeply nested comment */*/*/YYY*/*/ 1--/*"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES /* a comment --\n with newline */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES /* a comment -- */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES /* a comment \n-- */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("VALUES '/* a comment \n-- */'"), new String[][]{{"/* a comment \n-- */"}});
        this.assertCompileError("42X02", "VALUES 1 /*");
        this.assertCompileError("42X02", "VALUES 1 /* comment");
        this.assertCompileError("42X02", "VALUES 1 /* comment /*");
        this.assertCompileError("42X02", "VALUES 1 /* comment /* nested */");
        this.assertCompileError("42X01", "/* this is a comment */");
        this.assertCompileError("42X01", "/* this is a comment */ /* /* foo */ */");
        this.assertCompileError("42X01", "\n\r\r\n/* Weird newlines in front of a comment */ /* /* foo */ */");
        this.assertCompileError("42X01", "-- this is a comment \n");
        this.assertCompileError("42X02", "/* this is not quite a comment");
    }

    public void testInitialComment_derby4338() throws Exception {
        Statement statement = this.createStatement();
        JDBC.assertDrainResults(statement.executeQuery("/* comment */ select * from sys.systables"));
        JDBC.assertDrainResults(statement.executeQuery("/* */\nSELECT * from sys.systables"));
        JDBC.assertDrainResults(statement.executeQuery("/* --*/\n\rSELECT * from sys.systables"));
        JDBC.assertDrainResults(statement.executeQuery("--\nselect * from sys.systables"));
        statement.executeUpdate("/* /* foo*/ */ create table t (i int)");
        statement.executeUpdate("--\n drop table t");
        PreparedStatement preparedStatement = this.prepareStatement("{call syscs_util.syscs_set_database_property('foo', ?)}");
        preparedStatement.setString(1, "bar");
        preparedStatement.execute();
        if (CommentTest.usingEmbedded()) {
            Assert.assertTrue((preparedStatement.getUpdateCount() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((preparedStatement.getUpdateCount() == -1 ? 1 : 0) != 0);
        }
        preparedStatement = this.prepareStatement("--\n{call syscs_util.syscs_set_database_property('foo', ?)}");
        preparedStatement.setString(1, "bar");
        preparedStatement.execute();
        if (CommentTest.usingEmbedded()) {
            Assert.assertEquals((int)0, (int)preparedStatement.getUpdateCount());
        } else {
            Assert.assertEquals((int)-1, (int)preparedStatement.getUpdateCount());
        }
        preparedStatement.setNull(1, 12);
        preparedStatement.execute();
    }

    public void testWrongKeywordLexing_derby4338() throws Exception {
        Statement statement = this.createStatement();
        JDBC.assertDrainResults(statement.executeQuery("select* from sys.systables"));
        JDBC.assertDrainResults(statement.executeQuery("select'a' from sys.systables"));
        JDBC.assertDrainResults(statement.executeQuery("select\"TABLEID\" from sys.systables"));
        this.assertCompileError("42X01", "commit");
        this.assertCompileError("42X01", "commit;");
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }
}

