/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CompressTableTest
extends BaseJDBCTestCase {
    public CompressTableTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(CompressTableTest.class));
    }

    public void testCompressTableWithEmptyParamsDerby5750() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table DERBY5750_t1 (c11 int)");
        CompressTableTest.assertStatementError("42Y07", statement, "call syscs_util.syscs_compress_table('','DERBY5750_T1',1)");
        CompressTableTest.assertStatementError("42Y07", statement, "call syscs_util.syscs_compress_table('','',1)");
        statement.execute("call syscs_util.syscs_compress_table(null,'DERBY5750_T1',1)");
        CompressTableTest.assertStatementError("42X05", statement, "call syscs_util.syscs_compress_table(null,'',1)");
        CompressTableTest.assertStatementError("42X05", statement, "call syscs_util.syscs_compress_table('APP','',1)");
        CompressTableTest.assertStatementError("42X05", statement, "call syscs_util.syscs_compress_table(null,null,1)");
        CompressTableTest.assertStatementError("42X05", statement, "call syscs_util.syscs_compress_table('APP',null,1)");
        statement.execute("call syscs_util.syscs_compress_table('APP','DERBY5750_T1',1)");
        statement.execute("drop table DERBY5750_t1");
    }

    public void testCompressTableWithDoubleQuoteInName() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table app.\"abc\"\"def\" (x int)");
        statement.execute("call syscs_util.syscs_compress_table('APP','abc\"def',1)");
        statement.execute("call syscs_util.syscs_inplace_compress_table('APP','abc\"def', 1, 1, 1)");
        statement.execute("drop table app.\"abc\"\"def\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentInvalidation() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table d4275(x int)");
        statement.execute("insert into d4275 values 1");
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        final Throwable[] throwableArray = new Throwable[1];
        Connection connection = this.openDefaultConnection();
        final PreparedStatement preparedStatement = connection.prepareStatement("select * from d4275");
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (!atomicBoolean.get()) {
                        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
                    }
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                }
            }
        };
        thread.start();
        try {
            for (int i = 0; i < 100; ++i) {
                statement.execute("call syscs_util.syscs_compress_table('APP', 'D4275', 1)");
            }
        }
        finally {
            atomicBoolean.set(true);
        }
        thread.join();
        if (throwableArray[0] != null) {
            CompressTableTest.fail("Helper thread failed", throwableArray[0]);
        }
        preparedStatement.close();
        connection.close();
    }
}

