/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.shared.common.error.DerbySQLIntegrityConstraintViolationException;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ForeignKeysDeferrableTest
extends BaseJDBCTestCase {
    private static final String LANG_DEFERRED_DUPLICATE_KEY_CONSTRAINT_T = "23506";
    private static final String LANG_DEFERRED_FK_CONSTRAINT_T = "23516";
    private static final String LANG_DEFERRED_FK_CONSTRAINT_S = "23517";
    private static final String LANG_ADD_FK_CONSTRAINT_VIOLATION = "X0Y45";
    private static final String LANG_FK_VIOLATION = "23503";
    private static String expImpDataFile;
    private static boolean exportFilesCreatedEmbedded;
    private static boolean exportFilesCreatedClient;

    public ForeignKeysDeferrableTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTest((Test)new SupportFilesSetup(TestConfiguration.embeddedSuite(ForeignKeysDeferrableTest.class)));
        baseTestSuite.addTest((Test)new SupportFilesSetup(TestConfiguration.clientServerSuite(ForeignKeysDeferrableTest.class)));
        return baseTestSuite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Statement statement = this.createStatement();
        statement.executeUpdate("create table ref_d_r(i int primary key, j int default 2)");
        statement.executeUpdate("create table ref_d_c(i int primary key, j int default 2)");
        statement.executeUpdate("create table ref_d_na(i int primary key, j int default 2)");
        statement.executeUpdate("create table ref_d_nu(i int primary key, j int default 2)");
        statement.executeUpdate("create table ref_u_r(i int primary key, j int default 2)");
        statement.executeUpdate("create table ref_u_na(i int primary key, j int default 2)");
        statement.executeUpdate("insert into ref_d_r values (1, default)");
        statement.executeUpdate("insert into ref_d_c values (1, default)");
        statement.executeUpdate("insert into ref_d_na values (1, default)");
        statement.executeUpdate("insert into ref_d_nu values (1, default)");
        statement.executeUpdate("insert into ref_u_r values (1, default)");
        statement.executeUpdate("insert into ref_u_na values (1, default)");
        statement.executeUpdate("create table t_d_r(i int, j int default 2,   constraint c_d_r foreign key (i) references ref_d_r(i)    on delete restrict deferrable initially immediate)");
        statement.executeUpdate("create table t_d_c(i int, j int default 2,   constraint c_d_c foreign key (i) references ref_d_c(i)    on delete cascade deferrable initially immediate)");
        statement.executeUpdate("create table t_d_na(i int, j int default 2,   constraint c_d_na foreign key (i) references ref_d_na(i)    on delete no action deferrable initially immediate)");
        statement.executeUpdate("create table t_d_nu(i int, j int default 2,   constraint c_d_nu foreign key (i) references ref_d_nu(i)    on delete set null deferrable initially immediate)");
        statement.executeUpdate("create table t_u_r(i int, j int default 2,   constraint c_u_r foreign key (i) references ref_u_r(i)    on update restrict deferrable initially immediate)");
        statement.executeUpdate("create table t_u_na(i int, j int default 2,   constraint c_u_na foreign key (i) references ref_u_na(i)    on update no action deferrable initially immediate)");
        statement.executeUpdate("insert into t_d_r   values (1, default)");
        statement.executeUpdate("insert into t_d_c   values (1, default)");
        statement.executeUpdate("insert into t_d_na  values (1, default)");
        statement.executeUpdate("insert into t_d_nu  values (1, default)");
        statement.executeUpdate("insert into t_u_r   values (1, default)");
        statement.executeUpdate("insert into t_u_na  values (1, default)");
        if (ForeignKeysDeferrableTest.usingEmbedded() && !exportFilesCreatedEmbedded || ForeignKeysDeferrableTest.usingDerbyNetClient() && !exportFilesCreatedClient) {
            if (ForeignKeysDeferrableTest.usingEmbedded()) {
                exportFilesCreatedEmbedded = true;
            } else {
                exportFilesCreatedClient = true;
            }
            expImpDataFile = SupportFilesSetup.getReadWrite("t.data").getPath();
            statement.executeUpdate("create table t(i int, j int)");
            statement.executeUpdate("insert into t values (1,2),(2,2)");
            statement.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null)");
            statement.executeUpdate("drop table t");
        }
        this.setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        this.setAutoCommit(true);
        Statement statement = this.createStatement();
        this.dropTable("t_d_r");
        this.dropTable("t_d_c");
        this.dropTable("t_d_na");
        this.dropTable("t_d_nu");
        this.dropTable("t_u_r");
        this.dropTable("t_u_na");
        this.dropTable("ref_d_r");
        this.dropTable("ref_d_c");
        this.dropTable("ref_d_na");
        this.dropTable("ref_d_nu");
        this.dropTable("ref_u_r");
        this.dropTable("ref_u_na");
        super.tearDown();
    }

    public void testInsertDirect() throws SQLException {
        Statement statement = this.createStatement();
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "insert into t_d_r values (2, default)");
        try {
            statement.execute("insert into t_d_r values (2, default)");
            ForeignKeysDeferrableTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
            ForeignKeysDeferrableTest.assertSQLState(LANG_FK_VIOLATION, (SQLException)((Object)derbySQLIntegrityConstraintViolationException));
            ForeignKeysDeferrableTest.assertEquals((String)"T_D_R", (String)derbySQLIntegrityConstraintViolationException.getTableName());
            ForeignKeysDeferrableTest.assertEquals((String)"C_D_R", (String)derbySQLIntegrityConstraintViolationException.getConstraintName());
        }
        statement.executeUpdate("set constraints c_d_r deferred");
        statement.executeUpdate("insert into t_d_r values (2, default)");
        try {
            this.getConnection().commit();
            ForeignKeysDeferrableTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
            ForeignKeysDeferrableTest.assertSQLState(LANG_DEFERRED_FK_CONSTRAINT_T, (SQLException)((Object)derbySQLIntegrityConstraintViolationException));
            ForeignKeysDeferrableTest.assertEquals((String)"\"APP\".\"T_D_R\"", (String)derbySQLIntegrityConstraintViolationException.getTableName());
            ForeignKeysDeferrableTest.assertEquals((String)"C_D_R", (String)derbySQLIntegrityConstraintViolationException.getConstraintName());
        }
        statement.executeUpdate("set constraints c_d_r deferred");
        statement.executeUpdate("insert into t_d_r values (2, default)");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_r immediate");
        statement.executeUpdate("insert into ref_d_r values (2, default)");
        this.commit();
        statement.executeUpdate("set constraints c_d_r deferred");
        statement.executeUpdate("insert into t_d_r values (2, default)".replaceAll("2", "3"));
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_r immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_r immediate");
        try {
            statement.execute("set constraints c_d_r immediate");
            ForeignKeysDeferrableTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
            ForeignKeysDeferrableTest.assertSQLState(LANG_DEFERRED_FK_CONSTRAINT_S, (SQLException)((Object)derbySQLIntegrityConstraintViolationException));
            ForeignKeysDeferrableTest.assertEquals((String)"\"APP\".\"T_D_R\"", (String)derbySQLIntegrityConstraintViolationException.getTableName());
            ForeignKeysDeferrableTest.assertEquals((String)"C_D_R", (String)derbySQLIntegrityConstraintViolationException.getConstraintName());
        }
        statement.executeUpdate("delete from t_d_r where i=3");
        this.commit();
    }

    public void testInsertDeferred() throws SQLException {
        Statement statement = this.createStatement();
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "insert into t_d_r select i+1,j from t_d_r");
        statement.executeUpdate("set constraints c_d_r deferred");
        statement.executeUpdate("insert into t_d_r select i+1,j from t_d_r");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        statement.executeUpdate("set constraints c_d_r deferred");
        statement.executeUpdate("insert into t_d_r select i+1,j from t_d_r");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_r immediate");
        statement.executeUpdate("insert into ref_d_r values (2, default)");
        this.commit();
        statement.executeUpdate("set constraints c_d_r deferred");
        statement.executeUpdate("insert into t_d_r select i+1,j from t_d_r");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_r immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_r immediate");
        statement.executeUpdate("delete from t_d_r where i=3");
        this.commit();
    }

    public void testUpdateDirect() throws SQLException {
        Statement statement = this.createStatement();
        String[] stringArray = new String[]{"c_u_r", "c_u_na"};
        String[] stringArray2 = new String[]{"update t_u_r set i=2 where j=2", "update t_u_na set i=2 where j=2"};
        for (int i = 0; i < 2; ++i) {
            ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, stringArray2[i]);
            String string = "set constraints " + stringArray[i] + " deferred";
            String string2 = "set constraints " + stringArray[i] + " immediate";
            statement.executeUpdate(string);
            statement.executeUpdate(stringArray2[i]);
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, string2);
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, string2);
            ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        }
    }

    public void testUpdateDeferred() throws SQLException {
        Statement statement = this.createStatement();
        String[] stringArray = new String[]{"c_u_r", "c_u_na"};
        String[] stringArray2 = new String[]{"update t_u_r set i=2 where i=1", "update t_u_na set i=2 where i=1"};
        for (int i = 0; i < 2; ++i) {
            ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, stringArray2[i]);
            String string = "set constraints " + stringArray[i] + " deferred";
            String string2 = "set constraints " + stringArray[i] + " immediate";
            statement.executeUpdate(string);
            statement.executeUpdate(stringArray2[i]);
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, string2);
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, string2);
            ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        }
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "update ref_u_r set i = 2 where i = 1");
        statement.executeUpdate("set constraints c_u_r deferred");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "update ref_u_r set i = 2 where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "update ref_u_na set i = 2 where i = 1");
        statement.executeUpdate("set constraints c_u_na deferred");
        statement.executeUpdate("update ref_u_na set i = 2 where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_u_na immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_u_na immediate");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        statement.executeUpdate("set constraints c_u_na deferred");
        statement.executeUpdate("update ref_u_na set i = 2 where i = 1");
        statement.executeUpdate("update ref_u_na set i=1 where i=2");
        this.commit();
        statement.executeUpdate("set constraints c_u_na deferred");
        statement.executeUpdate("update t_u_na set i=2 where i=1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_u_na immediate");
        statement.executeUpdate("update t_u_na set i=1 where i=2");
        this.commit();
    }

    public void testDeleteDirect() throws SQLException {
        Statement statement = this.createStatement();
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "delete from ref_d_r where i = 1");
        statement.executeUpdate("set constraints c_d_r deferred");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "delete from ref_d_r where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "delete from ref_d_na where i = 1");
        statement.executeUpdate("set constraints c_d_na deferred");
        statement.executeUpdate("delete from ref_d_na where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_na immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_na immediate");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        statement.executeUpdate("set constraints c_d_na deferred");
        statement.executeUpdate("delete from ref_d_na where i = 1");
        statement.executeUpdate("delete from t_d_na where i=1");
        this.commit();
        statement.executeUpdate("insert into ref_d_na values (1, default)");
        statement.executeUpdate("insert into t_d_na values (1, default)");
        this.commit();
        statement.executeUpdate("set constraints c_d_na deferred");
        statement.executeUpdate("delete from ref_d_na where i = 1");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_na immediate");
        statement.executeUpdate("insert into ref_d_na values (1, default)");
        this.commit();
        statement.executeUpdate("delete from ref_d_c where i = 1");
        JDBC.assertEmpty(statement.executeQuery("select * from t_d_c"));
        this.rollback();
        statement.executeUpdate("set constraints c_d_c deferred");
        statement.executeUpdate("delete from ref_d_c where i = 1");
        JDBC.assertEmpty(statement.executeQuery("select * from t_d_c"));
        this.commit();
        statement.executeUpdate("delete from ref_d_nu where i = 1");
        this.assertResults(statement.executeQuery("select i from t_d_nu"), new String[][]{{null}}, false);
        this.rollback();
        statement.executeUpdate("set constraints c_d_nu deferred");
        statement.executeUpdate("delete from ref_d_nu where i = 1");
        this.assertResults(statement.executeQuery("select i from t_d_nu"), new String[][]{{null}}, false);
        this.commit();
    }

    public void testDeleteDeferred() throws SQLException {
        Statement statement = this.createStatement();
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "delete from ref_d_r where i = 1 and     i in (select i from ref_d_r)");
        statement.executeUpdate("set constraints c_d_r deferred");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "delete from ref_d_r where i = 1 and     i in (select i from ref_d_r)");
        ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "delete from ref_d_na where i = 1 and     i in (select i from ref_d_na)");
        statement.executeUpdate("set constraints c_d_na deferred");
        statement.executeUpdate("delete from ref_d_na where i = 1 and     i in (select i from ref_d_na)");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_na immediate");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_na immediate");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        statement.executeUpdate("set constraints c_d_na deferred");
        statement.executeUpdate("delete from ref_d_na where i = 1 and     i in (select i from ref_d_na)");
        statement.executeUpdate("delete from t_d_na where i=1");
        this.commit();
        statement.executeUpdate("insert into ref_d_na values (1, default)");
        statement.executeUpdate("insert into t_d_na values (1, default)");
        this.commit();
        statement.executeUpdate("set constraints c_d_na deferred");
        statement.executeUpdate("delete from ref_d_na where i = 1 and     i in (select i from ref_d_na)");
        ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_S, statement, "set constraints c_d_na immediate");
        statement.executeUpdate("insert into ref_d_na values (1, default)");
        this.commit();
        statement.executeUpdate("delete from ref_d_c where i = 1 and     i in (select i from ref_d_c)");
        JDBC.assertEmpty(statement.executeQuery("select * from t_d_c"));
        this.rollback();
        statement.executeUpdate("set constraints c_d_c deferred");
        statement.executeUpdate("delete from ref_d_c where i = 1 and     i in (select i from ref_d_c)");
        JDBC.assertEmpty(statement.executeQuery("select * from t_d_c"));
        this.commit();
        statement.executeUpdate("delete from ref_d_nu where i = 1 and     i in (select i from ref_d_nu)");
        this.assertResults(statement.executeQuery("select i from t_d_nu"), new String[][]{{null}}, false);
        this.rollback();
        statement.executeUpdate("set constraints c_d_nu deferred");
        statement.executeUpdate("delete from ref_d_nu where i = 1 and     i in (select i from ref_d_nu)");
        this.assertResults(statement.executeQuery("select i from t_d_nu"), new String[][]{{null}}, false);
        this.commit();
    }

    public void testBulkInsert() throws SQLException {
        Statement statement = this.createStatement();
        for (int i = 0; i < 2; ++i) {
            ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T_D_R' , '" + expImpDataFile + "',    null, null , null, " + i + ")");
            statement.executeUpdate("set constraints c_d_r deferred");
            ForeignKeysDeferrableTest.assertStatementError(LANG_DEFERRED_FK_CONSTRAINT_T, statement, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T_D_R' , '" + expImpDataFile + "',    null, null , null, " + i + ")");
        }
    }

    public void testAddConstraint() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t2(i int)");
        try {
            statement.executeUpdate("insert into t2 values 1,2");
            this.commit();
            ForeignKeysDeferrableTest.assertStatementError(LANG_ADD_FK_CONSTRAINT_VIOLATION, statement, "alter table t2 add constraint     c2 foreign key(i) references ref_d_r(i)");
            statement.executeUpdate("delete from t2 where i=2");
            statement.executeUpdate("alter table t2 add constraint c2 foreign key(i) references ref_d_r(i)");
            this.rollback();
            statement.executeUpdate("delete from t2");
            statement.executeUpdate("insert into t2 values 1,2");
            this.commit();
            statement.executeUpdate("alter table t2 add constraint     c2 foreign key(i) references ref_d_r(i)     initially deferred");
            ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        }
        finally {
            this.dropTable("t2");
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFKPlusUnique() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = null;
        try {
            String[] stringArray;
            for (String string : stringArray = new String[]{"ON DELETE NO ACTION ON UPDATE NO ACTION", "ON DELETE RESTRICT ON UPDATE RESTRICT"}) {
                statement.executeUpdate("create table ref_t(i int, j int, constraint ct     primary key(i) deferrable initially deferred)");
                statement.executeUpdate("create table t(i int unique not null, c char(1),    constraint c foreign key (i) references ref_t(i) " + string + ")");
                statement.executeUpdate("insert into ref_t values (1,2),(1,3),(1,4)");
                statement.executeUpdate("insert into t values (1, 'c')");
                resultSet = statement.executeQuery("select * from ref_t");
                resultSet.next();
                resultSet.deleteRow();
                resultSet.next();
                resultSet.deleteRow();
                this.commit();
                statement.executeUpdate("insert into ref_t values (1,5),(1,6)");
                statement.executeUpdate("delete from ref_t where j > 4 ");
                this.commit();
                statement.executeUpdate("insert into ref_t values (1,3)");
                resultSet = statement.executeQuery("select * from ref_t");
                resultSet.next();
                resultSet.deleteRow();
                resultSet.next();
                try {
                    resultSet.deleteRow();
                    ForeignKeysDeferrableTest.fail();
                }
                catch (SQLException sQLException) {
                    ForeignKeysDeferrableTest.assertSQLState(LANG_FK_VIOLATION, sQLException);
                }
                statement.executeUpdate("insert into ref_t values (1,4), (1,5)");
                ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "delete from ref_t");
                ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "delete from ref_t where i = 1 and     i in (select i from ref_t)");
                statement.executeUpdate("delete from ref_t where i = 1 and     i in (select i from ref_t) and j >= 4");
                statement.executeUpdate("insert into ref_t values (1,4), (1,5)");
                statement.executeUpdate("delete from ref_t where j >= 4");
                JDBC.assertFullResultSet(statement.executeQuery("select * from ref_t"), new String[][]{{"1", "3"}});
                this.commit();
                statement.executeUpdate("insert into ref_t values (1,4)");
                statement.executeUpdate("update ref_t set i = 2 where j = 4");
                statement.executeUpdate("insert into ref_t values (1,4)");
                ForeignKeysDeferrableTest.assertStatementError(LANG_FK_VIOLATION, statement, "update ref_t set i = 2");
                resultSet = statement.executeQuery("select * from ref_t");
                resultSet.next();
                resultSet.updateInt(1, 3);
                resultSet.updateRow();
                resultSet.close();
                this.commit();
                this.dropTable("t");
                this.dropTable("ref_t");
                this.commit();
            }
            for (String string : stringArray) {
                String string2;
                statement.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i) initially deferred)");
                statement.executeUpdate("create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k)     references ref_t(k, i)" + string + ")");
                statement.executeUpdate("insert into ref_t values ('a', 100, -1, 1),('a', 100, -2, 1),('a', 100, -3, 1),('a', 100, -1, 2),('a', 100, -2, 3),('a', 100, -3, 3)");
                statement.executeUpdate("insert into t values (-11, 1, -4, 100),(-12, 2, -5, 100),(-13, 3, -6, 100)");
                try {
                    statement.executeUpdate("delete from ref_t where j < -1 and     k in (select k from ref_t)");
                    ForeignKeysDeferrableTest.fail();
                }
                catch (SQLException sQLException) {
                    ForeignKeysDeferrableTest.assertSQLState(LANG_FK_VIOLATION, sQLException);
                    string2 = "DELETE on table 'REF_T' caused a violation of foreign key constraint 'C2' for key (3,100).  The statement has been rolled back.";
                    ForeignKeysDeferrableTest.assertEquals((String)string2, (String)sQLException.getMessage());
                }
                statement.executeUpdate("delete from ref_t where j < -1 and     k in (select k from ref_t where k < 3)");
                statement.executeUpdate("delete from ref_t where j < -2 and     k in (select k from ref_t where k >= 3)");
                this.commit();
                this.dropTable("t");
                this.dropTable("ref_t");
                this.commit();
                statement.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i) initially deferred)");
                statement.executeUpdate("create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k)     references ref_t(k, i)" + string + ")");
                statement.executeUpdate("insert into ref_t values ('a', 100, -1, 1),('a', 100, -2, 1),('a', 100, -3, 1),('a', 100, -1, 2),('a', 100, -2, 3),('a', 100, -3, 3)");
                statement.executeUpdate("insert into t values (-11, 1, -4, 100),(-12, 2, -5, 100),(-13, 3, -6, 100)");
                try {
                    statement.executeUpdate("update ref_t set k=k*100 where j < -1 and     k in (select k from ref_t)");
                    ForeignKeysDeferrableTest.fail();
                }
                catch (SQLException sQLException) {
                    ForeignKeysDeferrableTest.assertSQLState(LANG_FK_VIOLATION, sQLException);
                    string2 = "UPDATE on table 'REF_T' caused a violation of foreign key constraint 'C2' for key (3,100).  The statement has been rolled back.";
                    ForeignKeysDeferrableTest.assertEquals((String)string2, (String)sQLException.getMessage());
                }
                statement.executeUpdate("update ref_t set k=k*100 where j < -1 and     k in (select k from ref_t where k < 3)");
                statement.executeUpdate("update ref_t set k=k*100 where j < -2 and     k in (select k from ref_t where k >= 3)");
                this.dropTable("t");
                this.dropTable("ref_t");
                this.commit();
            }
            statement.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i))");
            statement.executeUpdate("create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k) references ref_t(k, i)     on delete cascade)");
            statement.executeUpdate("insert into ref_t values ('a', 100, -3, 3)");
            statement.executeUpdate("insert into t values (-11, 3, -4, 100)");
            statement.executeUpdate("delete from ref_t where j < -1 and     k in (select k from ref_t)");
            JDBC.assertEmpty(statement.executeQuery("select * from ref_t"));
            JDBC.assertEmpty(statement.executeQuery("select * from t"));
            this.dropTable("t");
            this.dropTable("ref_t");
            this.commit();
            statement.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i) initially deferred)");
            ForeignKeysDeferrableTest.assertStatementError("X0Y47", statement, "create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k) references ref_t(k, i)     on delete cascade)");
            this.dropTable("t");
            this.dropTable("ref_t");
            this.commit();
            statement.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i))");
            statement.executeUpdate("create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k) references ref_t(k, i)     on delete set null)");
            statement.executeUpdate("insert into ref_t values ('a', 100, -3, 3)");
            statement.executeUpdate("insert into t values (-11, 3, -4, 100)");
            statement.executeUpdate("delete from ref_t");
            JDBC.assertEmpty(statement.executeQuery("select * from ref_t"));
            JDBC.assertFullResultSet(statement.executeQuery("select * from t"), new String[][]{{"-11", null, "-4", null}});
            this.dropTable("t");
            this.dropTable("ref_t");
            this.commit();
            statement.executeUpdate("create table ref_t(c char(1), i int, j int, k int,    constraint c primary key (k, i) initially deferred)");
            ForeignKeysDeferrableTest.assertStatementError("X0Y47", statement, "create table t(l bigint, i int, j int, k int,    constraint c2 foreign key(i,k) references ref_t(k, i)     on delete set null)");
            this.commit();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            this.dropTable("t");
            this.dropTable("ref_t");
            this.commit();
        }
    }

    public void testSelfReferential() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("create table t(name varchar(10) primary key                    deferrable initially deferred,               boss varchar(10) references t(name)                    on delete restrict, i int)");
            statement.executeUpdate("insert into t values ('daisy', null, 1)");
            statement.executeUpdate("insert into t values ('daisy', null, 2)");
            statement.executeUpdate("insert into t values ('donald', 'daisy', 3)");
            statement.executeUpdate("delete from t where name like 'daisy%' and i = 1");
            JDBC.assertFullResultSet(statement.executeQuery("select * from t"), new String[][]{{"daisy", null, "2"}, {"donald", "daisy", "3"}});
            this.commit();
            statement.executeUpdate("create table employees(name char(40),     constraint ec primary key(name) initially deferred,     address char(40))");
            ForeignKeysDeferrableTest.assertStatementError("X0Y47", statement, "create table teammember(name char(40) primary key references employees(name) on delete cascade, boss char(40) references teammember(name) on delete cascade)");
        }
        finally {
            this.dropTable("t");
            this.dropTable("employees");
            this.dropTable("teammember");
            this.commit();
        }
    }

    public void testInsertTrigger() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d6664_t1(pk int primary key)");
        statement.execute("create table d6664_t2(x int references d6664_t1 initially deferred)");
        statement.execute("create table d6664_t3(y int)");
        statement.execute("create trigger d6664_tr after insert on d6664_t3 referencing new as new for each row insert into d6664_t2 values new.y");
        statement.execute("insert into d6664_t3 values 1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from d6664_t2"), "1");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
    }

    public void test_6668() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create table tunique_6668\n(\n  a int not null unique\n)\n");
        this.goodStatement(connection, "create table tref_6668\n(\n  a int references tunique_6668( a ) initially deferred\n)\n");
        ForeignKeysDeferrableTest.assertStatementError("XCL48", connection.prepareStatement("truncate table tunique_6668"));
    }

    public void testSharedConglomerates() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d6665_t1(x int primary key)");
        statement.execute("create table d6665_t2(x int primary key)");
        statement.execute("create table d6665_t3(x int references d6665_t1 initially deferred references d6665_t2 initially deferred)");
        statement.execute("insert into d6665_t1 values 1");
        statement.execute("insert into d6665_t3 values 1");
        statement.execute("insert into d6665_t2 values 1");
        statement.execute("delete from d6665_t1");
        ForeignKeysDeferrableTest.assertCommitError(LANG_DEFERRED_FK_CONSTRAINT_T, this.getConnection());
        statement.execute("create table d6665_t4(x int primary key)");
        statement.execute("create table d6665_t5(x int primary key initially deferred references d6665_t4 initially deferred)");
        statement.execute("insert into d6665_t5 values 1");
        statement.execute("insert into d6665_t4 values 1");
        statement.execute("insert into d6665_t5 values 1");
        try {
            this.getConnection().commit();
            ForeignKeysDeferrableTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
            ForeignKeysDeferrableTest.assertSQLState(LANG_DEFERRED_DUPLICATE_KEY_CONSTRAINT_T, (SQLException)((Object)derbySQLIntegrityConstraintViolationException));
            ForeignKeysDeferrableTest.assertEquals((String)"D6665_T5", (String)derbySQLIntegrityConstraintViolationException.getTableName());
            ForeignKeysDeferrableTest.assertTrue((boolean)derbySQLIntegrityConstraintViolationException.getConstraintName().startsWith("SQL"));
        }
    }

    public void testDerby6918() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create schema \"1.a\"");
        statement.execute("create table \"1.a\".\"role\" ( \"id\" integer generated always as identity,  \"name\" varchar(255) not null)");
        statement.execute("alter table \"1.a\".\"role\"   add constraint \"role_pk\" primary key (\"id\")");
        statement.execute("create table \"1.a\".\"user\" ( \"id\" integer generated always as identity,   \"name\" varchar(255) not null)");
        statement.execute("alter table \"1.a\".\"user\"   add constraint \"user_pk\" primary key (\"id\")");
        statement.execute("create table \"1.a\".\"user_role\"  ( \"role\" integer not null,   \"user\" integer not null)");
        statement.execute("alter table \"1.a\".\"user_role\" add constraint \"user_role_fk1\"      foreign key (\"role\")      references \"1.a\".\"role\" (\"id\")     on delete cascade");
        statement.execute("alter table \"1.a\".\"user_role\" add constraint \"user_role_fk2\"     foreign key (\"user\")     references \"1.a\".\"user\" (\"id\")     on delete cascade");
        statement.execute("alter table \"1.a\".\"user_role\"  add constraint \"user_role_u1\"      unique (\"user\", \"role\")");
        statement.execute("insert into \"1.a\".\"role\" (\"name\") values ('r1')");
        statement.execute("insert into \"1.a\".\"user\" (\"name\") values ('u1')");
        statement.execute("insert into \"1.a\".\"user_role\" (\"role\",\"user\") values (1,1)");
        statement.execute("select * from \"1.a\".\"user\"");
        statement.execute("delete from \"1.a\".\"user\"");
    }

    static {
        exportFilesCreatedEmbedded = false;
        exportFilesCreatedClient = false;
    }
}

