/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BootAllTest
extends BaseJDBCTestCase {
    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("BootAllTest");
        if (JDBC.vmSupportsJDBC3()) {
            BaseTestSuite baseTestSuite2 = new BaseTestSuite("db3");
            baseTestSuite2.addTest((Test)new BootAllTest("createShutdownDatabase"));
            baseTestSuite2.addTest((Test)new BootAllTest("shutdownDerby"));
            Properties properties = new Properties();
            properties.setProperty("derby.system.bootAll", "true");
            baseTestSuite2.addTest((Test)new SystemPropertyTestSetup((Test)new BootAllTest("testSettingBootAllPropertyWithHomePropertySet"), properties));
            BaseTestSuite baseTestSuite3 = new BaseTestSuite("db2");
            baseTestSuite3.addTest((Test)new BootAllTest("createShutdownDatabase"));
            baseTestSuite3.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite2));
            BaseTestSuite baseTestSuite4 = new BaseTestSuite("db1");
            baseTestSuite4.addTest((Test)new BootAllTest("createShutdownDatabase"));
            baseTestSuite4.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite3));
            baseTestSuite.addTest((Test)new BootAllTest("createShutdownDatabase"));
            baseTestSuite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite4));
        }
        return baseTestSuite;
    }

    public BootAllTest(String string) {
        super(string);
    }

    public void createShutdownDatabase() throws SQLException {
        this.getConnection().close();
        this.getTestConfiguration().shutdownDatabase();
    }

    public void shutdownDerby() {
        this.getTestConfiguration().shutdownEngine();
        System.runFinalization();
        System.gc();
    }

    public void testSettingBootAllPropertyWithHomePropertySet() throws Exception {
        JDBCClient jDBCClient = this.getTestConfiguration().getJDBCClient();
        String string = jDBCClient.getJDBCDriverName();
        String string2 = jDBCClient.getUrlBase();
        try {
            DriverManager.getDriver(string2);
            BootAllTest.fail((String)"Derby is booted!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Class<?> clazz = Class.forName(string);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Driver driver = DriverManager.getDriver(string2);
        DriverPropertyInfo[] driverPropertyInfoArray = driver.getPropertyInfo(string2, null);
        String[] stringArray = null;
        for (int i = 0; i < driverPropertyInfoArray.length; ++i) {
            if (!driverPropertyInfoArray[i].name.equalsIgnoreCase("databaseName")) continue;
            stringArray = driverPropertyInfoArray[i].choices;
        }
        BootAllTest.assertNotNull(stringArray);
        BootAllTest.assertTrue((String)"Fewer databases booted than expected", (stringArray.length >= 1 ? 1 : 0) != 0);
    }
}

