/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DerbyVersion;

abstract class UpgradeChange
extends BaseJDBCTestCase {
    static final ThreadLocal<Integer> phase = new ThreadLocal();
    static final ThreadLocal<int[]> oldVersion = new ThreadLocal();
    static final String SQLSTATE_NEED_UPGRADE = "XCL47";
    static final String[] PHASES = new String[]{"CREATE", "SOFT UPGRADE", "POST SOFT UPGRADE", "UPGRADE", "POST UPGRADE"};
    static final int PH_CREATE = 0;
    static final int PH_SOFT_UPGRADE = 1;
    static final int PH_POST_SOFT_UPGRADE = 2;
    static final int PH_HARD_UPGRADE = 3;
    static final int PH_POST_HARD_UPGRADE = 4;

    public UpgradeChange(String string) {
        super(string);
    }

    final int getPhase() {
        return phase.get();
    }

    final DerbyVersion getOldVersion() {
        return new DerbyVersion(this.getOldMajor(), this.getOldMinor(), this.getOldFixPack(), this.getOldPoint());
    }

    final int getOldMajor() {
        return oldVersion.get()[0];
    }

    final int getOldMinor() {
        return oldVersion.get()[1];
    }

    final int getOldFixPack() {
        return oldVersion.get()[2];
    }

    final int getOldPoint() {
        return oldVersion.get()[3];
    }

    boolean oldAtLeast(int n, int n2) {
        if (this.getOldMajor() > n) {
            return true;
        }
        return this.getOldMajor() == n && this.getOldMinor() >= n2;
    }

    boolean oldLessThan(int n, int n2, int n3, int n4) {
        int[] nArray = oldVersion.get();
        int[] nArray2 = new int[]{n, n2, n3, n4};
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < nArray2[i]) {
                return true;
            }
            if (nArray[i] <= nArray2[i]) continue;
            return false;
        }
        return false;
    }

    boolean oldIs(int n, int n2, int n3, int n4) {
        return this.getOldMajor() == n && this.getOldMinor() == n2 && this.getOldFixPack() == n3 && this.getOldPoint() == n4;
    }

    boolean oldIs(int n, int n2) {
        return this.getOldMajor() == n && this.getOldMinor() == n2;
    }

    String getPhaseString() {
        return PHASES[this.getPhase()];
    }

    String getOldVersionString() {
        return "( " + this.getOldMajor() + ", " + this.getOldMinor() + ", " + this.getOldFixPack() + ", " + this.getOldPoint() + " )";
    }
}

