/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.perf.basic.jdbc.BaseLoad100TestSetup;

public class HeapScan
extends JDBCPerfTestCase {
    PreparedStatement select = null;
    private PreparedStatement selectWithPred;
    protected static String tableName = "SCANTEST";
    protected static int rowcount = 10000;
    private boolean binaryData;

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("HeapScanTests");
        baseTestSuite.addTest(HeapScan.baseSuite("HeapScan:CHAR", false));
        baseTestSuite.addTest(HeapScan.baseSuite("HeapScan:BINARY", true));
        return baseTestSuite;
    }

    private static Test baseSuite(String string, boolean bl) {
        int n = 700;
        int n2 = 4;
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTest((Test)new HeapScan("Scan100", bl, n, n2));
        baseTestSuite.addTest((Test)new HeapScan("Scan100GetData", bl, n, n2));
        baseTestSuite.addTest((Test)new HeapScan("Scan100WithPredicate", bl, n, n2));
        return new BaseLoad100TestSetup((Test)baseTestSuite, rowcount, tableName, bl);
    }

    public HeapScan(String string, int n, int n2) {
        this(string, false, n, n2);
    }

    public HeapScan(String string, boolean bl, int n, int n2) {
        super(string, n, n2);
        this.binaryData = bl;
    }

    public void setUp() throws Exception {
        this.select = this.prepareStatement("SELECT * FROM " + tableName);
        this.selectWithPred = this.prepareStatement("SELECT * FROM " + tableName + " WHERE c6=? OR c7=? OR c8=? OR c9=?");
        Object object = "abcdef";
        if (this.binaryData) {
            object = ((String)object).getBytes("US-ASCII");
        }
        for (int i = 1; i <= 4; ++i) {
            this.selectWithPred.setObject(i, object);
        }
    }

    @Override
    public void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public void Scan100() throws Exception {
        ResultSet resultSet = this.select.executeQuery();
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        HeapScan.assertEquals((int)n, (int)rowcount);
        resultSet.close();
        this.commit();
    }

    public void Scan100GetData() throws Exception {
        ResultSet resultSet = this.select.executeQuery();
        int n = 0;
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            int n3 = resultSet.getInt(2);
            int n4 = resultSet.getInt(3);
            int n5 = resultSet.getInt(4);
            int n6 = resultSet.getInt(5);
            Object object = resultSet.getObject(6);
            Object object2 = resultSet.getObject(7);
            Object object3 = resultSet.getObject(8);
            Object object4 = resultSet.getObject(9);
            ++n;
        }
        HeapScan.assertEquals((int)n, (int)rowcount);
        resultSet.close();
        this.commit();
    }

    public void Scan100WithPredicate() throws SQLException {
        ResultSet resultSet = this.selectWithPred.executeQuery();
        HeapScan.assertFalse((String)"should be empty", (boolean)resultSet.next());
        resultSet.close();
        this.commit();
    }

    @Override
    public void tearDown() throws Exception {
        this.select = null;
        this.selectWithPred = null;
        super.tearDown();
    }
}

