/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InternationalConnectTest
extends BaseJDBCTestCase {
    private ArrayList<String> databasesForCleanup = new ArrayList();

    public InternationalConnectTest(String string) {
        super(string);
    }

    public void testBoundaries() throws SQLException, UnsupportedEncodingException {
        if (InternationalConnectTest.usingEmbedded()) {
            return;
        }
        String string = "memory:/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa;create=true";
        String string2 = "memory:/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa;create=true";
        String string3 = TestConfiguration.getCurrent().getJDBCUrl(string);
        this.loadDriver(string3);
        Connection connection = DriverManager.getConnection(string3);
        connection.close();
        string3 = TestConfiguration.getCurrent().getJDBCUrl(string2);
        try {
            connection = DriverManager.getConnection(string3);
            InternationalConnectTest.assertTrue((String)"Used more characters than possible in database name", (boolean)false);
        }
        catch (SQLException sQLException) {
            InternationalConnectTest.assertSQLState("08001", sQLException);
        }
    }

    private void loadDriver(String string) throws SQLException {
        try {
            DriverManager.getDriver(string);
        }
        catch (SQLException sQLException) {
            InternationalConnectTest.assertSQLState("Unexpected SQLState from getDriver().", "08001", sQLException);
            InternationalConnectTest.assertEquals((String)"Unexpected exception message from getDriver(), ", (String)"No suitable driver", (String)sQLException.getMessage());
            String string2 = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
            InternationalConnectTest.println("Loading JDBC driver " + string2);
            try {
                Class<?> clazz = Class.forName(string2);
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException("Failed to load JDBC driver '" + string2 + "', ClassNotFoundException: " + classNotFoundException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException("Failed to load JDBC driver '" + string2 + "', IllegalAccessException: " + illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Failed to load JDBC driver '" + string2 + "', InstantiationException: " + instantiationException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SQLException("Failed to load JDBC driver '" + string2 + "', InstantiationException: " + noSuchMethodException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException("Failed to load JDBC driver '" + string2 + "', InstantiationException: " + invocationTargetException.getMessage());
            }
        }
    }

    public void testDriverManagerConnect() throws SQLException {
        this.getConnection();
        Connection connection = null;
        String string = null;
        string = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;create=true");
        connection = DriverManager.getConnection(string);
        connection.close();
        string = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;user=\u4e10");
        connection = DriverManager.getConnection(string);
        connection.close();
        string = TestConfiguration.getCurrent().getJDBCUrl("\u4e10");
        connection = DriverManager.getConnection(string, "\u4e10", "pass");
        connection.close();
        string = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;user=user;password=\u4e10");
        connection = DriverManager.getConnection(string);
        connection.close();
        string = TestConfiguration.getCurrent().getJDBCUrl("\u4e10");
        connection = DriverManager.getConnection(string, "\u4e10", "\u4e10");
        connection.close();
        this.databasesForCleanup.add("\u4e10");
    }

    public void testXADSConnect() throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "\u4e10");
        J2EEDataSource.setBeanProperty(xADataSource, "createDatabase", "create");
        XAConnection xAConnection = xADataSource.getXAConnection();
        Connection connection = xAConnection.getConnection();
        connection.close();
        xAConnection.close();
        J2EEDataSource.setBeanProperty(xADataSource, "user", "\u4e10");
        xAConnection = xADataSource.getXAConnection();
        connection = xAConnection.getConnection();
        connection.close();
        xAConnection.close();
        J2EEDataSource.setBeanProperty(xADataSource, "password", "\u4e10");
        xAConnection = xADataSource.getXAConnection();
        connection = xAConnection.getConnection();
        connection.close();
        xAConnection.close();
        this.databasesForCleanup.add("\u4e10");
    }

    public void testCPDSConnect() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        J2EEDataSource.setBeanProperty(connectionPoolDataSource, "databaseName", "\u4e10");
        J2EEDataSource.setBeanProperty(connectionPoolDataSource, "createDatabase", "create");
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        connection.close();
        pooledConnection.close();
        J2EEDataSource.setBeanProperty(connectionPoolDataSource, "user", "\u4e10");
        pooledConnection = connectionPoolDataSource.getPooledConnection();
        connection = pooledConnection.getConnection();
        connection.close();
        pooledConnection.close();
        J2EEDataSource.setBeanProperty(connectionPoolDataSource, "password", "\u4e10");
        pooledConnection = connectionPoolDataSource.getPooledConnection();
        connection = pooledConnection.getConnection();
        connection.close();
        pooledConnection.close();
        this.databasesForCleanup.add("\u4e10");
    }

    public void testFailureOnNonExistentDatabase() throws SQLException {
        String string = TestConfiguration.getCurrent().getJDBCUrl("abcdefghijklmnopq\u00e5");
        try {
            DriverManager.getConnection(string);
            InternationalConnectTest.fail((String)(string + " should not exist"));
        }
        catch (SQLException sQLException) {
            String string2 = InternationalConnectTest.usingEmbedded() ? "XJ004" : "08004";
            InternationalConnectTest.assertSQLState(string2, sQLException);
        }
    }

    @Override
    public void tearDown() throws Exception {
        for (int i = 0; i < this.databasesForCleanup.size(); ++i) {
            String string = TestConfiguration.getCurrent().getJDBCUrl(this.databasesForCleanup.get(i) + ";shutdown=true");
            try {
                DriverManager.getConnection(string);
                InternationalConnectTest.fail((String)"Database didn't shut down");
            }
            catch (SQLException sQLException) {
                InternationalConnectTest.assertSQLState("08006", sQLException);
            }
            InternationalConnectTest.removeDirectory(InternationalConnectTest.getSystemProperty("derby.system.home") + File.separator + this.databasesForCleanup.get(i));
        }
        this.databasesForCleanup = null;
        super.tearDown();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(InternationalConnectTest.class);
    }
}

