/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.data.api.AbstractEntityRepository;
import org.apache.deltaspike.data.api.AbstractFullEntityRepository;
import org.apache.deltaspike.data.api.Repository;

public class RepositoryExtension
implements Extension,
Deactivatable {
    private static final Logger LOG = Logger.getLogger(RepositoryExtension.class.getName());
    private static final ArrayList<Class<?>> REPOSITORY_CLASSES = new ArrayList();
    private final ArrayList<Class<?>> repositoryClasses = new ArrayList();
    private Boolean isActivated = true;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery before) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        if (this.isVetoed(event.getAnnotatedType())) {
            event.veto();
        } else if (this.isRepository(event.getAnnotatedType())) {
            Class repositoryClass = event.getAnnotatedType().getJavaClass();
            LOG.log(Level.FINER, "getHandlerClass: Repository annotation detected on {0}", event.getAnnotatedType());
            if (Deactivatable.class.isAssignableFrom(repositoryClass) && !ClassDeactivationUtils.isActivated((Class)repositoryClass)) {
                LOG.log(Level.FINER, "Class {0} is Deactivated", repositoryClass);
                return;
            }
            this.repositoryClasses.add(repositoryClass);
            REPOSITORY_CLASSES.add(repositoryClass);
        }
    }

    private <X> boolean isRepository(AnnotatedType<X> annotatedType) {
        return (annotatedType.isAnnotationPresent(Repository.class) || annotatedType.getJavaClass().isAnnotationPresent(Repository.class)) && !InvocationHandler.class.isAssignableFrom(annotatedType.getJavaClass());
    }

    private <X> boolean isVetoed(AnnotatedType<X> annotated) {
        Class javaClass = annotated.getJavaClass();
        return javaClass.equals(AbstractEntityRepository.class) || javaClass.equals(AbstractFullEntityRepository.class);
    }

    public ArrayList<Class<?>> getRepositoryClasses() {
        ArrayList result = new ArrayList();
        if (this.repositoryClasses.isEmpty() && !REPOSITORY_CLASSES.isEmpty()) {
            result.addAll(REPOSITORY_CLASSES);
        }
        if (!this.repositoryClasses.isEmpty()) {
            result.addAll(this.repositoryClasses);
        }
        return result;
    }

    protected void cleanup(@Observes BeforeShutdown beforeShutdown) {
        REPOSITORY_CLASSES.clear();
    }
}

