/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.mock;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.testcontrol.api.mock.DynamicMockManager;

public class MockAwareInjectionTargetWrapper<T>
implements InjectionTarget<T> {
    private BeanManager beanManager;
    private final InjectionTarget<T> wrapped;
    private final List<Type> beanTypes;
    private final List<Annotation> qualifiers;

    public MockAwareInjectionTargetWrapper(BeanManager beanManager, InjectionTarget<T> wrapped, List<Type> beanTypes, List<Annotation> qualifiers) {
        this.beanManager = beanManager;
        this.wrapped = wrapped;
        this.beanTypes = beanTypes;
        this.qualifiers = qualifiers;
    }

    public T produce(CreationalContext<T> creationalContext) {
        DynamicMockManager mockManager = (DynamicMockManager)BeanProvider.getContextualReference((BeanManager)this.beanManager, DynamicMockManager.class, (boolean)false, (Annotation[])new Annotation[0]);
        for (Type beanType : this.beanTypes) {
            Object mockInstance = mockManager.getMock((Class)beanType, this.qualifiers.toArray(new Annotation[this.qualifiers.size()]));
            if (mockInstance == null) continue;
            return (T)mockInstance;
        }
        return (T)this.wrapped.produce(creationalContext);
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        this.wrapped.inject(instance, ctx);
    }

    public void postConstruct(T instance) {
        this.wrapped.postConstruct(instance);
    }

    public void preDestroy(T instance) {
        this.wrapped.preDestroy(instance);
    }

    public void dispose(T instance) {
        this.wrapped.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.wrapped.getInjectionPoints();
    }
}

