/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.operators.sort.CircularElement;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.sort.MergeIterator;
import org.apache.flink.runtime.operators.sort.SpillingThread;

final class DefaultSpillingBehaviour<R>
implements SpillingThread.SpillingBehaviour<R> {
    private final boolean objectReuseEnabled;
    private final TypeSerializer<R> serializer;

    DefaultSpillingBehaviour(boolean objectReuseEnabled, TypeSerializer<R> serializer) {
        this.objectReuseEnabled = objectReuseEnabled;
        this.serializer = serializer;
    }

    @Override
    public void spillBuffer(CircularElement<R> element, ChannelWriterOutputView output, LargeRecordHandler<R> largeRecordHandler) throws IOException {
        element.getBuffer().writeToOutput(output, largeRecordHandler);
    }

    @Override
    public void mergeRecords(MergeIterator<R> mergeIterator, ChannelWriterOutputView output) throws IOException {
        if (this.objectReuseEnabled) {
            R rec = this.serializer.createInstance();
            while ((rec = mergeIterator.next(rec)) != null) {
                this.serializer.serialize(rec, output);
            }
        } else {
            R rec;
            while ((rec = mergeIterator.next()) != null) {
                this.serializer.serialize(rec, output);
            }
        }
    }
}

