/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.internet;

import jakarta.activation.DataSource;
import jakarta.mail.MessageAware;
import jakarta.mail.MessageContext;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;

public class MimePartDataSource
implements DataSource,
MessageAware {
    protected MimePart part;

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream stream;
            if (this.part instanceof MimeMessage) {
                stream = ((MimeMessage)this.part).getContentStream();
            } else if (this.part instanceof MimeBodyPart) {
                stream = ((MimeBodyPart)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            return this.checkPartEncoding(this.part, stream);
        }
        catch (MessagingException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private InputStream checkPartEncoding(MimePart part, InputStream stream) throws MessagingException {
        String encoding = part.getEncoding();
        if (encoding == null) {
            return stream;
        }
        if ((encoding = encoding.toLowerCase()).equals("7bit") || encoding.equals("8bit") || encoding.equals("binary")) {
            return stream;
        }
        String contentType = part.getContentType();
        if (contentType != null) {
            try {
                ContentType type = new ContentType(contentType);
                if (type.match("multipart/*")) {
                    return stream;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return MimeUtility.decode(stream, encoding);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public String getName() {
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getFileName();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return "";
    }

    @Override
    public synchronized MessageContext getMessageContext() {
        return new MessageContext(this.part);
    }
}

