/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTE
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestTE();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        AtomicBoolean hasTE = new AtomicBoolean(false);
        AtomicBoolean hasChunk = new AtomicBoolean(false);
        MessageSupport.parseTokens(request, "TE", token -> {
            hasTE.set(true);
            if (token.equalsIgnoreCase("chunked")) {
                hasChunk.set(true);
            }
        });
        if (hasChunk.get()) {
            throw new ProtocolException("'chunked' transfer coding must not be listed in the TE header for HTTP/1.1.");
        }
        if (hasTE.get()) {
            AtomicBoolean hasConnection = new AtomicBoolean(false);
            AtomicBoolean hasTEinConnection = new AtomicBoolean(false);
            MessageSupport.parseTokens(request, "Connection", token -> {
                hasConnection.set(true);
                if ("TE".equalsIgnoreCase((String)token)) {
                    hasTEinConnection.set(true);
                }
            });
            if (!hasTEinConnection.get()) {
                throw new ProtocolException("The 'Connection' header must include the 'TE' directive when the 'TE' header is present.");
            }
        }
    }
}

