/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.metric;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.SystemViewCommand;
import org.apache.ignite.internal.management.SystemViewTask;
import org.apache.ignite.internal.management.api.CliSubcommandsWithPrefix;
import org.apache.ignite.internal.management.api.CommandRegistryImpl;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.metric.MetricCommandArg;
import org.apache.ignite.internal.management.metric.MetricConfigureHistogramCommand;
import org.apache.ignite.internal.management.metric.MetricConfigureHitrateCommand;
import org.apache.ignite.internal.management.metric.MetricTask;

@CliSubcommandsWithPrefix
public class MetricCommand
extends CommandRegistryImpl<MetricCommandArg, Map<String, ?>>
implements ComputeCommand<MetricCommandArg, Map<String, ?>> {
    public MetricCommand() {
        super(new MetricConfigureHistogramCommand(), new MetricConfigureHitrateCommand());
    }

    @Override
    public String description() {
        return "Print metric value";
    }

    @Override
    public Class<MetricCommandArg> argClass() {
        return MetricCommandArg.class;
    }

    @Override
    public Class<MetricTask> taskClass() {
        return MetricTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, MetricCommandArg arg) {
        return CommandUtils.nodeOrNull(arg.nodeId(), nodes);
    }

    @Override
    public void printResult(MetricCommandArg arg, Map<String, ?> res, Consumer<String> printer) {
        if (res != null) {
            List<List<?>> data = res.entrySet().stream().map(entry -> Arrays.asList(entry.getKey(), entry.getValue())).collect(Collectors.toList());
            SystemViewCommand.printTable(Arrays.asList("metric", "value"), Arrays.asList(SystemViewTask.SimpleType.STRING, SystemViewTask.SimpleType.STRING), data, printer);
        } else {
            printer.accept("No metric with specified name was found [name=" + arg.name() + "]");
        }
    }
}

