/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.property;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.property.PropertiesListResult;
import org.apache.ignite.internal.management.property.PropertyListCommandArg;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class PropertiesListTask
extends VisorMultiNodeTask<PropertyListCommandArg, PropertiesListResult, PropertiesListResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<PropertyListCommandArg, PropertiesListResult> job(PropertyListCommandArg arg) {
        return new PropertiesListJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected PropertiesListResult reduce0(List<ComputeJobResult> results) {
        if (results.isEmpty()) {
            throw new IgniteException("Empty job results");
        }
        if (results.size() > 1) {
            throw new IgniteException("Invalid job results: " + results);
        }
        if (results.get(0).getException() != null) {
            throw results.get(0).getException();
        }
        return (PropertiesListResult)results.get(0).getData();
    }

    private static class PropertiesListJob
    extends VisorJob<PropertyListCommandArg, PropertiesListResult> {
        private static final long serialVersionUID = 0L;

        protected PropertiesListJob(PropertyListCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        public SecurityPermissionSet requiredPermissions() {
            return SecurityPermissionSetBuilder.systemPermissions(SecurityPermission.ADMIN_READ_DISTRIBUTED_PROPERTY);
        }

        @Override
        protected PropertiesListResult run(@Nullable PropertyListCommandArg arg) {
            return new PropertiesListResult(this.ignite.context().distributedConfiguration().properties().stream().map(p -> new T3<String, String, String>(p.getName(), String.valueOf(p.get()), p.description())).sorted(Comparator.comparing(GridTuple3::get1)).collect(Collectors.toList()));
        }
    }
}

