/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricManager;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.Nullable;

public abstract class PushMetricsExporterAdapter
extends IgniteSpiAdapter
implements MetricExporterSpi {
    public static final long DFLT_EXPORT_PERIOD = 60000L;
    protected ReadOnlyMetricManager mreg;
    @Nullable
    protected Predicate<ReadOnlyMetricRegistry> filter;
    private long period = 60000L;
    private ScheduledExecutorService execSvc;
    private ScheduledFuture<?> fut;

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.fut.cancel(false);
        this.execSvc.shutdown();
    }

    public abstract void export();

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getPeriod() {
        return this.period;
    }

    @Override
    public void setMetricRegistry(ReadOnlyMetricManager mreg) {
        this.mreg = mreg;
    }

    @Override
    public void setExportFilter(Predicate<ReadOnlyMetricRegistry> filter) {
        this.filter = filter;
    }

    @Override
    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        super.onContextInitialized0(spiCtx);
        this.execSvc = Executors.newSingleThreadScheduledExecutor(new IgniteThreadFactory(this.igniteInstanceName, "push-metrics-exporter"));
        this.fut = this.execSvc.scheduleWithFixedDelay(() -> {
            try {
                this.export();
            }
            catch (Exception e) {
                this.log.error("Metrics export error. This exporter will be stopped [spiClass=" + this.getClass() + ",name=" + this.getName() + "]", e);
                throw e;
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }
}

