/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.util.HashCalculator;

public class ColocationUtils {
    private ColocationUtils() {
    }

    public static void append(HashCalculator calc, Object v, NativeTypeSpec typeSpec) {
        if (v == null) {
            calc.appendNull();
            return;
        }
        switch (typeSpec) {
            case INT8: {
                calc.appendByte(((Byte)v).byteValue());
                return;
            }
            case INT16: {
                calc.appendShort(((Short)v).shortValue());
                return;
            }
            case INT32: {
                calc.appendInt(((Integer)v).intValue());
                return;
            }
            case INT64: {
                calc.appendLong(((Long)v).longValue());
                return;
            }
            case FLOAT: {
                calc.appendFloat(((Float)v).floatValue());
                return;
            }
            case DOUBLE: {
                calc.appendDouble(((Double)v).doubleValue());
                return;
            }
            case DECIMAL: {
                calc.appendDecimal((BigDecimal)v);
                return;
            }
            case UUID: {
                calc.appendUuid((UUID)v);
                return;
            }
            case STRING: {
                calc.appendString((String)v);
                return;
            }
            case BYTES: {
                calc.appendBytes((byte[])v);
                return;
            }
            case BITMASK: {
                calc.appendBitmask((BitSet)v);
                return;
            }
            case NUMBER: {
                calc.appendNumber((BigInteger)v);
                return;
            }
            case DATE: {
                calc.appendDate((LocalDate)v);
                return;
            }
            case TIME: {
                calc.appendTime((LocalTime)v);
                return;
            }
            case DATETIME: {
                calc.appendDateTime((LocalDateTime)v);
                return;
            }
            case TIMESTAMP: {
                calc.appendTimestamp((Instant)v);
                return;
            }
        }
        throw new IllegalStateException("Unexpected type: " + typeSpec);
    }
}

