/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import java.util.Collection;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.entity.SnapshotMetaBuilder;

class SnapshotMetaDeserializer
implements MessageDeserializer<RaftOutter.SnapshotMeta> {
    private final SnapshotMetaBuilder msg;

    SnapshotMetaDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotMeta();
    }

    public Class<RaftOutter.SnapshotMeta> klass() {
        return RaftOutter.SnapshotMeta.class;
    }

    public RaftOutter.SnapshotMeta getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("lastIncludedIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastIncludedIndex(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("lastIncludedTerm");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastIncludedTerm(tmp);
                reader.incrementState();
            }
            case 2: {
                Collection tmp = reader.readCollection("learnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.learnersList(tmp);
                reader.incrementState();
            }
            case 3: {
                Collection tmp = reader.readCollection("oldLearnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.oldLearnersList(tmp);
                reader.incrementState();
            }
            case 4: {
                Collection tmp = reader.readCollection("oldPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.oldPeersList(tmp);
                reader.incrementState();
            }
            case 5: {
                Collection tmp = reader.readCollection("peersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.peersList(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RaftOutter.SnapshotMeta.class);
    }
}

