/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.command;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.command.SafeTimeSyncCommand;
import org.apache.ignite.internal.replicator.command.SafeTimeSyncCommandBuilder;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;

class SafeTimeSyncCommandDeserializer
implements MessageDeserializer<SafeTimeSyncCommand> {
    private final SafeTimeSyncCommandBuilder msg;

    SafeTimeSyncCommandDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.safeTimeSyncCommand();
    }

    public Class<SafeTimeSyncCommand> klass() {
        return SafeTimeSyncCommand.class;
    }

    public SafeTimeSyncCommand getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                HybridTimestamp tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SafeTimeSyncCommand.class);
    }
}

